/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.table.modelexplorer.handlers;

import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.papyrus.commands.DestroyElementPapyrusCommand;
import org.eclipse.papyrus.commands.wrappers.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.IPageMngr;
import org.eclipse.papyrus.infra.table.instance.papyrustableinstance.PapyrusTableInstance;
import org.eclipse.papyrus.infra.table.modelexplorer.handlers.AbstractTableModelExplorerHandler;

public class DeleteTableHandler
extends AbstractTableModelExplorerHandler {
    protected Command getCommand() {
        TransactionalEditingDomain editingDomain = this.getEditingDomain();
        IPageMngr pageMngr = this.getPageManager();
        List<PapyrusTableInstance> tables = this.getSelectedTables();
        if (editingDomain != null && pageMngr != null && !tables.isEmpty()) {
            CompoundCommand command = new CompoundCommand();
            for (PapyrusTableInstance table : tables) {
                RecordingCommand sashRemoveComd = new RecordingCommand(editingDomain){

                    protected void doExecute() {
                        if (pageMngr.isOpen((Object)table)) {
                            pageMngr.closePage((Object)table);
                        }
                    }
                };
                command.append((Command)sashRemoveComd);
                command.append((Command)new GMFtoEMFCommandWrapper((ICommand)new DestroyElementPapyrusCommand(new DestroyElementRequest((EObject)table, false))));
            }
            return command.isEmpty() ? UnexecutableCommand.INSTANCE : command;
        }
        return UnexecutableCommand.INSTANCE;
    }
}

