/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.widgets.providers;

import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.EncapsulatedContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.FilteredContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.IHierarchicContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.SemanticWorkspaceContentProvider;
import org.eclipse.papyrus.infra.widgets.strategy.ProviderBasedBrowseStrategy;
import org.eclipse.papyrus.infra.widgets.strategy.StrategyBasedContentProvider;
import org.eclipse.papyrus.infra.widgets.strategy.WorkspaceRevealStrategy;

public class WorkspaceContentProvider
extends EncapsulatedContentProvider {
    public WorkspaceContentProvider() {
        super(WorkspaceContentProvider.encapsulateProvider(WorkspaceContentProvider.getSemanticProvider()));
    }

    protected static IHierarchicContentProvider getSemanticProvider() {
        return new SemanticWorkspaceContentProvider();
    }

    protected static IStructuredContentProvider encapsulateProvider(IHierarchicContentProvider provider) {
        ProviderBasedBrowseStrategy browseStrategy = new ProviderBasedBrowseStrategy(provider);
        WorkspaceRevealStrategy revealStrategy = new WorkspaceRevealStrategy(provider);
        StrategyBasedContentProvider strategyProvider = new StrategyBasedContentProvider(browseStrategy, revealStrategy);
        FilteredContentProvider graphicalProvider = new FilteredContentProvider(strategyProvider);
        return graphicalProvider;
    }
}

