/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml.diagram.internalblock.handler;

import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gmf.runtime.common.ui.util.DisplayUtils;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.papyrus.sysml.diagram.internalblock.messages.Messages;
import org.eclipse.papyrus.sysml.diagram.internalblock.ui.InterfaceManagerDialog;
import org.eclipse.papyrus.sysml.portandflows.FlowPort;
import org.eclipse.papyrus.uml.diagram.common.handlers.GraphicalCommandHandler;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.util.UMLUtil;

public class ManageProvidedInterfacesHandler
extends GraphicalCommandHandler {
    protected Command getCommand() throws ExecutionException {
        List selection = this.getSelectedElements();
        if (selection.size() != 1) {
            return UnexecutableCommand.INSTANCE;
        }
        EObject semanticElement = ((IGraphicalEditPart)selection.get(0)).resolveSemanticElement();
        if (!(semanticElement instanceof Port)) {
            return UnexecutableCommand.INSTANCE;
        }
        FlowPort flowPort = (FlowPort)UMLUtil.getStereotypeApplication((Element)((Port)semanticElement), FlowPort.class);
        if (flowPort != null) {
            return UnexecutableCommand.INSTANCE;
        }
        ManageProvidedInterfaceAction action = new ManageProvidedInterfaceAction((IGraphicalEditPart)selection.get(0));
        return action.getCommand();
    }

    public boolean isEnabled() {
        List selection = this.getSelectedElements();
        if (selection.size() != 1) {
            return false;
        }
        EObject semanticElement = ((IGraphicalEditPart)selection.get(0)).resolveSemanticElement();
        if (!(semanticElement instanceof Port)) {
            return false;
        }
        FlowPort flowPort = (FlowPort)UMLUtil.getStereotypeApplication((Element)((Port)semanticElement), FlowPort.class);
        return flowPort == null;
    }

    public class ManageProvidedInterfaceAction {
        private Port port;
        private Type type;

        public ManageProvidedInterfaceAction(IGraphicalEditPart editpart) {
            EObject obj = ((View)editpart.getModel()).getElement();
            Assert.isTrue((boolean)(obj instanceof Port));
            this.port = (Port)obj;
            this.type = this.port.getType();
        }

        public Command getCommand() {
            if (this.type != null && !(this.type instanceof Classifier)) {
                return UnexecutableCommand.INSTANCE;
            }
            if (this.type == null) {
                MessageDialog dialog = new MessageDialog(DisplayUtils.getDefaultShell(), Messages.InterfaceManagerDialog_Title, null, Messages.ManageProvidedInterfacesHandler_TheTypeOfThePortIsNotDefined, 4, new String[]{Messages.ManageProvidedInterfacesHandler_OK}, 0);
                dialog.open();
            } else {
                InterfaceManagerDialog dialog = new InterfaceManagerDialog(DisplayUtils.getDefaultShell(), this.port);
                if (dialog.open() == 0) {
                    return dialog.getCommand();
                }
            }
            return UnexecutableCommand.INSTANCE;
        }
    }
}

