/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml.diagram.internalblock.preferences;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.papyrus.infra.gmfdiag.preferences.utils.PreferenceConstantHelper;
import org.eclipse.papyrus.sysml.diagram.common.preferences.LabelPreferenceHelper;
import org.eclipse.papyrus.sysml.diagram.internalblock.preferences.InternalBlockDiagramLinkPreferencePage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class CustomConnectorPreferencePage
extends InternalBlockDiagramLinkPreferencePage {
    public static String prefKey = "InternalBlock_link_uml_connector";
    public static final Map<String, Boolean> labelDefaultVisibilityMap = new LinkedHashMap<String, Boolean>();
    protected Button bttnName;
    protected Button bttnType;
    protected Button bttnUndefined_Type;
    protected Button bttnSourceMultMultiplicity;
    protected Button bttnSourceMultDefault_Multiplicity;
    protected Button bttnTargetMultMultiplicity;
    protected Button bttnTargetMultDefault_Multiplicity;
    public static String labelKey;
    public static String sourceMultLabelKey;
    public static String targetMultLabelKey;
    private String labelDisplayPreferenceKey = LabelPreferenceHelper.getPreferenceConstant((String)labelKey, (String)"label.display");
    private String sourceMultLabelDisplayPreferenceKey = LabelPreferenceHelper.getPreferenceConstant((String)sourceMultLabelKey, (String)"label.display");
    private String targetMultLabelDisplayPreferenceKey = LabelPreferenceHelper.getPreferenceConstant((String)targetMultLabelKey, (String)"label.display");
    private int labelDisplayValue = this.getPreferenceStore().getInt(this.labelDisplayPreferenceKey);
    private int sourceMultDisplayValue = this.getPreferenceStore().getInt(this.sourceMultLabelDisplayPreferenceKey);
    private int targetMultDisplayValue = this.getPreferenceStore().getInt(this.targetMultLabelDisplayPreferenceKey);

    static {
        labelDefaultVisibilityMap.put("Stereotype", Boolean.TRUE);
        labelDefaultVisibilityMap.put("Label", Boolean.TRUE);
        labelDefaultVisibilityMap.put("SourceMultiplicity", Boolean.TRUE);
        labelDefaultVisibilityMap.put("TargetMultiplicity", Boolean.TRUE);
        Collections.unmodifiableMap(labelDefaultVisibilityMap);
        labelKey = "InternalBlock_link_uml_connector-linklabel_uml_connector_label";
        sourceMultLabelKey = "InternalBlock_link_uml_connector-linklabel_uml_connector_source_multiplicity";
        targetMultLabelKey = "InternalBlock_link_uml_connector-linklabel_uml_connector_target_multiplicity";
    }

    public CustomConnectorPreferencePage() {
        this.setPreferenceKey("InternalBlock_link_uml_connector");
    }

    public static void initDefaults(IPreferenceStore store) {
        store.setDefault(LabelPreferenceHelper.getPreferenceConstant((String)labelKey, (String)"label.display"), 24);
        store.setDefault(LabelPreferenceHelper.getPreferenceConstant((String)sourceMultLabelKey, (String)"label.display"), 32);
        store.setDefault(LabelPreferenceHelper.getPreferenceConstant((String)targetMultLabelKey, (String)"label.display"), 32);
        for (String labelName : labelDefaultVisibilityMap.keySet()) {
            String showLabelKey = PreferenceConstantHelper.getCompartmentElementConstant((String)prefKey, (String)labelName, (int)20);
            store.setDefault(showLabelKey, labelDefaultVisibilityMap.get(labelName).booleanValue());
        }
    }

    protected void initializeLabelsList() {
        for (String name : labelDefaultVisibilityMap.keySet()) {
            this.labelsList.add(name);
        }
    }

    protected void createLabelPreferencesButtons(Composite parent) {
        Group group = new Group(parent, 32);
        group.setText("Label Display");
        group.setLayout((Layout)new FormLayout());
        this.bttnName = this.createLabelCheckButton((Composite)group, "Name", 8);
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.top = new FormAttachment(0, 0);
        this.bttnName.setLayoutData((Object)data);
        this.bttnType = this.createLabelCheckButton((Composite)group, "Type", 16);
        data = new FormData();
        data.left = new FormAttachment((Control)this.bttnName, 85);
        data.top = new FormAttachment(0, 0);
        this.bttnType.setLayoutData((Object)data);
        this.bttnUndefined_Type = this.createLabelCheckButton((Composite)group, "Undefined_Type", 0x200000);
        data = new FormData();
        data.left = new FormAttachment((Control)this.bttnType, 85);
        data.top = new FormAttachment(0, 0);
        this.bttnUndefined_Type.setLayoutData((Object)data);
    }

    protected void createSourceMultLabelPreferencesButtons(Composite parent) {
        Group group = new Group(parent, 32);
        group.setText("Source Multiplicity Label Display");
        group.setLayout((Layout)new FormLayout());
        this.bttnSourceMultMultiplicity = this.createSourceMultCheckButton((Composite)group, "Multiplicity", 32);
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.top = new FormAttachment(0, 0);
        this.bttnSourceMultMultiplicity.setLayoutData((Object)data);
        this.bttnSourceMultDefault_Multiplicity = this.createSourceMultCheckButton((Composite)group, "Default_Multiplicity", 0x100000);
        data = new FormData();
        data.left = new FormAttachment((Control)this.bttnSourceMultMultiplicity, 85);
        data.top = new FormAttachment(0, 0);
        this.bttnSourceMultDefault_Multiplicity.setLayoutData((Object)data);
    }

    protected void createTargetMultLabelPreferencesButtons(Composite parent) {
        Group group = new Group(parent, 32);
        group.setText("Target Multiplicity Label Display");
        group.setLayout((Layout)new FormLayout());
        this.bttnTargetMultMultiplicity = this.createTargetMultCheckButton((Composite)group, "Multiplicity", 32);
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.top = new FormAttachment(0, 0);
        this.bttnTargetMultMultiplicity.setLayoutData((Object)data);
        this.bttnTargetMultDefault_Multiplicity = this.createTargetMultCheckButton((Composite)group, "Default_Multiplicity", 0x100000);
        data = new FormData();
        data.left = new FormAttachment((Control)this.bttnTargetMultMultiplicity, 85);
        data.top = new FormAttachment(0, 0);
        this.bttnTargetMultDefault_Multiplicity.setLayoutData((Object)data);
    }

    protected void createPageContents(Composite parent) {
        super.createPageContents(parent);
        this.createLabelPreferencesButtons(parent);
        this.createSourceMultLabelPreferencesButtons(parent);
        this.createTargetMultLabelPreferencesButtons(parent);
        this.refreshButtons();
    }

    protected void loadDefaultPreferences() {
        this.labelDisplayValue = this.getPreferenceStore().getDefaultInt(this.labelDisplayPreferenceKey);
        this.sourceMultDisplayValue = this.getPreferenceStore().getDefaultInt(this.sourceMultLabelDisplayPreferenceKey);
        this.targetMultDisplayValue = this.getPreferenceStore().getDefaultInt(this.targetMultLabelDisplayPreferenceKey);
        this.refreshButtons();
    }

    protected void performDefaults() {
        this.loadDefaultPreferences();
        super.performDefaults();
    }

    public boolean performOk() {
        this.storePreferences();
        return super.performOk();
    }

    protected void refreshButtons() {
        this.bttnName.setSelection((this.labelDisplayValue & 8) == 8);
        this.bttnType.setSelection((this.labelDisplayValue & 0x10) == 16);
        this.bttnUndefined_Type.setSelection((this.labelDisplayValue & 0x200000) == 0x200000);
        this.bttnSourceMultMultiplicity.setSelection((this.sourceMultDisplayValue & 0x20) == 32);
        this.bttnSourceMultDefault_Multiplicity.setSelection((this.sourceMultDisplayValue & 0x100000) == 0x100000);
        this.bttnTargetMultMultiplicity.setSelection((this.targetMultDisplayValue & 0x20) == 32);
        this.bttnTargetMultDefault_Multiplicity.setSelection((this.targetMultDisplayValue & 0x100000) == 0x100000);
    }

    protected void storePreferences() {
        super.storePreferences();
        IPreferenceStore store = this.getPreferenceStore();
        if (this.labelDisplayValue != store.getInt(this.labelDisplayPreferenceKey)) {
            store.setValue(this.labelDisplayPreferenceKey, this.labelDisplayValue);
        }
        if (this.sourceMultDisplayValue != store.getInt(this.sourceMultLabelDisplayPreferenceKey)) {
            store.setValue(this.sourceMultLabelDisplayPreferenceKey, this.sourceMultDisplayValue);
        }
        if (this.targetMultDisplayValue != store.getInt(this.targetMultLabelDisplayPreferenceKey)) {
            store.setValue(this.targetMultLabelDisplayPreferenceKey, this.targetMultDisplayValue);
        }
    }

    protected Button createLabelCheckButton(Composite parent, String label, int mask) {
        Button button = new Button(parent, 32);
        button.setText(label);
        button.addSelectionListener((SelectionListener)new LabelAppearenceSelectionListener(mask));
        return button;
    }

    protected Button createSourceMultCheckButton(Composite parent, String label, int mask) {
        Button button = new Button(parent, 32);
        button.setText(label);
        button.addSelectionListener((SelectionListener)new SourceMultAppearenceSelectionListener(mask));
        return button;
    }

    protected Button createTargetMultCheckButton(Composite parent, String label, int mask) {
        Button button = new Button(parent, 32);
        button.setText(label);
        button.addSelectionListener((SelectionListener)new TargetMultAppearenceSelectionListener(mask));
        return button;
    }

    private class LabelAppearenceSelectionListener
    implements SelectionListener {
        private final int style;

        public LabelAppearenceSelectionListener(int style) {
            this.style = style;
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            CustomConnectorPreferencePage customConnectorPreferencePage = CustomConnectorPreferencePage.this;
            customConnectorPreferencePage.labelDisplayValue = customConnectorPreferencePage.labelDisplayValue ^ this.style;
            CustomConnectorPreferencePage.this.refreshButtons();
        }
    }

    private class SourceMultAppearenceSelectionListener
    implements SelectionListener {
        private final int style;

        public SourceMultAppearenceSelectionListener(int style) {
            this.style = style;
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            CustomConnectorPreferencePage customConnectorPreferencePage = CustomConnectorPreferencePage.this;
            customConnectorPreferencePage.sourceMultDisplayValue = customConnectorPreferencePage.sourceMultDisplayValue ^ this.style;
            CustomConnectorPreferencePage.this.refreshButtons();
        }
    }

    private class TargetMultAppearenceSelectionListener
    implements SelectionListener {
        private final int style;

        public TargetMultAppearenceSelectionListener(int style) {
            this.style = style;
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            CustomConnectorPreferencePage customConnectorPreferencePage = CustomConnectorPreferencePage.this;
            customConnectorPreferencePage.targetMultDisplayValue = customConnectorPreferencePage.targetMultDisplayValue ^ this.style;
            CustomConnectorPreferencePage.this.refreshButtons();
        }
    }
}

