/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml.service.types.helper.advice;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.AbstractCommand;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.core.util.EMFCoreUtil;
import org.eclipse.gmf.runtime.emf.type.core.ISpecializationType;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.AbstractEditHelperAdvice;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientRelationshipRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrus.sysml.service.types.element.SysMLElementTypes;
import org.eclipse.papyrus.uml.service.types.utils.ElementUtil;
import org.eclipse.papyrus.uml.service.types.utils.NamedElementHelper;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.UMLPackage;

public class PropertyEditHelperAdvice
extends AbstractEditHelperAdvice {
    protected ICommand getBeforeSetCommand(SetRequest request) {
        ICommand gmfCommand = super.getBeforeSetCommand(request);
        EObject elementToEdit = request.getElementToEdit();
        if (elementToEdit instanceof Property && !(elementToEdit instanceof Port) && request.getFeature() == UMLPackage.eINSTANCE.getTypedElement_Type() && request.getValue() instanceof Type) {
            List<Property> currentlyRefactoredElements;
            Property propertyToEdit = (Property)elementToEdit;
            Association relatedAssociation = propertyToEdit.getAssociation();
            if (relatedAssociation == null || !ElementUtil.hasNature((Element)relatedAssociation, (String)"SysML_Nature")) {
                if (relatedAssociation == null && ((ISpecializationType)SysMLElementTypes.BLOCK).getMatcher().matches((EObject)((Type)request.getValue())) && ((ISpecializationType)SysMLElementTypes.BLOCK).getMatcher().matches(propertyToEdit.eContainer())) {
                    ICommand addAssociationCommand = this.getCreatePartAssociationCommand((Class)propertyToEdit.eContainer(), propertyToEdit, (Class)request.getValue());
                    gmfCommand = CompositeCommand.compose((ICommand)gmfCommand, (ICommand)addAssociationCommand);
                }
                return gmfCommand;
            }
            if (!((ISpecializationType)SysMLElementTypes.BLOCK).getMatcher().matches((EObject)((Type)request.getValue()))) {
                ICommand destroyCommand = this.getDestroyPartAssociationCommand(relatedAssociation, propertyToEdit);
                gmfCommand = CompositeCommand.compose((ICommand)gmfCommand, (ICommand)destroyCommand);
                return gmfCommand;
            }
            List list = currentlyRefactoredElements = request.getParameter("ASSOCIATION_REFACTORED_ELEMENTS") != null ? (List)request.getParameter("ASSOCIATION_REFACTORED_ELEMENTS") : new ArrayList();
            if (!currentlyRefactoredElements.contains(propertyToEdit)) {
                currentlyRefactoredElements.add(propertyToEdit);
                request.getParameters().put("ASSOCIATION_REFACTORED_ELEMENTS", currentlyRefactoredElements);
                if (currentlyRefactoredElements.contains(relatedAssociation)) {
                    return gmfCommand;
                }
            }
            ICommand refactorCommand = this.getAssociationRefactoringCommand(propertyToEdit, relatedAssociation, request);
            gmfCommand = CompositeCommand.compose((ICommand)gmfCommand, (ICommand)refactorCommand);
        }
        if (gmfCommand != null) {
            gmfCommand = gmfCommand.reduce();
        }
        return gmfCommand;
    }

    private ICommand getAssociationRefactoringCommand(Property setProperty, Association associationToRefactor, SetRequest request) {
        Association relatedAssociation = setProperty.getAssociation();
        int direction = 2;
        if (setProperty == associationToRefactor.getMemberEnds().get(1)) {
            direction = 1;
        }
        ReorientRelationshipRequest reorientRequest = new ReorientRelationshipRequest((EObject)relatedAssociation, (EObject)((Type)request.getValue()), setProperty.eContainer(), direction);
        reorientRequest.addParameters(request.getParameters());
        IElementEditService provider = ElementEditServiceUtils.getCommandProvider((Object)relatedAssociation);
        if (provider != null) {
            return provider.getEditCommand((IEditCommandRequest)reorientRequest);
        }
        return null;
    }

    private ICommand getCreatePartAssociationCommand(final Class sourceBlock, final Property sourceProperty, final Class targetBlock) {
        return new AbstractCommand("Create part association"){

            protected CommandResult doUndoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
                return null;
            }

            protected CommandResult doRedoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
                return null;
            }

            protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
                Association association = UMLFactory.eINSTANCE.createAssociation();
                Package container = (Package)EMFCoreUtil.getLeastCommonContainer(Arrays.asList(sourceBlock, targetBlock), (EClass)UMLPackage.eINSTANCE.getPackage());
                container.getPackagedElements().add((Object)association);
                association.getMemberEnds().add((Object)sourceProperty);
                Property targetProperty = UMLFactory.eINSTANCE.createProperty();
                association.getOwnedEnds().add((Object)targetProperty);
                String initializedName = NamedElementHelper.getDefaultNameWithIncrementFromBase((String)UMLPackage.eINSTANCE.getAssociation().getName(), (Collection)association.eContainer().eContents());
                association.setName(initializedName);
                ElementUtil.addNature((Element)association, (String)"SysML_Nature");
                return CommandResult.newOKCommandResult((Object)association);
            }
        };
    }

    private ICommand getDestroyPartAssociationCommand(Association partAssociation, Property propertyToEdit) {
        DestroyElementRequest request = new DestroyElementRequest((EObject)partAssociation, false);
        List<EObject> dependentsToKeep = Arrays.asList(propertyToEdit);
        request.getParameters().put("DEPENDENTS_TO_KEEP", dependentsToKeep);
        IElementEditService provider = ElementEditServiceUtils.getCommandProvider((Object)partAssociation.eContainer());
        if (provider == null) {
            return null;
        }
        ICommand destroyCommand = provider.getEditCommand((IEditCommandRequest)request);
        return destroyCommand;
    }
}

