/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.team.svn;

import java.util.HashSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.team.FileModificationValidationContext;
import org.eclipse.core.resources.team.FileModificationValidator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.papyrus.infra.emf.readonly.IReadOnlyHandler;
import org.eclipse.team.svn.core.IStateFilter;
import org.eclipse.team.svn.core.svnstorage.SVNRemoteStorage;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.ui.SVNTeamModificationValidator;

public class SVNLockHandler
implements IReadOnlyHandler {
    FileModificationValidator validator = null;

    public SVNLockHandler() {
        try {
            this.validator = new SVNTeamModificationValidator();
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
    }

    public boolean isReadOnly(URI[] uris, EditingDomain editingDomain) {
        if (this.validator != null) {
            IResource[] needsLockResources;
            IResource[] iResourceArray = needsLockResources = FileUtility.filterResources((IResource[])this.getIFiles(uris), (IStateFilter)IStateFilter.SF_NEEDS_LOCK, (int)0);
            int n = needsLockResources.length;
            int n2 = 0;
            while (n2 < n) {
                IResource needsLockResource = iResourceArray[n2];
                if (!SVNRemoteStorage.instance().asLocalResource(needsLockResource).isLocked()) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private IFile[] getIFiles(URI[] uris) {
        HashSet<IFile> iFilesSet = new HashSet<IFile>();
        URI[] uRIArray = uris;
        int n = uris.length;
        int n2 = 0;
        while (n2 < n) {
            URI uri = uRIArray[n2];
            IFile iFile = SVNLockHandler.getFile(uri);
            if (iFile != null) {
                iFilesSet.add(iFile);
            }
            ++n2;
        }
        return iFilesSet.toArray(new IFile[iFilesSet.size()]);
    }

    private static IFile getFile(URI uri) {
        if (uri.isPlatform()) {
            return ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(uri.toPlatformString(true)));
        }
        return null;
    }

    public boolean enableWrite(URI[] uris, EditingDomain editingDomain) {
        if (this.validator != null) {
            IStatus result = this.validator.validateEdit(this.getIFiles(uris), FileModificationValidationContext.VALIDATE_PROMPT);
            return result.isOK();
        }
        return false;
    }
}

