/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.alf.validation.typing;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.uml.alf.validation.typing.TypeExpression;
import org.eclipse.papyrus.uml.alf.validation.typing.TypeExpressionFactory;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.ElementImport;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.ParameterDirectionKind;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Reception;
import org.eclipse.uml2.uml.TemplateableElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SignatureFacade {
    private String name;
    protected List<TypeExpression> parameters;
    protected Map<String, TypeExpression> parametersMap;
    private TypeExpression returnType;
    private EObject actualSignatureObject;

    public EObject getActualSignatureObject() {
        return this.actualSignatureObject;
    }

    public SignatureFacade() {
        this.name = "";
        this.parameters = new ArrayList<TypeExpression>();
        this.parametersMap = new HashMap<String, TypeExpression>();
        this.returnType = null;
        this.actualSignatureObject = null;
    }

    public SignatureFacade(EObject o) {
        block10: {
            block12: {
                block11: {
                    block9: {
                        this.name = "";
                        this.parameters = new ArrayList<TypeExpression>();
                        this.parametersMap = new HashMap<String, TypeExpression>();
                        this.returnType = null;
                        this.actualSignatureObject = null;
                        if (!(o instanceof Operation)) break block9;
                        Operation operation = (Operation)o;
                        this.actualSignatureObject = operation;
                        this.name = operation.getName();
                        for (Parameter p : operation.getOwnedParameters()) {
                            if (p.getDirection() == ParameterDirectionKind.RETURN_LITERAL) {
                                this.returnType = TypeExpressionFactory.eInstance.createTypeExpression((EObject)p);
                                continue;
                            }
                            TypeExpression typeOfP = TypeExpressionFactory.eInstance.createTypeExpression((EObject)p);
                            this.parameters.add(typeOfP);
                            this.parametersMap.put(p.getName(), typeOfP);
                        }
                        break block10;
                    }
                    if (!(o instanceof Behavior)) break block11;
                    Behavior behavior = (Behavior)o;
                    this.actualSignatureObject = behavior;
                    this.name = behavior.getName();
                    for (Parameter p : behavior.getOwnedParameters()) {
                        if (p.getDirection() == ParameterDirectionKind.RETURN_LITERAL) {
                            this.returnType = TypeExpressionFactory.eInstance.createTypeExpression((EObject)p);
                            continue;
                        }
                        TypeExpression typeOfP = TypeExpressionFactory.eInstance.createTypeExpression((EObject)p);
                        this.parameters.add(typeOfP);
                        this.parametersMap.put(p.getName(), typeOfP);
                    }
                    break block10;
                }
                if (!(o instanceof ElementImport)) break block12;
                ElementImport eImport = (ElementImport)o;
                if (!(eImport.getImportedElement() instanceof Behavior)) break block10;
                Behavior b = (Behavior)eImport.getImportedElement();
                this.actualSignatureObject = b;
                this.name = eImport.getAlias() != null ? eImport.getAlias() : b.getName();
                for (Parameter p : b.getOwnedParameters()) {
                    if (p.getDirection() == ParameterDirectionKind.RETURN_LITERAL) {
                        this.returnType = TypeExpressionFactory.eInstance.createTypeExpression((EObject)p);
                        continue;
                    }
                    TypeExpression typeOfP = TypeExpressionFactory.eInstance.createTypeExpression((EObject)p);
                    this.parameters.add(typeOfP);
                    this.parametersMap.put(p.getName(), typeOfP);
                }
                break block10;
            }
            if (o instanceof Reception) {
                Reception r = (Reception)o;
                this.actualSignatureObject = r;
                this.name = r.getName();
                if (r.getSignal() != null) {
                    for (Property p : r.getSignal().getAllAttributes()) {
                        TypeExpression typeOfP = TypeExpressionFactory.eInstance.createTypeExpression((EObject)p);
                        this.parameters.add(typeOfP);
                        this.parametersMap.put(p.getName(), typeOfP);
                    }
                }
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<TypeExpression> getParameters() {
        return this.parameters;
    }

    public boolean hasReturnType() {
        return this.returnType != null;
    }

    public TypeExpression getReturnType() {
        return this.returnType;
    }

    public void setReturnType(TypeExpression returnType) {
        this.returnType = returnType;
    }

    public String isCompatibleWithMe(List<TypeExpression> arguments, boolean getErrorMessage) {
        int compatibilityLevel = this.isCompatibleWithMe(arguments);
        String errorMessage = "";
        if (compatibilityLevel == 0) {
            errorMessage = String.valueOf(errorMessage) + this.getLabel() + " does not apply to arguments ";
            String argumentsString = "(";
            boolean first = true;
            for (TypeExpression type : arguments) {
                if (!first) {
                    argumentsString = String.valueOf(argumentsString) + ", ";
                } else {
                    first = false;
                }
                argumentsString = String.valueOf(argumentsString) + type.getLabel();
            }
            argumentsString = String.valueOf(argumentsString) + ")";
            errorMessage = String.valueOf(errorMessage) + argumentsString;
        }
        return errorMessage;
    }

    public String getLabel() {
        String label = String.valueOf(this.name) + "(";
        boolean first = true;
        for (TypeExpression type : this.parameters) {
            if (!first) {
                label = String.valueOf(label) + ", ";
            } else {
                first = false;
            }
            label = String.valueOf(label) + type.getLabel();
        }
        label = String.valueOf(label) + ")";
        return label;
    }

    public int isCompatibleWithMe(List<TypeExpression> arguments) {
        if (arguments.size() != this.parameters.size()) {
            return 0;
        }
        if (arguments.size() == 0) {
            return 3;
        }
        int compatibilityLevel = 0;
        boolean first = true;
        int i = 0;
        while (i < this.parameters.size()) {
            int currentCompatibilityLevel = this.parameters.get(i).isCompatibleWithMe(arguments.get(i));
            if (first && currentCompatibilityLevel < 3) {
                return 0;
            }
            if (currentCompatibilityLevel == 0) {
                return 0;
            }
            compatibilityLevel += currentCompatibilityLevel;
            first = false;
            ++i;
        }
        return compatibilityLevel;
    }

    public String isCompatibleWithMe(Map<String, TypeExpression> arguments) {
        if (arguments.keySet().size() == 0) {
            return "";
        }
        String compatibility = "";
        for (String parameterName : arguments.keySet()) {
            if (this.parametersMap.get(parameterName) == null) {
                compatibility = String.valueOf(compatibility) + "Parameter " + parameterName + " is undefined\n";
                continue;
            }
            int compatibilityLevel = this.parametersMap.get(parameterName).isCompatibleWithMe(arguments.get(parameterName));
            if (compatibilityLevel != 0) continue;
            compatibility = String.valueOf(compatibility) + "Parameter " + parameterName + " requires an argument of type " + this.parametersMap.get(parameterName).getLabel() + "\n";
        }
        return compatibility;
    }

    public static List<SignatureFacade> findNearestSignature(List<TypeExpression> arguments, List<SignatureFacade> candidates) {
        ArrayList<SignatureFacade> matchingSignatures = new ArrayList<SignatureFacade>();
        int bestScore = 0;
        for (SignatureFacade cddMatchingSignature : candidates) {
            int currentScore = cddMatchingSignature.isCompatibleWithMe(arguments);
            if (currentScore == 0 || currentScore < bestScore) continue;
            if (currentScore > bestScore) {
                matchingSignatures.clear();
            }
            matchingSignatures.add(cddMatchingSignature);
            bestScore = currentScore;
        }
        return matchingSignatures;
    }

    public static List<SignatureFacade> findNearestConstructorSignature(Map<String, TypeExpression> arguments, List<SignatureFacade> candidates) {
        ArrayList<SignatureFacade> matchingSignatures = new ArrayList<SignatureFacade>();
        for (SignatureFacade cddMatchingSignature : candidates) {
            String compatibility = cddMatchingSignature.isCompatibleWithMe(arguments);
            if (compatibility.length() != 0) continue;
            matchingSignatures.add(cddMatchingSignature);
        }
        return matchingSignatures;
    }

    public List<SignatureFacade> isNotDistinguishableFrom(List<SignatureFacade> candidates) {
        ArrayList<SignatureFacade> matchingSignatures = new ArrayList<SignatureFacade>();
        for (SignatureFacade cddMatchingSignature : candidates) {
            if (!this.name.equals(cddMatchingSignature.getName()) || this.parameters.size() != cddMatchingSignature.parameters.size()) continue;
            boolean parameterThatDoesNotMatchFound = false;
            int i = 0;
            while (i < this.parameters.size() && !parameterThatDoesNotMatchFound) {
                int compatibilityLevel = this.parameters.get(i).isCompatibleWithMe(cddMatchingSignature.getParameters().get(i));
                if (compatibilityLevel != 3) {
                    parameterThatDoesNotMatchFound = true;
                }
                ++i;
            }
            if (parameterThatDoesNotMatchFound) continue;
            matchingSignatures.add(cddMatchingSignature);
        }
        return matchingSignatures;
    }

    public boolean equals(Operation o) {
        return this.actualSignatureObject == o;
    }

    public boolean equals(Behavior b) {
        return this.actualSignatureObject == b;
    }

    public boolean isAConstructor() {
        Element signature = null;
        if (this.actualSignatureObject instanceof Operation || this.actualSignatureObject instanceof Behavior) {
            signature = (Element)this.actualSignatureObject;
        } else if (this.actualSignatureObject instanceof ElementImport) {
            signature = ((ElementImport)this.actualSignatureObject).getImportedElement();
        }
        if (signature == null) {
            return false;
        }
        return signature.getAppliedStereotype("Standard::Create") != null;
    }

    public boolean isADestructor() {
        Element signature = null;
        if (this.actualSignatureObject instanceof Operation || this.actualSignatureObject instanceof Behavior) {
            signature = (Element)this.actualSignatureObject;
        } else if (this.actualSignatureObject instanceof ElementImport) {
            signature = ((ElementImport)this.actualSignatureObject).getImportedElement();
        }
        if (signature == null) {
            return false;
        }
        return signature.getAppliedStereotype("Standard::Destroy") != null;
    }

    public Map<String, TypeExpression> getParametersMap() {
        return this.parametersMap;
    }

    public boolean isATemplate() {
        if (this.actualSignatureObject instanceof TemplateableElement) {
            return ((TemplateableElement)this.actualSignatureObject).isTemplate();
        }
        return false;
    }
}

