/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gmf.runtime.diagram.core.edithelpers.CreateElementRequestAdapter;
import org.eclipse.gmf.runtime.diagram.core.listener.DiagramEventBroker;
import org.eclipse.gmf.runtime.diagram.core.listener.NotificationListener;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramCommandStack;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateConnectionViewAndElementRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateConnectionViewRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateUnspecifiedTypeConnectionRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewAndElementRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.diagram.ui.tools.UnspecifiedTypeConnectionTool;
import org.eclipse.gmf.runtime.diagram.ui.util.INotationType;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.IHintedType;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.notation.Connector;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.utils.EditorUtils;
import org.eclipse.papyrus.infra.gmfdiag.common.preferences.ConnectionToolPreferences;
import org.eclipse.papyrus.uml.diagram.common.Activator;
import org.eclipse.papyrus.uml.diagram.common.layout.LayoutUtils;
import org.eclipse.papyrus.uml.diagram.common.service.palette.AspectToolService;
import org.eclipse.papyrus.uml.diagram.common.service.palette.IAspectAction;
import org.eclipse.papyrus.uml.diagram.common.service.palette.IAspectActionProvider;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AspectUnspecifiedTypeConnectionTool
extends UnspecifiedTypeConnectionTool {
    private static final int STATE_CONNECTION_WAITING_END = 65;
    protected List<IAspectAction> postActions = new ArrayList<IAspectAction>();
    private final List<IElementType> elementTypes;

    public AspectUnspecifiedTypeConnectionTool(List<IElementType> elementTypes) {
        super(elementTypes);
        this.elementTypes = elementTypes;
    }

    public List<IElementType> getElementTypes() {
        return this.elementTypes;
    }

    protected boolean handleButtonUpOneClick(int button) {
        return super.handleButtonUp(button);
    }

    protected boolean handleButtonUpTwoClicks(int button) {
        this.setCtrlKeyDown(this.getCurrentInput().isControlKeyDown());
        if (this.isInState(64)) {
            this.setState(65);
            return false;
        }
        if (this.isInState(65)) {
            this.handleCreateConnection();
        }
        this.setState(0x40000000);
        if (this.isInState(0x40000008)) {
            this.handleFinished();
        }
        return true;
    }

    protected boolean handleButtonUp(int button) {
        if (ConnectionToolPreferences.instance.isInSingleClickMode()) {
            return this.handleButtonUpOneClick(button);
        }
        return this.handleButtonUpTwoClicks(button);
    }

    protected void createConnection() {
        List selectedEditParts = this.getCurrentViewer().getSelectedEditParts();
        ArrayList<View> eobjects = new ArrayList<View>();
        ArrayList<1> listeners = new ArrayList<1>();
        CompoundCommand cmd = new CompoundCommand("Create Links");
        DiagramEventBroker eventBroker = null;
        final EditPartViewer viewer = this.getCurrentViewer();
        if (!selectedEditParts.isEmpty()) {
            IGraphicalEditPart targetEditPart = (IGraphicalEditPart)selectedEditParts.get(selectedEditParts.size() - 1);
            boolean done = false;
            int i = 0;
            while (i < selectedEditParts.size()) {
                IGraphicalEditPart sourceEditPart = (IGraphicalEditPart)selectedEditParts.get(i);
                if (i != 0 && sourceEditPart == targetEditPart) break;
                CreateAspectUnspecifiedTypeConnectionRequest connectionRequest = this.createTargetRequest();
                Point[] newLocation = LayoutUtils.getLinkAnchor(sourceEditPart, targetEditPart);
                connectionRequest.setTargetEditPart((EditPart)sourceEditPart);
                connectionRequest.setType("connection start");
                connectionRequest.setLocation(newLocation[0]);
                if (sourceEditPart.getCommand((Request)connectionRequest) != null) {
                    connectionRequest.setSourceEditPart((EditPart)sourceEditPart);
                    connectionRequest.setTargetEditPart((EditPart)targetEditPart);
                    connectionRequest.setType("connection end");
                    connectionRequest.setLocation(newLocation[1]);
                    View eObject = (View)targetEditPart.getAdapter(View.class);
                    NotificationListener listener = null;
                    boolean requiresPostAction = this.requiresPostAction();
                    if (requiresPostAction) {
                        try {
                            TransactionalEditingDomain domain = (TransactionalEditingDomain)EditorUtils.getServiceRegistry().getService(TransactionalEditingDomain.class);
                            eventBroker = DiagramEventBroker.getInstance((TransactionalEditingDomain)domain);
                            if (eventBroker == null) {
                                return;
                            }
                            listener = new NotificationListener(){

                                public void notifyChanged(Notification notification) {
                                    Connector newValue = (Connector)notification.getNewValue();
                                    Map map = viewer.getEditPartRegistry();
                                    EditPart editPart = (EditPart)map.get(newValue);
                                    for (IAspectAction action : AspectUnspecifiedTypeConnectionTool.this.postActions) {
                                        action.run(editPart);
                                    }
                                }
                            };
                            if (!done) {
                                listeners.add(listener);
                                eobjects.add(eObject);
                                eventBroker.addNotificationListener((EObject)eObject, listener);
                                done = true;
                            }
                        }
                        catch (ServiceException e) {
                            Activator.log.error((Throwable)e);
                        }
                    }
                    Command command = targetEditPart.getCommand((Request)connectionRequest);
                    cmd.add(command);
                }
                ++i;
            }
            this.setCurrentCommand((Command)cmd);
            this.executeCurrentCommand();
            if (this.requiresPostAction() && eventBroker != null) {
                int ii = 0;
                while (ii < eobjects.size()) {
                    eventBroker.removeNotificationListener((EObject)eobjects.get(ii), (NotificationListener)listeners.get(ii));
                    ++ii;
                }
            }
            this.selectAddedObject(viewer, DiagramCommandStack.getReturnValues((Command)cmd));
            this.setAvoidDeactivation(false);
            this.eraseSourceFeedback();
            this.deactivate();
        }
    }

    protected boolean handleCreateConnection() {
        this.setAvoidDeactivation(true);
        if (this.getTargetEditPart() == null) {
            return false;
        }
        View eObject = (View)this.getTargetEditPart().getAdapter(View.class);
        DiagramEventBroker eventBroker = null;
        NotificationListener listener = null;
        boolean requiresPostAction = this.requiresPostAction();
        if (requiresPostAction) {
            block6: {
                TransactionalEditingDomain domain = (TransactionalEditingDomain)EditorUtils.getServiceRegistry().getService(TransactionalEditingDomain.class);
                eventBroker = DiagramEventBroker.getInstance((TransactionalEditingDomain)domain);
                if (eventBroker != null) break block6;
                return false;
            }
            try {
                listener = new NotificationListener(){

                    public void notifyChanged(Notification notification) {
                        Connector newValue = (Connector)notification.getNewValue();
                        EditPart editPart = (EditPart)AspectUnspecifiedTypeConnectionTool.this.getCurrentViewer().getEditPartRegistry().get(newValue);
                        for (IAspectAction action : AspectUnspecifiedTypeConnectionTool.this.postActions) {
                            action.run(editPart);
                        }
                    }
                };
                eventBroker.addNotificationListener((EObject)eObject, listener);
            }
            catch (ServiceException e) {
                Activator.log.error((Throwable)e);
            }
        }
        EditPartViewer viewer = this.getCurrentViewer();
        Command endCommand = this.getCommand();
        this.setCurrentCommand(endCommand);
        this.executeCurrentCommand();
        if (requiresPostAction && eventBroker != null) {
            eventBroker.removeNotificationListener((EObject)eObject, listener);
        }
        this.selectAddedObject(viewer, DiagramCommandStack.getReturnValues((Command)endCommand));
        this.setAvoidDeactivation(false);
        this.eraseSourceFeedback();
        this.deactivate();
        return true;
    }

    protected boolean requiresPostAction() {
        return this.postActions.size() > 0;
    }

    protected void applyProperty(Object key, Object value) {
        if ("aspectActions".equals(key)) {
            if (value instanceof NodeList) {
                NodeList nodeList = (NodeList)value;
                int i = 0;
                while (i < nodeList.getLength()) {
                    Node childNode = nodeList.item(i);
                    String childName = childNode.getNodeName();
                    if ("postAction".equals(childName)) {
                        IAspectActionProvider provider = AspectToolService.getInstance().getProvider(AspectToolService.getProviderId(childNode));
                        if (provider != null) {
                            IAspectAction action = provider.createAction(childNode);
                            this.postActions.add(action);
                        } else {
                            Activator.log.error("impossible to find factory with id: " + AspectToolService.getProviderId(childNode), null);
                        }
                    } else {
                        "preAction".equals(childName);
                    }
                    ++i;
                }
            }
            return;
        }
        super.applyProperty(key, value);
    }

    protected CreateAspectUnspecifiedTypeConnectionRequest createTargetRequest() {
        return new CreateAspectUnspecifiedTypeConnectionRequest(this.getElementTypes(), false, this.getPreferencesHint());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class CreateAspectUnspecifiedTypeConnectionRequest
    extends CreateUnspecifiedTypeConnectionRequest {
        private Map requests;
        private boolean useModelingAssistantService;
        private boolean directionReversed;
        private PreferencesHint preferencesHint;

        public CreateAspectUnspecifiedTypeConnectionRequest(List<IElementType> relationshipTypes, boolean useModelingAssistantService, PreferencesHint preferencesHint) {
            super(relationshipTypes, useModelingAssistantService, preferencesHint);
            this.requests = new HashMap();
            this.directionReversed = false;
            this.useModelingAssistantService = useModelingAssistantService;
            this.preferencesHint = preferencesHint;
            this.createRequests();
        }

        protected void createRequests() {
            for (IElementType elementType : this.getElementTypes()) {
                CreateConnectionViewRequest request = PapyrusCreateViewRequestFactory.getCreateConnectionRequest(elementType, this.getPreferencesHint());
                request.setType(this.getType());
                this.requests.put(elementType, request);
            }
        }

        public CreateRequest getRequestForType(IElementType relationshipType) {
            if (this.requests != null) {
                return (CreateConnectionRequest)this.requests.get(relationshipType);
            }
            return null;
        }

        public void addRequest(IElementType relationshipType, Request request) {
            if (this.requests != null) {
                this.requests.put(relationshipType, request);
            }
        }

        public List getAllRequests() {
            if (this.requests != null) {
                return new ArrayList(this.requests.values());
            }
            return Collections.EMPTY_LIST;
        }

        public void setSourceEditPart(EditPart part) {
            if (this.requests != null) {
                for (CreateConnectionRequest request : this.requests.values()) {
                    request.setSourceEditPart(part);
                }
            }
            super.setSourceEditPart(part);
        }

        public void setTargetEditPart(EditPart part) {
            if (this.requests != null) {
                for (CreateConnectionRequest request : this.requests.values()) {
                    request.setTargetEditPart(part);
                }
            }
            super.setTargetEditPart(part);
        }

        public void setLocation(Point location) {
            if (this.requests != null) {
                for (CreateConnectionRequest request : this.requests.values()) {
                    request.setLocation(location);
                }
            }
            super.setLocation(location);
        }

        public void setType(Object type) {
            if (this.requests != null) {
                for (CreateConnectionRequest request : this.requests.values()) {
                    request.setType(type);
                }
            }
            super.setType(type);
        }

        public boolean isDirectionReversed() {
            return this.directionReversed;
        }

        public void setDirectionReversed(boolean directionReversed) {
            this.directionReversed = directionReversed;
        }

        public boolean useModelingAssistantService() {
            return this.useModelingAssistantService;
        }

        protected PreferencesHint getPreferencesHint() {
            return this.preferencesHint;
        }
    }

    public static class PapyrusCreateViewRequestFactory {
        public static CreateViewRequest getCreateShapeRequest(IElementType type, PreferencesHint preferencesHint) {
            if (type instanceof INotationType) {
                CreateViewRequest.ViewDescriptor viewDescriptor = new CreateViewRequest.ViewDescriptor(null, Node.class, ((INotationType)type).getSemanticHint(), preferencesHint);
                return new CreateViewRequest(viewDescriptor);
            }
            if (type instanceof IHintedType) {
                CreateViewAndElementRequest.ViewAndElementDescriptor viewDescriptor = new CreateViewAndElementRequest.ViewAndElementDescriptor(new CreateElementRequestAdapter(new CreateElementRequest(type)), Node.class, ((IHintedType)type).getSemanticHint(), preferencesHint);
                return new CreateViewAndElementRequest(viewDescriptor);
            }
            return new CreateViewAndElementRequest(type, preferencesHint);
        }

        public static CreateConnectionViewRequest getCreateConnectionRequest(IElementType type, PreferencesHint preferencesHint) {
            if (type instanceof INotationType) {
                CreateConnectionViewRequest.ConnectionViewDescriptor viewDescriptor = new CreateConnectionViewRequest.ConnectionViewDescriptor((IAdaptable)type, ((IHintedType)type).getSemanticHint(), preferencesHint);
                return new CreateConnectionViewRequest(viewDescriptor);
            }
            if (type instanceof IHintedType) {
                return new CreateConnectionViewAndElementRequest(type, ((IHintedType)type).getSemanticHint(), preferencesHint);
            }
            return new CreateConnectionViewAndElementRequest(type, preferencesHint);
        }

        public static CreateConnectionViewRequest getCreateConnectionRequest(IElementType type, String graphicalHint, PreferencesHint preferencesHint) {
            if (type instanceof INotationType) {
                CreateConnectionViewRequest.ConnectionViewDescriptor viewDescriptor = new CreateConnectionViewRequest.ConnectionViewDescriptor((IAdaptable)type, graphicalHint, preferencesHint);
                return new CreateConnectionViewRequest(viewDescriptor);
            }
            if (type instanceof IHintedType) {
                return new CreateConnectionViewAndElementRequest(type, graphicalHint, preferencesHint);
            }
            return new CreateConnectionViewAndElementRequest(type, preferencesHint);
        }
    }
}

