/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.ui.dialogs;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.papyrus.uml.diagram.common.ui.dialogs.AbstractChooseElement;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.ParameterableElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementChooseDialog
extends AbstractChooseElement {
    protected AdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
    protected TreeViewer treeViewer;
    protected Element context;
    protected Element selectedElement = null;
    protected List<EClass> notWanted = new ArrayList<EClass>();
    private EClass elementtype;

    public Element getSelectedElement() {
        return this.selectedElement;
    }

    public ElementChooseDialog(Shell parent, int style, Element context, EClass elementtype) {
        super(parent, style);
        this.context = context;
        this.elementtype = elementtype;
        this.notWanted = new ArrayList<EClass>();
    }

    public ElementChooseDialog(Shell parent, int style, Element context, EClass elementtype, List<EClass> notWanted) {
        super(parent, style);
        this.context = context;
        this.elementtype = elementtype;
        assert (notWanted != null);
        this.notWanted = notWanted;
    }

    @Override
    protected void createContents() {
        super.createContents();
        this.treeViewer = this.filtercontrol.getViewer();
        this.treeViewer.setUseHashlookup(true);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider(this.adapterFactory));
        ViewerFilter filter = new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof EObject) {
                    EObject eObject = (EObject)element;
                    if (eObject.eContents().size() == 0) {
                        return ElementChooseDialog.this.isSelectableEobject(eObject);
                    }
                    boolean result = false;
                    if (ElementChooseDialog.this.isSelectableEobject(eObject)) {
                        return true;
                    }
                    TreeIterator iter = eObject.eAllContents();
                    while (iter.hasNext()) {
                        EObject subEObject = (EObject)iter.next();
                        boolean contains = this.select(viewer, eObject, subEObject);
                        boolean bl = result = result || contains;
                    }
                    return result;
                }
                return false;
            }
        };
        ViewerFilter[] filters = new ViewerFilter[]{filter};
        this.treeViewer.setFilters(filters);
        this.treeViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider(this.adapterFactory));
        this.treeViewer.setInput((Object)this.context);
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object selection = ((IStructuredSelection)ElementChooseDialog.this.filtercontrol.getViewer().getSelection()).getFirstElement();
                if (selection instanceof EObject) {
                    if (ElementChooseDialog.this.isSelectableEobject((EObject)selection)) {
                        ElementChooseDialog.this.btnSelect.setEnabled(true);
                        ElementChooseDialog.this.result = (ParameterableElement)selection;
                        ElementChooseDialog.this.selectedElement = (ParameterableElement)selection;
                    } else {
                        ElementChooseDialog.this.btnSelect.setEnabled(false);
                        ElementChooseDialog.this.result = null;
                        ElementChooseDialog.this.selectedElement = null;
                    }
                }
            }
        });
        this.btnSelect.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
                ElementChooseDialog.this.getParent().close();
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        this.btnCancel.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
                ElementChooseDialog.this.result = null;
                ElementChooseDialog.this.selectedElement = null;
                ElementChooseDialog.this.getParent().close();
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
    }

    protected boolean isSelectableEobject(EObject eObject) {
        if (this.elementtype.isSuperTypeOf(eObject.eClass())) {
            if (this.notWanted.size() > 0) {
                Iterator<EClass> iternotwanted = this.notWanted.iterator();
                while (iternotwanted.hasNext()) {
                    if (!iternotwanted.next().isSuperTypeOf(eObject.eClass())) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }
}

