/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.component.custom.edit.policies;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.SetBoundsCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeCompartmentEditPart;
import org.eclipse.gmf.runtime.diagram.ui.figures.ShapeCompartmentFigure;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.DropObjectsRequest;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.IHintedType;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.common.editpolicies.OldCommonDiagramDragDropEditPolicy;
import org.eclipse.papyrus.uml.diagram.common.helper.ILinkMappingHelper;
import org.eclipse.papyrus.uml.diagram.component.custom.edit.command.CreateViewCommand;
import org.eclipse.papyrus.uml.diagram.component.custom.edit.helpers.ComponentLinkMappingHelper;
import org.eclipse.papyrus.uml.diagram.component.custom.locators.PortPositionLocator;
import org.eclipse.papyrus.uml.diagram.component.custom.log.Log;
import org.eclipse.papyrus.uml.diagram.component.part.UMLVisualIDRegistry;
import org.eclipse.papyrus.uml.diagram.component.providers.UMLElementTypes;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Collaboration;
import org.eclipse.uml2.uml.CollaborationUse;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.ConnectableElement;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.EncapsulatedClassifier;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.StructuredClassifier;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.TypedElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomDiagramDragDropEditPolicy
extends OldCommonDiagramDragDropEditPolicy {
    public CustomDiagramDragDropEditPolicy() {
        super((ILinkMappingHelper)ComponentLinkMappingHelper.getInstance());
    }

    protected Set<Integer> getDroppableElementVisualId() {
        HashSet<Integer> droppableElementsVisualId = new HashSet<Integer>();
        droppableElementsVisualId.add(3200);
        droppableElementsVisualId.add(2002);
        droppableElementsVisualId.add(2003);
        droppableElementsVisualId.add(3201);
        droppableElementsVisualId.add(3199);
        droppableElementsVisualId.add(3069);
        droppableElementsVisualId.add(3070);
        droppableElementsVisualId.add(3071);
        droppableElementsVisualId.add(3072);
        droppableElementsVisualId.add(3074);
        droppableElementsVisualId.add(3075);
        return droppableElementsVisualId;
    }

    public IElementType getUMLElementType(int elementID) {
        return UMLElementTypes.getElementType(elementID);
    }

    public int getNodeVisualID(View containerView, EObject domainElement) {
        return UMLVisualIDRegistry.getNodeVisualID(containerView, domainElement);
    }

    public int getLinkWithClassVisualID(EObject domainElement) {
        return UMLVisualIDRegistry.getLinkWithClassVisualID(domainElement);
    }

    protected Command getSpecificDropCommand(DropObjectsRequest dropRequest, Element semanticElement, int nodeVISUALID, int linkVISUALID) {
        switch (linkVISUALID) {
            case 4010: {
                return this.dropDependency(dropRequest, semanticElement, linkVISUALID);
            }
        }
        switch (nodeVISUALID) {
            case 2002: 
            case 2003: 
            case 3200: {
                return this.dropTopLevelNode(dropRequest, semanticElement, nodeVISUALID, linkVISUALID);
            }
            case 3069: {
                return this.dropAffixedNode(dropRequest, semanticElement, nodeVISUALID);
            }
            case 3074: 
            case 3201: {
                return this.dropComment(dropRequest, semanticElement, nodeVISUALID);
            }
            case 3075: 
            case 3199: {
                return this.dropConstraint(dropRequest, semanticElement, nodeVISUALID);
            }
        }
        return super.getSpecificDropCommand(dropRequest, semanticElement, nodeVISUALID, linkVISUALID);
    }

    protected Command dropComment(DropObjectsRequest dropRequest, Element semanticLink, int nodeVISUALID) {
        GraphicalEditPart graphicalParentEditPart = (GraphicalEditPart)this.getHost();
        EObject graphicalParentObject = graphicalParentEditPart.resolveSemanticElement();
        if (nodeVISUALID == 3201) {
            return this.getDropCommentCommand((Comment)semanticLink, this.getViewer(), this.getDiagramPreferencesHint(), dropRequest.getLocation(), ((GraphicalEditPart)this.getHost()).getNotationView(), (IHintedType)UMLElementTypes.Comment_3201, (IHintedType)UMLElementTypes.CommentAnnotatedElement_4015);
        }
        if (nodeVISUALID == 3074) {
            return this.getDropCommentCommand((Comment)semanticLink, this.getViewer(), this.getDiagramPreferencesHint(), dropRequest.getLocation(), ((GraphicalEditPart)this.getHost()).getNotationView(), (IHintedType)UMLElementTypes.Comment_3074, (IHintedType)UMLElementTypes.CommentAnnotatedElement_4015);
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected Command dropConstraint(DropObjectsRequest dropRequest, Element semanticLink, int nodeVISUALID) {
        GraphicalEditPart graphicalParentEditPart = (GraphicalEditPart)this.getHost();
        EObject graphicalParentObject = graphicalParentEditPart.resolveSemanticElement();
        if (nodeVISUALID == 3199) {
            return this.getDropConstraintCommand((Constraint)semanticLink, this.getViewer(), this.getDiagramPreferencesHint(), dropRequest.getLocation(), ((GraphicalEditPart)this.getHost()).getNotationView(), (IHintedType)UMLElementTypes.Constraint_3199, (IHintedType)UMLElementTypes.ConstraintConstrainedElement_4009);
        }
        if (nodeVISUALID == 3075) {
            return this.getDropConstraintCommand((Constraint)semanticLink, this.getViewer(), this.getDiagramPreferencesHint(), dropRequest.getLocation(), ((GraphicalEditPart)this.getHost()).getNotationView(), (IHintedType)UMLElementTypes.Constraint_3075, (IHintedType)UMLElementTypes.ConstraintConstrainedElement_4009);
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected Command dropDependency(DropObjectsRequest dropRequest, Element semanticLink, int linkVISUALID) {
        Collection<?> sourceEnds = ComponentLinkMappingHelper.getInstance().getSource(semanticLink);
        Collection<?> targetEnds = ComponentLinkMappingHelper.getInstance().getTarget(semanticLink);
        if (sourceEnds != null && targetEnds != null && sourceEnds.size() == 1 && targetEnds.size() == 1) {
            Element source = (Element)sourceEnds.toArray()[0];
            Element target = (Element)targetEnds.toArray()[0];
            return new ICommandProxy((ICommand)this.dropBinaryLink(new CompositeCommand("drop Dependency"), source, target, linkVISUALID, dropRequest.getLocation(), semanticLink));
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected Command dropRoleBinding(DropObjectsRequest dropRequest, Element semanticLink, int linkVISUALID) {
        Collection<?> sourceEnds = ComponentLinkMappingHelper.getInstance().getSource(semanticLink);
        Collection<?> targetEnds = ComponentLinkMappingHelper.getInstance().getTarget(semanticLink);
        if (sourceEnds != null && targetEnds != null && sourceEnds.size() == 1 && targetEnds.size() == 1) {
            Element source = semanticLink.getOwner();
            Element target = (Element)targetEnds.toArray()[0];
            return new ICommandProxy((ICommand)this.dropBinaryLink(new CompositeCommand("drop RoleBinding"), source, target, linkVISUALID, dropRequest.getLocation(), semanticLink));
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected Command dropProperty(DropObjectsRequest dropRequest, Property droppedElement, int nodeVISUALID) {
        GraphicalEditPart graphicalParentEditPart = (GraphicalEditPart)this.getHost();
        EObject graphicalParentObject = graphicalParentEditPart.resolveSemanticElement();
        Point location = dropRequest.getLocation().getCopy();
        if (!(droppedElement instanceof Port)) {
            Type type;
            if (graphicalParentObject instanceof Classifier && ((Classifier)graphicalParentObject).getAllAttributes().contains((Object)droppedElement)) {
                return new ICommandProxy((ICommand)this.getDefaultDropNodeCommand(nodeVISUALID, location, (EObject)droppedElement));
            }
            if (graphicalParentObject instanceof ConnectableElement && (type = ((ConnectableElement)graphicalParentObject).getType()) != null && type instanceof Classifier && ((Classifier)type).getAllAttributes().contains((Object)droppedElement)) {
                return new ICommandProxy((ICommand)this.getDefaultDropNodeCommand(nodeVISUALID, location, (EObject)droppedElement));
            }
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected Command dropAffixedNode(DropObjectsRequest dropRequest, Element droppedElement, int nodeVISUALID) {
        if (!(droppedElement instanceof Port) && !(droppedElement instanceof Parameter)) {
            Log.getInstance().error(new Exception("Incorrect parameter type (droppedElement should be a Port or Parameter)"));
            return UnexecutableCommand.INSTANCE;
        }
        Boolean isCompartmentTarget = false;
        GraphicalEditPart graphicalParentEditPart = (GraphicalEditPart)this.getHost();
        Point dropLocation = dropRequest.getLocation().getCopy();
        if (graphicalParentEditPart instanceof ShapeCompartmentEditPart) {
            isCompartmentTarget = true;
            graphicalParentEditPart = (GraphicalEditPart)graphicalParentEditPart.getParent();
            Point targetLocation = graphicalParentEditPart.getContentPane().getBounds().getLocation();
            ShapeCompartmentFigure compartmentFigure = (ShapeCompartmentFigure)this.getHostFigure();
            Viewport compartmentViewPort = compartmentFigure.getScrollPane().getViewport();
            Point compartmentViewPortLocation = compartmentViewPort.getLocation();
            Point compartmentViewPortViewLocation = compartmentViewPort.getViewLocation();
            Point delta = compartmentViewPortLocation.translate(targetLocation.negate());
            delta = delta.translate(compartmentViewPortViewLocation.negate());
            dropLocation = dropRequest.getLocation().getTranslated(delta);
        }
        Point parentLoc = graphicalParentEditPart.getFigure().getBounds().getLocation().getCopy();
        PortPositionLocator locator = new PortPositionLocator(graphicalParentEditPart.getFigure(), 0);
        Rectangle proposedBounds = new Rectangle(dropLocation, new Dimension(20, 20));
        proposedBounds = proposedBounds.getTranslated(parentLoc);
        Rectangle preferredBounds = locator.getPreferredLocation(proposedBounds);
        Rectangle creationBounds = preferredBounds.getTranslated(parentLoc.getNegated());
        dropLocation = creationBounds.getLocation();
        EObject graphicalParentObject = graphicalParentEditPart.resolveSemanticElement();
        if (graphicalParentObject instanceof EncapsulatedClassifier && ((EncapsulatedClassifier)graphicalParentObject).getAllAttributes().contains((Object)droppedElement)) {
            if (isCompartmentTarget.booleanValue()) {
                return this.getDropAffixedNodeInCompartmentCommand(nodeVISUALID, dropLocation, (EObject)droppedElement);
            }
            return new ICommandProxy((ICommand)this.getDefaultDropNodeCommand(nodeVISUALID, dropLocation, (EObject)droppedElement));
        }
        if (graphicalParentObject instanceof ConnectableElement) {
            Type type = ((ConnectableElement)graphicalParentObject).getType();
            if (type != null && type instanceof EncapsulatedClassifier && ((EncapsulatedClassifier)type).getAllAttributes().contains((Object)droppedElement)) {
                if (isCompartmentTarget.booleanValue()) {
                    return this.getDropAffixedNodeInCompartmentCommand(nodeVISUALID, dropLocation, (EObject)droppedElement);
                }
                return new ICommandProxy((ICommand)this.getDefaultDropNodeCommand(nodeVISUALID, dropLocation, (EObject)droppedElement));
            }
        } else if (graphicalParentObject instanceof Behavior && ((Behavior)graphicalParentObject).getOwnedParameters().contains((Object)droppedElement)) {
            if (isCompartmentTarget.booleanValue()) {
                return this.getDropAffixedNodeInCompartmentCommand(nodeVISUALID, dropLocation, (EObject)droppedElement);
            }
            return new ICommandProxy((ICommand)this.getDefaultDropNodeCommand(nodeVISUALID, dropLocation, (EObject)droppedElement));
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected Command dropTopLevelNode(DropObjectsRequest dropRequest, Element semanticElement, int nodeVISUALID, int linkVISUALID) {
        GraphicalEditPart graphicalParentEditPart = (GraphicalEditPart)this.getHost();
        EObject graphicalParentObject = graphicalParentEditPart.resolveSemanticElement();
        if (graphicalParentObject instanceof Package) {
            return new ICommandProxy((ICommand)this.getDefaultDropNodeCommand(nodeVISUALID, dropRequest.getLocation(), (EObject)semanticElement));
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected CompoundCommand getDropAffixedNodeInCompartmentCommand(int nodeVISUALID, Point location, EObject droppedObject) {
        CompoundCommand cc = new CompoundCommand("Drop");
        EObjectAdapter elementAdapter = new EObjectAdapter(droppedObject);
        CreateViewRequest.ViewDescriptor descriptor = new CreateViewRequest.ViewDescriptor((IAdaptable)elementAdapter, Node.class, ((IHintedType)this.getUMLElementType(nodeVISUALID)).getSemanticHint(), -1, false, this.getDiagramPreferencesHint());
        CreateViewCommand createCommand = new CreateViewCommand(this.getEditingDomain(), descriptor, (View)this.getHost().getParent().getModel());
        cc.add((Command)new ICommandProxy((ICommand)createCommand));
        SetBoundsCommand setBoundsCommand = new SetBoundsCommand(this.getEditingDomain(), "move", (IAdaptable)createCommand.getCommandResult().getReturnValue(), location);
        cc.add((Command)new ICommandProxy((ICommand)setBoundsCommand));
        return cc;
    }

    protected Command getDragCommand(ChangeBoundsRequest request) {
        Boolean isSpecificDrag = false;
        Iterator iter = request.getEditParts().iterator();
        EObject graphicalParentObject = ((GraphicalEditPart)this.getHost()).resolveSemanticElement();
        while (graphicalParentObject != null && iter.hasNext()) {
            EObject droppedObject = null;
            EditPart droppedEditPart = (EditPart)iter.next();
            if (droppedEditPart instanceof GraphicalEditPart) {
                droppedObject = ((GraphicalEditPart)droppedEditPart).resolveSemanticElement();
            }
            isSpecificDrag = this.isSpecificDropActionExpected((GraphicalEditPart)this.getHost(), droppedObject);
        }
        if (isSpecificDrag.booleanValue()) {
            return null;
        }
        return super.getDragCommand(request);
    }

    protected Command getDropCommand(ChangeBoundsRequest request) {
        Boolean isSpecificDrop = false;
        Iterator iter = request.getEditParts().iterator();
        EObject graphicalParentObject = ((GraphicalEditPart)this.getHost()).resolveSemanticElement();
        while (graphicalParentObject != null && iter.hasNext()) {
            EObject droppedObject = null;
            EditPart droppedEditPart = (EditPart)iter.next();
            if (droppedEditPart instanceof GraphicalEditPart) {
                droppedObject = ((GraphicalEditPart)droppedEditPart).resolveSemanticElement();
            }
            isSpecificDrop = this.isSpecificDropActionExpected((GraphicalEditPart)this.getHost(), droppedObject);
        }
        if (isSpecificDrop.booleanValue()) {
            return this.getDropObjectsCommand(this.castToDropObjectsRequest(request));
        }
        return super.getDropCommand(request);
    }

    protected boolean isSpecificDropActionExpected(GraphicalEditPart graphicalParent, EObject droppedObject) {
        boolean isSpecificDropActionExpected = false;
        EObject graphicalParentObject = graphicalParent.resolveSemanticElement();
        if (graphicalParentObject != null) {
            if (graphicalParentObject instanceof Collaboration) {
                if (droppedObject instanceof Collaboration || droppedObject instanceof Class) {
                    isSpecificDropActionExpected = true;
                }
            } else if (graphicalParentObject instanceof StructuredClassifier) {
                if (droppedObject instanceof Collaboration || droppedObject instanceof Class) {
                    isSpecificDropActionExpected = true;
                }
            } else if (graphicalParentObject instanceof TypedElement) {
                if (droppedObject instanceof Type) {
                    isSpecificDropActionExpected = true;
                }
            } else if (graphicalParentObject instanceof CollaborationUse && droppedObject instanceof Collaboration) {
                isSpecificDropActionExpected = true;
            }
        }
        return isSpecificDropActionExpected;
    }
}

