/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.composite.custom.parsers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.papyrus.uml.diagram.composite.custom.parsers.NamedElementLabelParser;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.UMLPackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectorLabelParser
extends NamedElementLabelParser {
    protected static final String TYPE_FORMAT = "%s: %s";

    @Override
    public String getPrintString(IAdaptable element, int flags) {
        String result = "";
        EObject eObject = (EObject)element.getAdapter(EObject.class);
        if (eObject != null && eObject instanceof Connector) {
            Connector connector = (Connector)eObject;
            if (connector.isSetName()) {
                result = connector.getName();
            }
            String type = "";
            if (connector.getType() != null && connector.getType().isSetName()) {
                type = connector.getType().getName();
                result = String.format(TYPE_FORMAT, result, type);
            }
        }
        return result;
    }

    @Override
    public boolean isAffectingEvent(Object event, int flags) {
        Object feature;
        if (event instanceof Notification && (feature = ((Notification)event).getFeature()) instanceof EStructuralFeature) {
            return UMLPackage.eINSTANCE.getNamedElement_Name().equals(feature) || UMLPackage.eINSTANCE.getConnector_Type().equals(feature);
        }
        return false;
    }

    @Override
    public List<EObject> getSemanticElementsBeingParsed(EObject element) {
        ArrayList<EObject> semanticElementsBeingParsed = new ArrayList<EObject>();
        if (element != null && element instanceof Connector) {
            Connector semElement = (Connector)element;
            semanticElementsBeingParsed.add((EObject)semElement);
            if (semElement.getType() != null) {
                semanticElementsBeingParsed.add((EObject)semElement.getType());
            }
        }
        return semanticElementsBeingParsed;
    }
}

