/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.menu.selection;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditor;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.papyrus.infra.core.editor.IMultiDiagramEditor;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectByTypeHandler
extends AbstractHandler {
    public static String ID = "org.eclipse.papyrus.uml.diagram.menu.selection.commands.selectByType";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IMultiDiagramEditor editor;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IEditorPart editorPart = window.getActivePage().getActiveEditor();
        if (editorPart instanceof IMultiDiagramEditor && (editorPart = (editor = (IMultiDiagramEditor)editorPart).getActiveEditor()) instanceof DiagramEditor) {
            StructuredSelection selection = (StructuredSelection)editorPart.getEditorSite().getSelectionProvider().getSelection();
            if (selection.isEmpty()) {
                return null;
            }
            if (SelectByTypeHandler.verifySameTypeOfSelectedElements((ISelection)selection)) {
                Object elem = selection.getFirstElement();
                IGraphicalEditPart part = (IGraphicalEditPart)elem;
                EObject o1 = this.getEObject((GraphicalEditPart)part);
                Map elements = part.getViewer().getEditPartRegistry();
                Object[] values = elements.values().toArray();
                ArrayList<Object> listElement = new ArrayList<Object>();
                this.add(listElement, part);
                int i = 0;
                while (i < values.length) {
                    if (values[i] instanceof IGraphicalEditPart) {
                        IGraphicalEditPart nextPart = (IGraphicalEditPart)values[i];
                        EObject o2 = this.getEObject((GraphicalEditPart)nextPart);
                        if (part instanceof ConnectionEditPart && nextPart instanceof ConnectionEditPart) {
                            if (o1 != o2 && o1.eClass().equals(o2.eClass())) {
                                this.add(listElement, nextPart);
                            }
                        } else if (o1 != o2 && o1.eClass().equals(o2.eClass()) && this.isEquivalent(part.getParent(), nextPart.getParent())) {
                            this.add(listElement, nextPart);
                        }
                    }
                    ++i;
                }
                part.getViewer().setSelection((ISelection)new StructuredSelection(listElement));
            }
        }
        return null;
    }

    private void add(ArrayList<Object> listElement, IGraphicalEditPart nextPart) {
        if (nextPart.isSelectable()) {
            listElement.add(nextPart);
        }
    }

    private boolean isEquivalent(EditPart part, EditPart nextPart) {
        if (part instanceof GraphicalEditPart && nextPart instanceof GraphicalEditPart) {
            EObject eObject = this.getEObject((GraphicalEditPart)part);
            EObject eObject2 = this.getEObject((GraphicalEditPart)nextPart);
            return eObject != null && eObject2 != null && eObject.eClass().equals(eObject2.eClass());
        }
        return false;
    }

    private EObject getEObject(GraphicalEditPart part) {
        if (part.getModel() instanceof View) {
            return ((View)part.getModel()).getElement();
        }
        return null;
    }

    public static boolean verifySameTypeOfSelectedElements(ISelection selection) {
        if (!(selection instanceof StructuredSelection) || selection.isEmpty()) {
            return false;
        }
        Object[] elems = ((StructuredSelection)selection).toArray();
        if (elems.length == 1 && elems[0] instanceof DiagramEditPart) {
            return false;
        }
        boolean selectable = true;
        int i = 0;
        while (i < elems.length - 1) {
            Object elem1 = elems[i];
            Object elem2 = elems[i + 1];
            if (elem1 instanceof IGraphicalEditPart && elem2 instanceof IGraphicalEditPart) {
                IGraphicalEditPart part1 = (IGraphicalEditPart)elem1;
                IGraphicalEditPart part2 = (IGraphicalEditPart)elem2;
                selectable |= part1.isSelectable() && part2.isSelectable();
                View view1 = (View)part1.getModel();
                View view2 = (View)part2.getModel();
                if (view1 != null && view2 != null && view1.getElement().eClass() != view2.getElement().eClass()) {
                    return false;
                }
            }
            ++i;
        }
        return selectable;
    }
}

