/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.pkg.provider;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.IHintedType;
import org.eclipse.papyrus.uml.diagram.pkg.provider.ElementTypes;
import org.eclipse.papyrus.uml.diagram.pkg.provider.IGraphicalTypeRegistry;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.Dependency;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageImport;

public class GraphicalTypeRegistry
implements IGraphicalTypeRegistry {
    protected Set<String> knownNodes = new HashSet<String>();
    protected Set<String> knownEdges = new HashSet<String>();

    public GraphicalTypeRegistry() {
        this.knownEdges.add(ElementTypes.DEPENDENCY.getSemanticHint());
        this.knownEdges.add(ElementTypes.PACKAGE_IMPORT.getSemanticHint());
        this.knownNodes.add(ElementTypes.PACKAGE.getSemanticHint());
        this.knownNodes.add(ElementTypes.PACKAGE_CN.getSemanticHint());
        this.knownNodes.add(ElementTypes.COMMENT.getSemanticHint());
        this.knownNodes.add(ElementTypes.COMMENT_CN.getSemanticHint());
    }

    public String getEdgeGraphicalType(EObject domainElement) {
        String graphicalType = "undefined_type";
        if (domainElement == null) {
            return "undefined_type";
        }
        if (domainElement instanceof Dependency) {
            graphicalType = ElementTypes.DEPENDENCY.getSemanticHint();
        }
        if (domainElement instanceof PackageImport) {
            graphicalType = ElementTypes.PACKAGE_IMPORT.getSemanticHint();
        }
        return graphicalType;
    }

    public String getEdgeGraphicalType(IElementType elementType) {
        if (elementType instanceof IHintedType) {
            String semanticHint = ((IHintedType)elementType).getSemanticHint();
            return this.getEdgeGraphicalType(semanticHint);
        }
        return "undefined_type";
    }

    public String getEdgeGraphicalType(String proposedType) {
        if (this.isKnownEdgeType(proposedType)) {
            return proposedType;
        }
        return "undefined_type";
    }

    public String getNodeGraphicalType(EObject domainElement, String containerType) {
        String graphicalType = "undefined_type";
        if (containerType == null || domainElement == null) {
            return "undefined_type";
        }
        if (domainElement instanceof Package) {
            if ("Package".equals(containerType)) {
                graphicalType = ElementTypes.PACKAGE.getSemanticHint();
            }
            if ("7010".equals(containerType)) {
                graphicalType = ElementTypes.PACKAGE_CN.getSemanticHint();
            }
            if ("7016".equals(containerType)) {
                graphicalType = ElementTypes.PACKAGE_CN.getSemanticHint();
            }
        }
        if (domainElement instanceof Comment) {
            if ("Package".equals(containerType)) {
                graphicalType = ElementTypes.COMMENT.getSemanticHint();
            }
            if ("7010".equals(containerType)) {
                graphicalType = ElementTypes.COMMENT_CN.getSemanticHint();
            }
            if ("7016".equals(containerType)) {
                graphicalType = ElementTypes.COMMENT_CN.getSemanticHint();
            }
        }
        return graphicalType;
    }

    public String getNodeGraphicalType(IElementType elementType, String containerType) {
        if (elementType instanceof IHintedType) {
            String semanticHint = ((IHintedType)elementType).getSemanticHint();
            return this.getNodeGraphicalType(semanticHint, containerType);
        }
        return "undefined_type";
    }

    public String getNodeGraphicalType(String proposedType, String containerType) {
        if (this.isKnownNodeType(proposedType)) {
            return proposedType;
        }
        return "undefined_type";
    }

    public boolean isKnownEdgeType(String type) {
        return this.knownEdges.contains(type);
    }

    public boolean isKnownNodeType(String type) {
        return this.knownNodes.contains(type);
    }
}

