/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.edit.helpers;

import org.eclipse.core.runtime.Plugin;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.transaction.RunnableWithResult;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.Request;
import org.eclipse.gef.requests.DropRequest;
import org.eclipse.gef.requests.ReconnectRequest;
import org.eclipse.gmf.runtime.common.core.util.Log;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionEditPart;
import org.eclipse.gmf.runtime.diagram.ui.internal.DiagramUIPlugin;
import org.eclipse.gmf.runtime.gef.ui.figures.DefaultSizeNodeFigure;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.gmf.runtime.gef.ui.figures.SlidableAnchor;
import org.eclipse.gmf.runtime.notation.Anchor;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.IdentityAnchor;
import org.eclipse.papyrus.uml.diagram.common.draw2d.anchors.FixedAnchor;

public class AnchorHelper {
    public static String getAnchorId(TransactionalEditingDomain domain, org.eclipse.gef.ConnectionEditPart connEditPart, final boolean isSource) {
        final ConnectionEditPart connection = (ConnectionEditPart)connEditPart;
        String t = "";
        try {
            t = (String)domain.runExclusive((Runnable)new RunnableWithResult.Impl(){

                public void run() {
                    Anchor a = null;
                    a = isSource ? ((Edge)connection.getModel()).getSourceAnchor() : ((Edge)connection.getModel()).getTargetAnchor();
                    if (a instanceof IdentityAnchor) {
                        this.setResult(((IdentityAnchor)a).getId());
                    } else {
                        this.setResult("");
                    }
                }
            });
        }
        catch (InterruptedException e) {
            Log.error((Plugin)DiagramUIPlugin.getInstance(), (int)9, (String)"getTargetConnectionAnchor", (Throwable)e);
        }
        return t;
    }

    public static Point getRequestLocation(Request request) {
        if (request instanceof ReconnectRequest) {
            if (((DropRequest)request).getLocation() != null) {
                Point pt = ((DropRequest)request).getLocation().getCopy();
                return pt;
            }
        } else if (request instanceof DropRequest) {
            return ((DropRequest)request).getLocation();
        }
        return null;
    }

    public static class CombinedFragmentNodeFigure
    extends DefaultSizeNodeFigure {
        public CombinedFragmentNodeFigure(int width, int height) {
            super(width, height);
        }

        protected ConnectionAnchor createAnchor(PrecisionPoint p) {
            if (p == null) {
                return this.createDefaultAnchor();
            }
            return new IntersectionPointAnchor((IFigure)this, p);
        }
    }

    public static class FixedAnchorEx
    extends FixedAnchor {
        private int location;

        public FixedAnchorEx(IFigure f, int location) {
            super(f, location);
            this.location = location;
        }

        public Point getLocation(Point reference) {
            if (this.location == 0) {
                return this.getBox().getTop();
            }
            if (this.location == 1) {
                return this.getBox().getBottom();
            }
            return super.getLocation(reference);
        }
    }

    public static class InnerPointAnchor
    extends SlidableAnchor {
        private PrecisionPoint percent;
        private IFigure figure;

        public InnerPointAnchor(IFigure fig, PrecisionPoint percent) {
            super(fig, percent);
            this.figure = fig;
            this.percent = percent;
        }

        public static InnerPointAnchor createAnchorAtLocation(IFigure fig, PrecisionPoint loc) {
            PrecisionPoint p = loc.getPreciseCopy();
            Rectangle b = fig.getBounds().getCopy();
            fig.translateToAbsolute((Translatable)b);
            Dimension d = p.getDifference(b.getTopLeft());
            PrecisionPoint per = new PrecisionPoint(d.preciseWidth() / (double)b.width, d.preciseHeight() / (double)b.height);
            return new InnerPointAnchor(fig, per);
        }

        protected Point getLocation(Point ownReference, Point foreignReference) {
            PrecisionRectangle bounds = new PrecisionRectangle(this.figure.getBounds());
            bounds.setPreciseWidth((double)bounds.width * this.percent.preciseX());
            bounds.setPreciseHeight((double)bounds.height * this.percent.preciseY());
            this.figure.translateToAbsolute((Translatable)bounds);
            return bounds.getBottomRight();
        }
    }

    public static class IntersectionPointAnchor
    extends SlidableAnchor {
        public IntersectionPointAnchor(IFigure fig, PrecisionPoint p) {
            super(fig, p);
        }

        public IntersectionPointAnchor(IFigure fig) {
            super(fig);
        }

        protected Point getLocation(Point ownReference, Point foreignReference) {
            PointList intersections = this.getIntersectionPoints(ownReference, foreignReference);
            if (intersections != null && intersections.size() != 0) {
                int size = intersections.size();
                double dist = foreignReference.getDistance(ownReference);
                int i = 0;
                while (i < size) {
                    Point loc = intersections.getPoint(i);
                    if (this.isInOrder(foreignReference, ownReference, dist, loc)) {
                        return loc;
                    }
                    ++i;
                }
                return intersections.getFirstPoint();
            }
            return null;
        }

        private boolean isInOrder(Point start, Point end, double dist, Point loc) {
            double total = loc.getDistance(start);
            double dist2 = loc.getDistance(end);
            if (total < dist || total < dist2) {
                return false;
            }
            return Math.abs(total - dist - dist2) < 0.01;
        }
    }

    public static class SideAnchor
    extends SlidableAnchor {
        private boolean isRight;

        public SideAnchor(NodeFigure nodeFigure, PrecisionPoint pt, boolean isRight) {
            super((IFigure)nodeFigure, pt);
            this.isRight = isRight;
        }

        public boolean isRight() {
            return this.isRight;
        }

        public String getTerminal() {
            String side = this.isRight ? "R" : "L";
            return String.valueOf(super.getTerminal()) + "{" + side + "}";
        }
    }
}

