/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.edit.parts;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Locator;
import org.eclipse.draw2d.RelativeLocator;
import org.eclipse.draw2d.TreeSearch;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeNodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.ResizableShapeEditPolicy;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.IMapMode;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeUtil;
import org.eclipse.gmf.runtime.gef.ui.figures.DefaultSizeNodeFigure;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.FillStyle;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.runtime.notation.datatype.GradientData;
import org.eclipse.papyrus.infra.emf.appearance.helper.ShadowFigureHelper;
import org.eclipse.papyrus.uml.diagram.common.figure.node.PapyrusNodeFigure;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.ExecutionSpecificationEndEditPart;
import org.eclipse.swt.graphics.Color;
import org.eclipse.uml2.uml.ExecutionSpecification;

public abstract class AbstractExecutionSpecificationEditPart
extends ShapeNodeEditPart {
    private List executionSpecificationEndParts;

    public AbstractExecutionSpecificationEditPart(View view) {
        super(view);
    }

    public List getChildren() {
        if (this.executionSpecificationEndParts == null) {
            this.initExecutionSpecificationEndEditPart();
        }
        return super.getChildren();
    }

    protected void initExecutionSpecificationEndEditPart() {
        this.executionSpecificationEndParts = new ArrayList();
        EObject element = this.resolveSemanticElement();
        if (!(element instanceof ExecutionSpecification)) {
            return;
        }
        ExecutionSpecification execution = (ExecutionSpecification)element;
        ExecutionSpecificationEndEditPart startPart = new ExecutionSpecificationEndEditPart(execution.getStart(), this, new RelativeLocator(this.getFigure(), 1));
        this.executionSpecificationEndParts.add(startPart);
        ExecutionSpecificationEndEditPart finishPart = new ExecutionSpecificationEndEditPart(execution.getFinish(), this, new RelativeLocator(this.getFigure(), 4));
        this.executionSpecificationEndParts.add(finishPart);
        Diagram diagram = ((View)this.getModel()).getDiagram();
        startPart.rebuildLinks(diagram);
        finishPart.rebuildLinks(diagram);
        this.addChild((EditPart)startPart, -1);
        this.addChild((EditPart)finishPart, -1);
    }

    protected NodeFigure createNodePlate() {
        DefaultSizeNodeFigure result = new DefaultSizeNodeFigure(16, 60){

            protected boolean isDefaultAnchorArea(PrecisionPoint p) {
                return false;
            }
        };
        result.setMinimumSize(new Dimension(this.getMapMode().DPtoLP(16), this.getMapMode().DPtoLP(20)));
        return result;
    }

    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        this.installEditPolicy("PrimaryDrag Policy", (EditPolicy)new ResizableShapeEditPolicy(){

            protected void showChangeBoundsFeedback(ChangeBoundsRequest request) {
                IFigure feedback = this.getDragSourceFeedbackFigure();
                PrecisionRectangle rect = new PrecisionRectangle(this.getInitialFeedbackBounds().getCopy());
                this.getHostFigure().translateToAbsolute((Translatable)rect);
                IFigure f = this.getHostFigure();
                Dimension min = f.getMinimumSize().getCopy();
                Dimension max = f.getMaximumSize().getCopy();
                IMapMode mmode = MapModeUtil.getMapMode((IFigure)f);
                min.height = mmode.LPtoDP(min.height);
                min.width = mmode.LPtoDP(min.width);
                max.height = mmode.LPtoDP(max.height);
                max.width = mmode.LPtoDP(max.width);
                Rectangle originalBounds = rect.getCopy();
                rect.translate(request.getMoveDelta());
                rect.resize(request.getSizeDelta());
                if (min.width > rect.width) {
                    rect.width = min.width;
                } else if (max.width < rect.width) {
                    rect.width = max.width;
                }
                if (min.height > rect.height) {
                    rect.height = min.height;
                } else if (max.height < rect.height) {
                    rect.height = max.height;
                }
                if (rect.height == min.height && request.getSizeDelta().height < 0 && request.getMoveDelta().y > 0) {
                    Point loc = rect.getLocation();
                    loc.y = originalBounds.getBottom().y - min.height;
                    rect.setLocation(loc);
                    request.getSizeDelta().height = min.height - originalBounds.height;
                    request.getMoveDelta().y = loc.y - originalBounds.y;
                }
                feedback.translateToRelative((Translatable)rect);
                feedback.setBounds((Rectangle)rect);
            }
        });
    }

    protected void setLineWidth(int width) {
        if (this.getPrimaryShape() instanceof NodeFigure) {
            this.getPrimaryShape().setLineWidth(width);
        }
    }

    protected final void refreshShadow() {
        this.getPrimaryShape().setShadow(ShadowFigureHelper.getShadowFigureValue((EModelElement)((View)this.getModel())));
    }

    protected void setTransparency(int transp) {
        this.getPrimaryShape().setTransparency(transp);
    }

    protected void setBackgroundColor(Color color) {
        this.getPrimaryShape().setBackgroundColor(color);
        this.getPrimaryShape().setIsUsingGradient(false);
        this.getPrimaryShape().setGradientData(-1, -1, 0);
    }

    protected void setGradient(GradientData gradient) {
        ExecutionSpecificationRectangleFigure fig = this.getPrimaryShape();
        FillStyle style = (FillStyle)this.getPrimaryView().getStyle(NotationPackage.Literals.FILL_STYLE);
        if (gradient != null) {
            fig.setIsUsingGradient(true);
            fig.setGradientData(style.getFillColor(), gradient.getGradientColor1(), gradient.getGradientStyle());
        } else {
            fig.setIsUsingGradient(false);
        }
    }

    public boolean supportsGradient() {
        return true;
    }

    protected void handleNotificationEvent(Notification event) {
        super.handleNotificationEvent(event);
        Object feature = event.getFeature();
        if (this.getModel() != null && this.getModel() == event.getNotifier()) {
            if (NotationPackage.eINSTANCE.getLineStyle_LineWidth().equals(feature)) {
                this.refreshLineWidth();
            } else if (NotationPackage.eINSTANCE.getLineTypeStyle_LineType().equals(feature)) {
                this.refreshLineType();
            }
        }
        this.refreshShadow();
    }

    public abstract ExecutionSpecificationRectangleFigure getPrimaryShape();

    public class ExecutionSpecificationRectangleFigure
    extends PapyrusNodeFigure {
        public ExecutionSpecificationRectangleFigure() {
            this.setPreferredSize(new Dimension(AbstractExecutionSpecificationEditPart.this.getMapMode().DPtoLP(16), AbstractExecutionSpecificationEditPart.this.getMapMode().DPtoLP(60)));
            this.setMinimumSize(new Dimension(AbstractExecutionSpecificationEditPart.this.getMapMode().DPtoLP(16), AbstractExecutionSpecificationEditPart.this.getMapMode().DPtoLP(20)));
        }

        public IFigure findMouseEventTargetAt(int x, int y) {
            IFigure f = this.findMouseEventTargetInDescendantsAt(x, y);
            if (f != null) {
                return f;
            }
            if (!this.containsPoint(x, y)) {
                return null;
            }
            if (this.isMouseEventTarget()) {
                return this;
            }
            return null;
        }

        public IFigure findFigureAt(int x, int y, TreeSearch search) {
            if (search.prune((IFigure)this)) {
                return null;
            }
            IFigure child = this.findDescendantAtExcluding(x, y, search);
            if (child != null) {
                return child;
            }
            if (!this.containsPoint(x, y)) {
                return null;
            }
            if (search.accept((IFigure)this)) {
                return this;
            }
            return null;
        }
    }

    static class FillParentLocator
    implements Locator {
        FillParentLocator() {
        }

        public void relocate(IFigure target) {
            target.setBounds(target.getParent().getBounds());
        }
    }
}

