/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.edit.policies;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.core.listener.NotificationListener;
import org.eclipse.gmf.runtime.diagram.ui.editparts.LabelEditPart;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.papyrus.infra.gmfdiag.common.editpolicies.IMaskManagedLabelEditPolicy;
import org.eclipse.papyrus.uml.diagram.common.editpolicies.AbstractMaskManagedEditPolicy;
import org.eclipse.papyrus.uml.diagram.common.helper.StereotypedElementLabelHelper;
import org.eclipse.papyrus.uml.diagram.sequence.part.UMLDiagramEditorPlugin;
import org.eclipse.papyrus.uml.tools.utils.MultiplicityElementUtil;
import org.eclipse.papyrus.uml.tools.utils.NamedElementUtil;
import org.eclipse.papyrus.uml.tools.utils.ParameterUtil;
import org.eclipse.papyrus.uml.tools.utils.PropertyUtil;
import org.eclipse.papyrus.uml.tools.utils.TypedElementUtil;
import org.eclipse.papyrus.uml.tools.utils.ValueSpecificationUtil;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Message;
import org.eclipse.uml2.uml.MultiplicityElement;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.ParameterDirectionKind;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Signal;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.TypedElement;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.ValueSpecification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageLabelEditPolicy
extends AbstractMaskManagedEditPolicy {
    private DefaultValueListener defaultValueListener;

    public void refreshDisplay() {
        ConnectionEditPart lp = (ConnectionEditPart)this.getHost();
        List children = lp.getChildren();
        for (Object p : children) {
            if (!(p instanceof ICustomMessageLabel)) continue;
            MessageLabelHelper.getInstance().refreshEditPartDisplay((GraphicalEditPart)p);
        }
    }

    public int getCurrentDisplayValue() {
        EAnnotation customeDisplayAnnotation = ((View)this.getHost().getModel()).getEAnnotation("CustomAppearance_Annotation");
        int displayValue = this.getDefaultDisplayValue();
        if (customeDisplayAnnotation != null) {
            displayValue = Integer.parseInt((String)customeDisplayAnnotation.getDetails().get((Object)"CustomAppearance_MaskValue"));
        } else {
            IPreferenceStore store = UMLDiagramEditorPlugin.getInstance().getPreferenceStore();
            int displayValueTemp = store.getInt("PapyrusUMLSequenceDiagram_Message.label.display");
            if (displayValueTemp != 0) {
                displayValue = displayValueTemp;
            }
        }
        return displayValue;
    }

    public int getDefaultDisplayValue() {
        return 4872;
    }

    public String getMaskLabel(int value) {
        return MessageLabelHelper.getInstance().getMaskLabel(value);
    }

    public Collection<String> getMaskLabels() {
        return MessageLabelHelper.getInstance().getMaskLabels();
    }

    public Map<Integer, String> getMasks() {
        return MessageLabelHelper.getInstance().getMasks();
    }

    public Collection<Integer> getMaskValues() {
        return MessageLabelHelper.getInstance().getMaskValues();
    }

    public String getPreferencePageID() {
        return "org.eclipse.papyrus.uml.diagram.sequence.preferences.MessagePreferencePage";
    }

    public Message getUMLElement() {
        if (this.hostSemanticElement instanceof Message) {
            return (Message)this.hostSemanticElement;
        }
        return null;
    }

    public void addAdditionalListeners() {
        super.addAdditionalListeners();
        this.defaultValueListener = new DefaultValueListener();
        Message e = this.getUMLElement();
        if (e == null || e.getSignature() == null) {
            return;
        }
        NamedElement sig = e.getSignature();
        if (sig instanceof Operation) {
            Operation operation = (Operation)sig;
            this.getDiagramEventBroker().addNotificationListener((EObject)operation, (NotificationListener)this);
            for (Parameter parameter : operation.getOwnedParameters()) {
                this.getDiagramEventBroker().addNotificationListener((EObject)parameter, (NotificationListener)this);
                this.getDiagramEventBroker().addNotificationListener((EObject)parameter.getDefaultValue(), (NotificationListener)this.defaultValueListener);
                this.getDiagramEventBroker().addNotificationListener((EObject)parameter.getType(), (NotificationListener)this);
            }
        } else if (sig instanceof Signal) {
            Signal signal = (Signal)sig;
            this.getDiagramEventBroker().addNotificationListener((EObject)signal, (NotificationListener)this);
            for (Property property : signal.getOwnedAttributes()) {
                this.getDiagramEventBroker().addNotificationListener((EObject)property, (NotificationListener)this);
                this.getDiagramEventBroker().addNotificationListener((EObject)property.getDefaultValue(), (NotificationListener)this.defaultValueListener);
                this.getDiagramEventBroker().addNotificationListener((EObject)property.getType(), (NotificationListener)this);
            }
        }
        EList argments = e.getArguments();
        for (ValueSpecification v : argments) {
            if (!(v instanceof EObject)) continue;
            this.getDiagramEventBroker().addNotificationListener((EObject)v, (NotificationListener)this);
        }
    }

    protected void removeAdditionalListeners() {
        super.removeAdditionalListeners();
        Message e = this.getUMLElement();
        if (e == null || e.getSignature() == null) {
            return;
        }
        NamedElement sig = e.getSignature();
        if (sig instanceof Operation) {
            Operation operation = (Operation)sig;
            this.getDiagramEventBroker().removeNotificationListener((EObject)operation, (NotificationListener)this);
            for (Parameter parameter : operation.getOwnedParameters()) {
                this.getDiagramEventBroker().removeNotificationListener((EObject)parameter, (NotificationListener)this);
                this.getDiagramEventBroker().removeNotificationListener((EObject)parameter.getDefaultValue(), (NotificationListener)this.defaultValueListener);
                this.getDiagramEventBroker().removeNotificationListener((EObject)parameter.getType(), (NotificationListener)this);
            }
        } else if (sig instanceof Signal) {
            Signal signal = (Signal)sig;
            this.getDiagramEventBroker().removeNotificationListener((EObject)signal, (NotificationListener)this);
            for (Property property : signal.getOwnedAttributes()) {
                this.getDiagramEventBroker().removeNotificationListener((EObject)property, (NotificationListener)this);
                this.getDiagramEventBroker().removeNotificationListener((EObject)property.getDefaultValue(), (NotificationListener)this.defaultValueListener);
                this.getDiagramEventBroker().removeNotificationListener((EObject)property.getType(), (NotificationListener)this);
            }
        }
        EList argments = e.getArguments();
        for (ValueSpecification v : argments) {
            if (!(v instanceof EObject)) continue;
            this.getDiagramEventBroker().removeNotificationListener((EObject)v, (NotificationListener)this);
        }
    }

    public void notifyChanged(Notification notification) {
        super.notifyChanged(notification);
        Object object = notification.getNotifier();
        Message e = this.getUMLElement();
        if (e == null || e.getSignature() == null) {
            return;
        }
        if (UMLPackage.Literals.MESSAGE__ARGUMENT.equals(notification.getFeature())) {
            this.parameterListChange(notification);
            return;
        }
        if (e.getArguments().contains(object)) {
            this.refreshDisplay();
            return;
        }
        NamedElement sig = e.getSignature();
        if (sig instanceof Operation) {
            Operation operation = (Operation)sig;
            if (object.equals(operation)) {
                this.notifyOperationChanged(operation, notification);
            } else if (this.isParameter(object, operation)) {
                this.notifyParameterChanged(notification);
            } else if (this.isParameterType(object, operation)) {
                this.notifyTypeChanged(notification);
            }
        } else if (sig instanceof Signal) {
            Element own;
            Signal signal = (Signal)sig;
            if (object.equals(signal)) {
                this.notifySignalChanged(signal, notification);
            } else if (this.isProperty(object, signal)) {
                this.notifyPropertyChanged(notification);
            } else if (this.isPropertyType(object, signal)) {
                this.notifyTypeChanged(notification);
            } else if (object instanceof ValueSpecification && this.isProperty(own = ((ValueSpecification)object).getOwner(), signal)) {
                this.refreshDisplay();
            }
        }
        if (this.isMaskManagedAnnotation(object)) {
            this.refreshDisplay();
        } else if (this.isRemovedMaskManagedLabelAnnotation(object, notification)) {
            this.refreshDisplay();
        }
    }

    private void notifyPropertyChanged(Notification notification) {
        switch (notification.getFeatureID(Property.class)) {
            case 35: {
                if (notification.getOldValue() instanceof EObject) {
                    this.getDiagramEventBroker().removeNotificationListener((EObject)notification.getOldValue(), (NotificationListener)this.defaultValueListener);
                }
                if (notification.getNewValue() instanceof EObject) {
                    this.getDiagramEventBroker().addNotificationListener((EObject)notification.getNewValue(), (NotificationListener)this.defaultValueListener);
                }
                this.refreshDisplay();
                break;
            }
            case 5: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                this.refreshDisplay();
                break;
            }
            case 15: {
                this.parameterListChange(notification);
                break;
            }
        }
    }

    protected void notifyParameterChanged(Notification notification) {
        switch (notification.getFeatureID(Parameter.class)) {
            case 21: {
                if (notification.getOldValue() instanceof EObject) {
                    this.getDiagramEventBroker().removeNotificationListener((EObject)notification.getOldValue(), (NotificationListener)this.defaultValueListener);
                }
                if (notification.getNewValue() instanceof EObject) {
                    this.getDiagramEventBroker().addNotificationListener((EObject)notification.getNewValue(), (NotificationListener)this.defaultValueListener);
                }
                this.refreshDisplay();
                break;
            }
            case 5: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 22: 
            case 25: {
                this.refreshDisplay();
                break;
            }
            case 10: {
                this.parameterListChange(notification);
                break;
            }
        }
    }

    protected void parameterListChange(Notification notification) {
        switch (notification.getEventType()) {
            case 3: {
                this.getDiagramEventBroker().addNotificationListener((EObject)notification.getNewValue(), (NotificationListener)this);
                this.refreshDisplay();
                break;
            }
            case 5: {
                if (notification.getNewValue() instanceof List) {
                    List addedElements = (List)notification.getNewValue();
                    for (Object addedElement : addedElements) {
                        if (!(addedElement instanceof EObject)) continue;
                        this.getDiagramEventBroker().addNotificationListener((EObject)addedElement, (NotificationListener)this);
                    }
                }
                this.refreshDisplay();
                break;
            }
            case 4: {
                this.getDiagramEventBroker().removeNotificationListener((EObject)notification.getOldValue(), (NotificationListener)this);
                this.refreshDisplay();
                break;
            }
            case 6: {
                if (notification.getOldValue() instanceof List) {
                    List removedElements = (List)notification.getOldValue();
                    for (Object removedElement : removedElements) {
                        if (!(removedElement instanceof EObject)) continue;
                        this.getDiagramEventBroker().removeNotificationListener((EObject)removedElement, (NotificationListener)this);
                    }
                }
                this.refreshDisplay();
                break;
            }
            case 1: {
                if (notification.getNewValue() != null) {
                    this.getDiagramEventBroker().addNotificationListener((EObject)notification.getNewValue(), (NotificationListener)this);
                }
                if (notification.getOldValue() != null) {
                    this.getDiagramEventBroker().removeNotificationListener((EObject)notification.getOldValue(), (NotificationListener)this);
                }
                this.refreshDisplay();
            }
        }
    }

    protected void notifyTypeChanged(Notification notification) {
        switch (notification.getFeatureID(notification.getNotifier().getClass())) {
            case 5: 
            case 9: 
            case 11: {
                this.refreshDisplay();
                break;
            }
        }
    }

    protected void notifyOperationChanged(Operation operation, Notification notification) {
        switch (notification.getFeatureID(Operation.class)) {
            case 5: 
            case 9: 
            case 20: 
            case 35: 
            case 37: 
            case 38: 
            case 41: 
            case 43: {
                this.refreshDisplay();
                break;
            }
            case 24: {
                this.parameterListChange(notification);
                break;
            }
        }
    }

    private void notifySignalChanged(Signal signal, Notification notification) {
        switch (notification.getFeatureID(Signal.class)) {
            case 5: 
            case 9: {
                this.refreshDisplay();
                break;
            }
            case 38: {
                this.parameterListChange(notification);
                break;
            }
        }
    }

    protected boolean isParameterType(Object object, Operation operation) {
        if (!(object instanceof Type)) {
            return false;
        }
        for (Parameter parameter : operation.getOwnedParameters()) {
            if (!object.equals(parameter.getType())) continue;
            return true;
        }
        return false;
    }

    protected boolean isParameter(Object object, Operation operation) {
        if (!(object instanceof Parameter)) {
            return false;
        }
        return operation.getOwnedParameters().contains(object);
    }

    private boolean isPropertyType(Object object, Signal signal) {
        if (!(object instanceof Type)) {
            return false;
        }
        for (Property property : signal.getOwnedAttributes()) {
            if (!object.equals(property.getType())) continue;
            return true;
        }
        return false;
    }

    private boolean isProperty(Object object, Signal signal) {
        if (!(object instanceof Property)) {
            return false;
        }
        return signal.getOwnedAttributes().contains(object);
    }

    class DefaultValueListener
    implements NotificationListener {
        DefaultValueListener() {
        }

        public void notifyChanged(Notification notification) {
            MessageLabelEditPolicy.this.refreshDisplay();
        }
    }

    public static interface ICustomMessageLabel {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class MessageLabelHelper
    extends StereotypedElementLabelHelper {
        private static MessageLabelHelper labelHelper;
        protected final Map<Integer, String> masks = new HashMap<Integer, String>(11);

        protected MessageLabelHelper() {
            this.masks.put(2, "Visibility");
            this.masks.put(8, "Name");
            this.masks.put(4096, "Parameters Name");
            this.masks.put(2048, "Parameters Direction");
            this.masks.put(256, "Parameters Type");
            this.masks.put(512, "Return Type");
            this.masks.put(16384, "Parameters Multiplicity");
            this.masks.put(32768, "Parameters Default Value");
            this.masks.put(4, "Parameters Value");
            this.masks.put(65536, "Parameters Modifiers");
            this.masks.put(128, "Modifiers");
        }

        public static MessageLabelHelper getInstance() {
            if (labelHelper == null) {
                labelHelper = new MessageLabelHelper();
            }
            return labelHelper;
        }

        public Message getUMLElement(GraphicalEditPart editPart) {
            EObject e = ((View)editPart.getModel()).getElement();
            if (e instanceof Message) {
                return (Message)e;
            }
            return null;
        }

        protected String elementLabel(GraphicalEditPart editPart) {
            Message e;
            NamedElement signature;
            if (editPart instanceof LabelEditPart) {
                editPart = (GraphicalEditPart)editPart.getParent();
            }
            int displayValue = 4872;
            IMaskManagedLabelEditPolicy policy = (IMaskManagedLabelEditPolicy)editPart.getEditPolicy((Object)"MaskManagedLabelPolicy");
            if (policy != null) {
                displayValue = policy.getCurrentDisplayValue();
            }
            if ((signature = (e = this.getUMLElement(editPart)).getSignature()) instanceof Operation) {
                return OperationUtil.getCustomLabel(e, (Operation)signature, displayValue);
            }
            if (signature instanceof Signal) {
                return SignalUtil.getCustomLabel(e, (Signal)signature, displayValue);
            }
            if (signature != null) {
                return signature.getName();
            }
            return e.getName();
        }

        public String getMaskLabel(int value) {
            return this.masks.get(value);
        }

        public Collection<String> getMaskLabels() {
            return this.masks.values();
        }

        public Map<Integer, String> getMasks() {
            return this.masks;
        }

        public Set<Integer> getMaskValues() {
            return this.masks.keySet();
        }
    }

    static class OperationUtil {
        OperationUtil() {
        }

        public static String getCustomLabel(Message e, Parameter parameter, int style) {
            boolean multiLine;
            String modifiers;
            StringBuffer buffer = new StringBuffer();
            buffer.append(" ");
            if ((style & 2) != 0) {
                buffer.append(NamedElementUtil.getVisibilityAsSign((NamedElement)parameter));
            }
            if ((style & 0x800) != 0) {
                buffer.append(" ");
                buffer.append(parameter.getDirection().getLiteral());
            }
            if ((style & 0x1000) != 0) {
                buffer.append(" ");
                buffer.append(parameter.getName());
            }
            if ((style & 0x100) != 0) {
                if (parameter.getType() != null) {
                    buffer.append(": " + parameter.getType().getName());
                } else {
                    buffer.append(": <Undefined>");
                }
            }
            if ((style & 0x4000) != 0) {
                String multiplicity = MultiplicityElementUtil.getMultiplicityAsString((MultiplicityElement)parameter);
                buffer.append(multiplicity);
            }
            if ((style & 4) != 0) {
                String value = OperationUtil.getValue(e, parameter);
                if (value != null) {
                    if ((style & 0x1000) != 0 || (style & 0x100) != 0) {
                        buffer.append(" = ");
                    }
                    buffer.append(value);
                }
            } else if ((style & 0x8000) != 0 && parameter.getDefault() != null) {
                if ((style & 0x1000) != 0 || (style & 0x100) != 0) {
                    buffer.append(" = ");
                }
                buffer.append(parameter.getDefault());
            }
            if ((style & 0x80) != 0 && !(modifiers = ParameterUtil.getModifiersAsString((Parameter)parameter, (boolean)(multiLine = (style & 0x400) != 0))).equals("")) {
                if (multiLine) {
                    buffer.append("\n");
                }
                buffer.append(modifiers);
            }
            return buffer.toString();
        }

        private static String getValue(Message e, Parameter parameter) {
            EList arguments = e.getArguments();
            for (ValueSpecification v : arguments) {
                if (!v.getName().equals(parameter.getName())) continue;
                return ValueSpecificationUtil.getSpecificationValue((ValueSpecification)v);
            }
            return null;
        }

        public static String getCustomLabel(Message e, Operation operation, int style) {
            String modifiers;
            StringBuffer buffer = new StringBuffer();
            buffer.append(" ");
            if ((style & 2) != 0) {
                buffer.append(NamedElementUtil.getVisibilityAsSign((NamedElement)operation));
            }
            if ((style & 8) != 0) {
                buffer.append(" ");
                buffer.append(operation.getName());
            }
            buffer.append("(");
            buffer.append(OperationUtil.getParametersAsString(e, operation, style));
            buffer.append(")");
            if ((style & 0x200) != 0) {
                buffer.append(OperationUtil.getReturnTypeAsString(operation, style));
            }
            if ((style & 0x80) != 0 && !(modifiers = OperationUtil.getModifiersAsString(operation)).equals("")) {
                buffer.append("{");
                buffer.append(modifiers);
                buffer.append("}");
            }
            return buffer.toString();
        }

        private static String getModifiersAsString(Operation operation) {
            StringBuffer buffer = new StringBuffer();
            boolean needsComma = false;
            Parameter returnParameter = OperationUtil.getReturnParameter(operation);
            if (returnParameter != null) {
                if (!returnParameter.isUnique()) {
                    buffer.append("nonunique");
                    needsComma = true;
                }
                if (returnParameter.isOrdered()) {
                    if (needsComma) {
                        buffer.append(", ");
                    }
                    buffer.append("ordered");
                    needsComma = true;
                }
            }
            if (operation.isQuery()) {
                if (needsComma) {
                    buffer.append(", ");
                }
                buffer.append("query");
                needsComma = true;
            }
            for (Operation currentOperation : operation.getRedefinedOperations()) {
                if (needsComma) {
                    buffer.append(", ");
                }
                buffer.append("redefines ");
                buffer.append(currentOperation.getName());
                needsComma = true;
            }
            for (Constraint constraint : operation.getOwnedRules()) {
                if (needsComma) {
                    buffer.append(", ");
                }
                if (constraint.getSpecification() != null) {
                    buffer.append(constraint.getSpecification().stringValue());
                }
                needsComma = true;
            }
            return buffer.toString();
        }

        private static String getReturnTypeAsString(Operation operation, int style) {
            boolean displayType = (style & 0x200) != 0;
            boolean displayMultiplicity = (style & 0x40000) != 0;
            StringBuffer label = new StringBuffer("");
            Parameter returnParameter = OperationUtil.getReturnParameter(operation);
            if (returnParameter != null && (displayType || displayMultiplicity)) {
                label.append(": ");
                if (displayType) {
                    label.append(TypedElementUtil.getTypeAsString((TypedElement)returnParameter));
                }
                if (displayMultiplicity) {
                    label.append(MultiplicityElementUtil.getMultiplicityAsString((MultiplicityElement)returnParameter));
                }
            }
            return label.toString();
        }

        private static Parameter getReturnParameter(Operation operation) {
            Parameter returnParameter = null;
            Iterator it = operation.getOwnedParameters().iterator();
            while (returnParameter == null && it.hasNext()) {
                Parameter parameter = (Parameter)it.next();
                if (!parameter.getDirection().equals((Object)ParameterDirectionKind.RETURN_LITERAL)) continue;
                returnParameter = parameter;
            }
            return returnParameter;
        }

        private static String getParametersAsString(Message e, Operation operation, int style) {
            StringBuffer paramString = new StringBuffer();
            Iterator paramIterator = operation.getOwnedParameters().iterator();
            boolean firstParameter = true;
            while (paramIterator.hasNext()) {
                String parameterString;
                Parameter parameter = (Parameter)paramIterator.next();
                if (parameter.getDirection().equals((Object)ParameterDirectionKind.RETURN_LITERAL) || (parameterString = OperationUtil.getCustomLabel(e, parameter, style)).trim().equals("")) continue;
                if (!firstParameter) {
                    paramString.append(", ");
                }
                paramString.append(parameterString);
                firstParameter = false;
            }
            return paramString.toString();
        }
    }

    public static class SignalUtil {
        private static String getCustomPropertyLabel(Message e, Property property, int style) {
            boolean multiLine;
            String modifiers;
            StringBuffer buffer = new StringBuffer();
            buffer.append(" ");
            if ((style & 2) != 0) {
                buffer.append(NamedElementUtil.getVisibilityAsSign((NamedElement)property));
            }
            if ((style & 4) != 0 && property.isDerived()) {
                buffer.append("/");
            }
            if ((style & 0x1000) != 0) {
                buffer.append(" ");
                buffer.append(property.getName());
            }
            if ((style & 0x100) != 0) {
                if (property.getType() != null) {
                    buffer.append(": " + property.getType().getName());
                } else {
                    buffer.append(": <Undefined>");
                }
            }
            if ((style & 0x20) != 0) {
                String multiplicity = MultiplicityElementUtil.getMultiplicityAsString((MultiplicityElement)property);
                buffer.append(multiplicity);
            }
            if ((style & 4) != 0) {
                String value = SignalUtil.getValue(e, property);
                if (value != null) {
                    if ((style & 0x1000) != 0 || (style & 0x100) != 0) {
                        buffer.append(" = ");
                    }
                    buffer.append(value);
                }
            } else if ((style & 0x8000) != 0 && property.getDefault() != null) {
                if ((style & 0x1000) != 0 || (style & 0x100) != 0) {
                    buffer.append(" = ");
                }
                buffer.append(property.getDefault());
            }
            if ((style & 0x80) != 0 && !(modifiers = PropertyUtil.getModifiersAsString((Property)property, (boolean)(multiLine = (style & 0x400) != 0))).equals("")) {
                if (multiLine) {
                    buffer.append("\n");
                }
                if (!buffer.toString().endsWith(" ")) {
                    buffer.append(" ");
                }
                buffer.append(modifiers);
            }
            return buffer.toString();
        }

        private static String getValue(Message e, Property property) {
            EList arguments = e.getArguments();
            for (ValueSpecification v : arguments) {
                if (!v.getName().equals(property.getName())) continue;
                return ValueSpecificationUtil.getSpecificationValue((ValueSpecification)v);
            }
            return null;
        }

        public static String getCustomLabel(Message e, Signal signal, int style) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(" ");
            if ((style & 2) != 0) {
                buffer.append(NamedElementUtil.getVisibilityAsSign((NamedElement)signal));
            }
            if ((style & 8) != 0) {
                buffer.append(" ");
                buffer.append(signal.getName());
            }
            buffer.append("(");
            buffer.append(SignalUtil.getPropertiesAsString(e, signal, style));
            buffer.append(")");
            return buffer.toString();
        }

        private static String getPropertiesAsString(Message e, Signal signal, int style) {
            StringBuffer propertiesString = new StringBuffer();
            boolean firstProperty = true;
            for (Property property : signal.getOwnedAttributes()) {
                String propertyString = SignalUtil.getCustomPropertyLabel(e, property, style);
                if (propertyString.trim().equals("")) continue;
                if (!firstProperty) {
                    propertiesString.append(", ");
                }
                propertiesString.append(propertyString);
                firstProperty = false;
            }
            return propertiesString.toString();
        }
    }
}

