/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.edit.policies;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Polyline;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.gef.requests.ReconnectRequest;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.CreateOrSelectElementCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.GraphicalNodeEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateConnectionViewAndElementRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateConnectionViewRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateUnspecifiedTypeConnectionRequest;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.IHintedType;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.papyrus.uml.diagram.common.service.AspectUnspecifiedTypeConnectionTool;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.CombinedFragment2EditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.CombinedFragmentEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.InteractionEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.InteractionOperandEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.LifelineEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.Message4EditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.Message6EditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.Message7EditPart;
import org.eclipse.papyrus.uml.diagram.sequence.part.Messages;
import org.eclipse.papyrus.uml.diagram.sequence.part.UMLVisualIDRegistry;
import org.eclipse.papyrus.uml.diagram.sequence.providers.UMLElementTypes;
import org.eclipse.papyrus.uml.diagram.sequence.util.LifelineMessageCreateHelper;
import org.eclipse.papyrus.uml.diagram.sequence.util.SequenceUtil;
import org.eclipse.uml2.uml.Message;
import org.eclipse.uml2.uml.OccurrenceSpecification;

public class SequenceGraphicalNodeEditPolicy
extends GraphicalNodeEditPolicy {
    private static final int MARGIN = 2;

    protected Command getConnectionAndRelationshipCreateCommand(CreateConnectionViewAndElementRequest request) {
        LifelineEditPart lifelinePart;
        Map extendedData = request.getExtendedData();
        String requestHint = request.getConnectionViewAndElementDescriptor().getSemanticHint();
        if (this.isCreatedNearOccurrenceSpecification(requestHint) && (lifelinePart = SequenceUtil.getParentLifelinePart(this.getHost())) != null) {
            Map.Entry<Point, List<OccurrenceSpecification>> eventAndLocation = SequenceUtil.findNearestEvent(request.getLocation(), lifelinePart);
            List<Object> events = Collections.emptyList();
            Point location = null;
            if (eventAndLocation != null) {
                location = eventAndLocation.getKey();
                events = eventAndLocation.getValue();
            }
            extendedData.put("Nearest occurrence specification", events);
            extendedData.put("Nearest occurrence specification location", location);
            if (location != null) {
                request.setLocation(location);
            }
        }
        return super.getConnectionAndRelationshipCreateCommand(request);
    }

    protected Command getConnectionAndRelationshipCompleteCommand(CreateConnectionViewAndElementRequest request) {
        LifelineEditPart lifelinePart;
        Map extendedData = request.getExtendedData();
        String requestHint = request.getConnectionViewAndElementDescriptor().getSemanticHint();
        if (this.isCreatedNearOccurrenceSpecification(requestHint) && (lifelinePart = SequenceUtil.getParentLifelinePart(this.getHost())) != null) {
            Map.Entry<Point, List<OccurrenceSpecification>> eventAndLocation = SequenceUtil.findNearestEvent(request.getLocation(), lifelinePart);
            List<Object> events = Collections.emptyList();
            Point location = null;
            if (eventAndLocation != null) {
                location = eventAndLocation.getKey();
                events = eventAndLocation.getValue();
            }
            extendedData.put("Nearest occurrence specification (end)", events);
            extendedData.put("Nearest occurrence specification location (end)", location);
            if (location != null) {
                request.setLocation(location);
            }
        }
        return super.getConnectionAndRelationshipCompleteCommand(request);
    }

    private boolean isCreatedNearOccurrenceSpecification(String requestHint) {
        String generalOrderingHint = ((IHintedType)UMLElementTypes.GeneralOrdering_4012).getSemanticHint();
        return generalOrderingHint.equals(requestHint);
    }

    private boolean isMessageHint(String requestHint) {
        ArrayList<String> messageHints = new ArrayList<String>(7);
        String messageHint = ((IHintedType)UMLElementTypes.Message_4003).getSemanticHint();
        messageHints.add(messageHint);
        messageHint = ((IHintedType)UMLElementTypes.Message_4004).getSemanticHint();
        messageHints.add(messageHint);
        messageHint = ((IHintedType)UMLElementTypes.Message_4005).getSemanticHint();
        messageHints.add(messageHint);
        messageHint = ((IHintedType)UMLElementTypes.Message_4006).getSemanticHint();
        messageHints.add(messageHint);
        messageHint = ((IHintedType)UMLElementTypes.Message_4007).getSemanticHint();
        messageHints.add(messageHint);
        messageHint = ((IHintedType)UMLElementTypes.Message_4008).getSemanticHint();
        messageHints.add(messageHint);
        messageHint = ((IHintedType)UMLElementTypes.Message_4009).getSemanticHint();
        messageHints.add(messageHint);
        return messageHints.contains(requestHint);
    }

    protected Command getConnectionCreateCommand(CreateConnectionRequest request) {
        LifelineEditPart target;
        EditPart targetEditPart = request.getTargetEditPart();
        if (targetEditPart != null && targetEditPart instanceof LifelineEditPart && (target = (LifelineEditPart)targetEditPart).getPrimaryShape() != null) {
            Rectangle sourceBounds = target.getPrimaryShape().getFigureLifelineNameContainerFigure().getBounds().getCopy();
            Point sourcePointCopy = request.getLocation().getCopy();
            target.getFigure().translateToRelative((Translatable)sourcePointCopy);
            if (sourcePointCopy.y() < sourceBounds.getBottom().y()) {
                target.getFigure().translateToAbsolute((Translatable)sourceBounds);
                request.getLocation().setY(sourceBounds.getBottom().y() + 1);
            }
        }
        request.getExtendedData().put("Location of connection source point", request.getLocation());
        return super.getConnectionCreateCommand(request);
    }

    protected Command getConnectionCompleteCommand(CreateConnectionRequest request) {
        Command command = super.getConnectionCompleteCommand(request);
        if (command == null) {
            return UnexecutableCommand.INSTANCE;
        }
        String requestHint = null;
        if (request instanceof CreateConnectionViewRequest && !this.isMessageHint(requestHint = ((CreateConnectionViewRequest)request).getConnectionViewDescriptor().getSemanticHint())) {
            return command;
        }
        Point sourcePoint = (Point)request.getExtendedData().get("Location of connection source point");
        Point targetPoint = request.getLocation();
        boolean messageCreate = ((IHintedType)UMLElementTypes.Message_4006).getSemanticHint().equals(requestHint);
        if (!(sourcePoint != null && sourcePoint.y < targetPoint.y + 2 || messageCreate || this.isLostFoundMessage(requestHint))) {
            return UnexecutableCommand.INSTANCE;
        }
        if (request.getSourceEditPart().equals(request.getTargetEditPart()) && sourcePoint.y >= targetPoint.y) {
            return UnexecutableCommand.INSTANCE;
        }
        if (request instanceof CreateConnectionViewAndElementRequest) {
            CreateConnectionViewAndElementRequest.ConnectionViewAndElementDescriptor desc = ((CreateConnectionViewAndElementRequest)request).getConnectionViewAndElementDescriptor();
            String replyHint = ((IHintedType)UMLElementTypes.Message_4005).getSemanticHint();
            if (replyHint.equals(desc.getSemanticHint()) && request.getSourceEditPart() instanceof IGraphicalEditPart) {
                Rectangle srcBounds = SequenceUtil.getAbsoluteBounds((IGraphicalEditPart)request.getSourceEditPart());
                int bottom = srcBounds.getBottom().y;
                if (bottom >= targetPoint.y + 2) {
                    return UnexecutableCommand.INSTANCE;
                }
            }
        }
        if (messageCreate && request.getSourceEditPart() != null && request.getTargetEditPart() != null && LifelineMessageCreateHelper.hasMessageCreate((GraphicalEditPart)request.getSourceEditPart(), request.getTargetEditPart())) {
            return UnexecutableCommand.INSTANCE;
        }
        request.getExtendedData().put("Source model container", SequenceUtil.findInteractionFragmentContainerAt(sourcePoint, this.getHost()));
        request.getExtendedData().put("Target model container", SequenceUtil.findInteractionFragmentContainerAt(targetPoint, this.getHost()));
        EditPart targetEditPart = this.getTargetEditPart((Request)request);
        if (targetEditPart instanceof CombinedFragment2EditPart) {
            request.getExtendedData().put("Lifeline graphical container", ((CombinedFragment2EditPart)targetEditPart).getAttachedLifeline());
        }
        if (request.getTargetEditPart() instanceof LifelineEditPart && !request.getSourceEditPart().equals(request.getTargetEditPart()) && requestHint.equals(((IHintedType)UMLElementTypes.Message_4006).getSemanticHint())) {
            LifelineEditPart target = (LifelineEditPart)request.getTargetEditPart();
            command = LifelineMessageCreateHelper.moveLifelineDown(command, target, sourcePoint.getCopy());
        }
        return command;
    }

    protected Command getReconnectSourceCommand(ReconnectRequest request) {
        if (this.isUphillMessage(request) && !this.isLostFoundMessage(request)) {
            return UnexecutableCommand.INSTANCE;
        }
        if (request.getConnectionEditPart() instanceof Message4EditPart && request.getTarget() != null && !LifelineMessageCreateHelper.canReconnectMessageCreate(request)) {
            return UnexecutableCommand.INSTANCE;
        }
        return super.getReconnectSourceCommand(request);
    }

    private boolean isLostFoundMessage(ReconnectRequest request) {
        ConnectionEditPart connectionEditPart = request.getConnectionEditPart();
        return connectionEditPart instanceof Message7EditPart || connectionEditPart instanceof Message6EditPart;
    }

    private boolean isLostFoundMessage(String requestHint) {
        return ((IHintedType)UMLElementTypes.Message_4008).getSemanticHint().equals(requestHint) || ((IHintedType)UMLElementTypes.Message_4009).getSemanticHint().equals(requestHint);
    }

    protected Command getReconnectTargetCommand(ReconnectRequest request) {
        if (this.isUphillMessage(request) && !this.isLostFoundMessage(request)) {
            return UnexecutableCommand.INSTANCE;
        }
        if (request.getConnectionEditPart() instanceof Message4EditPart && request.getTarget() != null && !LifelineMessageCreateHelper.canReconnectMessageCreate(request)) {
            return UnexecutableCommand.INSTANCE;
        }
        return super.getReconnectTargetCommand(request);
    }

    protected boolean isUphillMessage(ReconnectRequest request) {
        Edge edge;
        ConnectionEditPart connectionEditPart = request.getConnectionEditPart();
        if (connectionEditPart.getModel() instanceof Edge && (edge = (Edge)connectionEditPart.getModel()).getElement() instanceof Message && connectionEditPart.getFigure() instanceof Polyline) {
            Polyline polyline = (Polyline)connectionEditPart.getFigure();
            Point end = polyline.getEnd().getCopy();
            Point start = polyline.getStart().getCopy();
            polyline.getParent().translateToAbsolute((Translatable)end);
            polyline.getParent().translateToAbsolute((Translatable)start);
            if ("Reconnection source".equals(request.getType())) {
                return request.getLocation().y >= end.y + 2;
            }
            if ("Reconnection target".equals(request.getType())) {
                return start.y >= request.getLocation().y + 2;
            }
            return start.y >= end.y + 2;
        }
        return false;
    }

    protected Connection createDummyConnection(Request req) {
        Connection conn = super.createDummyConnection(req);
        conn.setForegroundColor(ColorConstants.black);
        return conn;
    }

    protected ICommand getPromptAndCreateConnectionCommand(List content, CreateConnectionRequest request) {
        return new SequencePromptAndCreateConnectionCommand(content, request);
    }

    public EditPart getTargetEditPart(Request request) {
        if ("connection start".equals(request.getType()) || "connection end".equals(request.getType()) || "Reconnection source".equals(request.getType()) || "Reconnection target".equals(request.getType())) {
            EditPart host = this.getHost();
            if (request instanceof CreateConnectionRequest) {
                if (host instanceof InteractionEditPart) {
                    if ("connection end".equals(request.getType()) && this.isCreateConnectionRequest(request, UMLElementTypes.Message_4008)) {
                        return host;
                    }
                    if ("connection start".equals(request.getType()) && this.isCreateConnectionRequest(request, UMLElementTypes.Message_4009)) {
                        return host;
                    }
                    InteractionEditPart interactionPart = (InteractionEditPart)host;
                    CreateConnectionRequest req = (CreateConnectionRequest)request;
                    IFigure figure = interactionPart.getFigure();
                    Point location = req.getLocation().getCopy();
                    figure.translateToRelative((Translatable)location);
                    Rectangle innerRetangle = figure.getBounds().getCopy().shrink(20, 20);
                    if (innerRetangle.contains(location)) {
                        return null;
                    }
                } else {
                    if (host instanceof InteractionOperandEditPart) {
                        return null;
                    }
                    if (host instanceof CombinedFragmentEditPart) {
                        CreateConnectionRequest req = (CreateConnectionRequest)request;
                        IFigure figure = ((GraphicalEditPart)host).getFigure();
                        Point location = req.getLocation().getCopy();
                        figure.translateToRelative((Translatable)location);
                        Rectangle innerRetangle = figure.getBounds().getCopy().shrink(10, 10);
                        if (innerRetangle.contains(location)) {
                            return null;
                        }
                    }
                }
            }
            return host;
        }
        return null;
    }

    protected boolean isCreateConnectionRequest(Request request, IElementType type) {
        List types;
        if (request instanceof AspectUnspecifiedTypeConnectionTool.CreateAspectUnspecifiedTypeConnectionRequest && (types = ((CreateUnspecifiedTypeConnectionRequest)request).getElementTypes()).contains(type)) {
            return true;
        }
        if (request instanceof CreateConnectionViewRequest) {
            String requestHint = ((CreateConnectionViewRequest)request).getConnectionViewDescriptor().getSemanticHint();
            if (((IHintedType)type).getSemanticHint().equals(requestHint)) {
                return true;
            }
        }
        return false;
    }

    protected class SequencePromptAndCreateConnectionCommand
    extends GraphicalNodeEditPolicy.PromptAndCreateConnectionCommand {
        public SequencePromptAndCreateConnectionCommand(List content, CreateConnectionRequest request) {
            super((GraphicalNodeEditPolicy)SequenceGraphicalNodeEditPolicy.this, content, request);
        }

        protected ILabelProvider getLabelProvider() {
            return new CreateOrSelectElementCommand.LabelProvider(){

                public String getText(Object object) {
                    if (object instanceof IHintedType) {
                        IHintedType elementType = (IHintedType)object;
                        switch (UMLVisualIDRegistry.getVisualID(elementType.getSemanticHint())) {
                            case 4003: {
                                return Messages.createMessageSync1CreationTool_title;
                            }
                            case 4004: {
                                return Messages.createMessageAsync2CreationTool_title;
                            }
                            case 4005: {
                                return Messages.createMessageReply3CreationTool_title;
                            }
                            case 4006: {
                                return Messages.createMessageCreate4CreationTool_title;
                            }
                            case 4007: {
                                return Messages.createMessageDelete5CreationTool_title;
                            }
                            case 4008: {
                                return Messages.createMessageLost6CreationTool_title;
                            }
                            case 4009: {
                                return Messages.createMessageFound7CreationTool_title;
                            }
                        }
                    }
                    return super.getText(object);
                }
            };
        }
    }
}

