/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.locator;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gmf.runtime.diagram.ui.figures.BorderItemLocator;
import org.eclipse.gmf.runtime.diagram.ui.internal.figures.BorderItemContainerFigure;
import org.eclipse.gmf.runtime.gef.ui.figures.DefaultSizeNodeFigure;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.LifelineEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.figures.DestructionEventFigure;
import org.eclipse.papyrus.uml.diagram.sequence.figures.LifelineDotLineCustomFigure;

public class CenterLocator
extends BorderItemLocator {
    private LifelineDotLineCustomFigure lifelineDotLineFigure = null;
    private BorderItemContainerFigure borderItemContainerFigure = null;
    private DestructionEventFigure destructionEventFigure = null;

    public CenterLocator(IFigure parentFigure, int location) {
        super(parentFigure, location);
    }

    private LifelineDotLineCustomFigure getLifelineDotLineFigure() {
        if (this.lifelineDotLineFigure == null) {
            for (Object childFig : this.getParentFigure().getChildren()) {
                if (!(childFig instanceof LifelineEditPart.LifelineFigure)) continue;
                this.lifelineDotLineFigure = ((LifelineEditPart.LifelineFigure)((Object)childFig)).getFigureLifelineDotLineFigure();
                return this.lifelineDotLineFigure;
            }
        }
        return this.lifelineDotLineFigure;
    }

    private BorderItemContainerFigure getBorderItemContainerFigure() {
        if (this.borderItemContainerFigure == null) {
            IFigure figure = this.getParentFigure().getParent();
            for (Object object : figure.getChildren()) {
                if (!(object instanceof BorderItemContainerFigure)) continue;
                this.borderItemContainerFigure = (BorderItemContainerFigure)object;
                return this.borderItemContainerFigure;
            }
        }
        return this.borderItemContainerFigure;
    }

    private DestructionEventFigure getDestructionEventFigure() {
        BorderItemContainerFigure borderItemContainerFigure;
        if (this.destructionEventFigure == null && (borderItemContainerFigure = this.getBorderItemContainerFigure()) != null) {
            for (Object child : borderItemContainerFigure.getChildren()) {
                if (!(child instanceof DefaultSizeNodeFigure)) continue;
                for (Object figure : ((DefaultSizeNodeFigure)child).getChildren()) {
                    if (!(figure instanceof DestructionEventFigure)) continue;
                    this.destructionEventFigure = (DestructionEventFigure)((Object)figure);
                    return this.destructionEventFigure;
                }
            }
        }
        return this.destructionEventFigure;
    }

    public void relocate(IFigure borderItem) {
        if (this.getDestructionEventFigure() != null && borderItem.equals(this.getDestructionEventFigure().getParent())) {
            borderItem.setLocation(new Point(this.getHorizontalPosition(borderItem), this.getParentBorder().y + this.getParentBorder().height - borderItem.getBounds().height));
            return;
        }
        super.relocate(borderItem);
    }

    public Rectangle getValidLocation(Rectangle proposedLocation, IFigure borderItem) {
        if (this.getDestructionEventFigure() != null && borderItem.equals(this.getDestructionEventFigure().getParent())) {
            Rectangle realLocation = new Rectangle(proposedLocation);
            Point point = new Point(this.getParentBorder().getCenter().x - realLocation.getSize().width / 2, this.getParentBorder().y + this.getParentBorder().height - realLocation.height);
            realLocation.setLocation(point);
            return realLocation;
        }
        return super.getValidLocation(proposedLocation, borderItem);
    }

    protected Rectangle getParentDotLineBorder() {
        LifelineDotLineCustomFigure dotline = this.getLifelineDotLineFigure();
        if (dotline != null) {
            return dotline.getBounds().getCopy();
        }
        return super.getParentBorder();
    }

    protected Point locateOnParent(Point suggestedLocation, int suggestedSide, IFigure borderItem) {
        Dimension borderItemSize = this.getSize(borderItem);
        int y = this.getVerticalPosition(suggestedLocation.y, borderItemSize.height);
        int x = this.getHorizontalPosition(borderItem);
        return new Point(x, y);
    }

    private int getVerticalPosition(int y, int height) {
        int validY = y;
        Rectangle parentDotLineBorder = this.getParentDotLineBorder();
        int maxY = parentDotLineBorder.y + parentDotLineBorder.height - this.getSouthInsets();
        if (y + height > maxY) {
            validY = maxY - height;
        } else if (y < parentDotLineBorder.y) {
            validY = parentDotLineBorder.y;
        }
        return validY;
    }

    private int getHorizontalPosition(IFigure borderItem) {
        return this.getParentBorder().getCenter().x - borderItem.getSize().width / 2;
    }

    private int getSouthInsets() {
        DestructionEventFigure destructionEventFigure = this.getDestructionEventFigure();
        if (destructionEventFigure != null) {
            return destructionEventFigure.getBounds().height;
        }
        return 0;
    }
}

