/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.parser.custom;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.emf.ui.services.parser.ISemanticParser;
import org.eclipse.papyrus.uml.diagram.sequence.parsers.MessageFormatParser;
import org.eclipse.papyrus.uml.tools.utils.ValueSpecificationUtil;
import org.eclipse.uml2.uml.ConnectableElement;
import org.eclipse.uml2.uml.Expression;
import org.eclipse.uml2.uml.Interaction;
import org.eclipse.uml2.uml.Lifeline;
import org.eclipse.uml2.uml.LiteralSpecification;
import org.eclipse.uml2.uml.OpaqueExpression;
import org.eclipse.uml2.uml.PartDecomposition;
import org.eclipse.uml2.uml.TimeExpression;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.ValueSpecification;

public class LifelineCustomParsers
extends MessageFormatParser
implements ISemanticParser {
    public LifelineCustomParsers(EAttribute[] features, EAttribute[] editableFeatures) {
        super(features, editableFeatures);
    }

    public LifelineCustomParsers(EAttribute[] features) {
        super(features);
    }

    public LifelineCustomParsers() {
        super(new EAttribute[]{UMLPackage.eINSTANCE.getNamedElement_Name()});
    }

    protected EStructuralFeature getEStructuralFeature(Object notification) {
        Object feature;
        EStructuralFeature featureImpl = null;
        if (notification instanceof Notification && (feature = ((Notification)notification).getFeature()) instanceof EStructuralFeature) {
            featureImpl = (EStructuralFeature)feature;
        }
        return featureImpl;
    }

    public boolean isAffectingEvent(Object event, int flags) {
        EStructuralFeature feature = this.getEStructuralFeature(event);
        return this.isValidFeature(feature);
    }

    public String getPrintString(IAdaptable element, int flags) {
        Object obj = element.getAdapter(EObject.class);
        StringBuffer sb = new StringBuffer();
        if (obj instanceof Lifeline) {
            Interaction refersTo;
            PartDecomposition partDecomposition;
            String specificationValue;
            Lifeline lifeline = (Lifeline)obj;
            ConnectableElement connectableElement = lifeline.getRepresents();
            ValueSpecification selector = lifeline.getSelector();
            if (connectableElement != null) {
                Type type;
                String connectableElementName = connectableElement.getName();
                if (connectableElementName != null) {
                    sb.append(connectableElementName);
                }
                if (selector instanceof LiteralSpecification) {
                    sb.append("[").append(ValueSpecificationUtil.getSpecificationValue((ValueSpecification)selector)).append("]");
                }
                if ((type = connectableElement.getType()) != null && type.getName() != null && type.getName().length() > 0) {
                    sb.append(" : ").append(type.getName());
                }
            }
            if ((selector instanceof Expression || selector instanceof OpaqueExpression || selector instanceof TimeExpression) && (specificationValue = ValueSpecificationUtil.getSpecificationValue((ValueSpecification)selector)) != null && specificationValue.length() > 0) {
                sb.append("\n").append(specificationValue);
            }
            if ((partDecomposition = lifeline.getDecomposedAs()) != null && (refersTo = partDecomposition.getRefersTo()) != null) {
                sb.append("\nref ").append(refersTo.getName());
            }
            if (sb.length() == 0) {
                sb.append(lifeline.getName());
            }
        }
        return sb.toString();
    }

    public boolean areSemanticElementsAffected(EObject listener, Object notification) {
        EStructuralFeature feature = this.getEStructuralFeature(notification);
        return this.isValidFeature(feature);
    }

    public List getSemanticElementsBeingParsed(EObject element) {
        ArrayList<Object> semanticElementsBeingParsed = new ArrayList<Object>();
        if (element instanceof Lifeline) {
            ConnectableElement connectableElement;
            PartDecomposition partDecomposition;
            Lifeline lifeline = (Lifeline)element;
            semanticElementsBeingParsed.add(lifeline);
            if (lifeline.getSelector() != null) {
                semanticElementsBeingParsed.add(lifeline.getSelector());
            }
            if ((partDecomposition = lifeline.getDecomposedAs()) != null) {
                semanticElementsBeingParsed.add(partDecomposition);
                if (partDecomposition.getRefersTo() != null) {
                    semanticElementsBeingParsed.add(partDecomposition.getRefersTo());
                }
            }
            if ((connectableElement = lifeline.getRepresents()) != null) {
                semanticElementsBeingParsed.add(connectableElement);
                if (connectableElement.getType() != null) {
                    semanticElementsBeingParsed.add(connectableElement.getType());
                }
            }
        }
        return semanticElementsBeingParsed;
    }

    private boolean isValidFeature(EStructuralFeature feature) {
        return UMLPackage.eINSTANCE.getNamedElement_Name().equals(feature) || UMLPackage.eINSTANCE.getTypedElement_Type().equals(feature) || UMLPackage.eINSTANCE.getLiteralInteger_Value().equals(feature) || UMLPackage.eINSTANCE.getLiteralUnlimitedNatural_Value().equals(feature) || UMLPackage.eINSTANCE.getLiteralBoolean_Value().equals(feature) || UMLPackage.eINSTANCE.getLiteralString_Value().equals(feature) || UMLPackage.eINSTANCE.getOpaqueExpression_Body().equals(feature) || UMLPackage.eINSTANCE.getLifeline_Selector().equals(feature) || UMLPackage.eINSTANCE.getLifeline_DecomposedAs().equals(feature) || UMLPackage.eINSTANCE.getLifeline_Represents().equals(feature) || UMLPackage.eINSTANCE.getInteractionUse_RefersTo().equals(feature);
    }
}

