/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.preferences;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.papyrus.infra.gmfdiag.preferences.pages.AbstractPapyrusLinkPreferencePage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class MessagePreferencePage
extends AbstractPapyrusLinkPreferencePage {
    public static final String LABEL_DISPLAY_PREFERENCE = "PapyrusUMLSequenceDiagram_Message.label.display";
    public static final int DEFAULT_LABEL_DISPLAY = 4872;
    private int displayValue = this.getPreferenceStore().getInt("PapyrusUMLSequenceDiagram_Message.label.display");
    private Button dispParamDir;
    private Button dispParamMod;
    private Button dispParamName;
    private Button dispVis;
    private Button dispParamType;
    private Button dispReturnType;
    private Button dispParamMul;
    private Button dispParamDef;
    private Button dispName;
    private Button dispMod;
    private Button dispParamVal;

    public MessagePreferencePage() {
        this.setPreferenceKey("PapyrusUMLSequenceDiagram_Message");
    }

    protected String getBundleId() {
        return "org.eclipse.papyrus.uml.diagram.sequence";
    }

    public static void initDefaults(IPreferenceStore store) {
        store.setDefault(LABEL_DISPLAY_PREFERENCE, 4872);
    }

    protected void createLabelPreferencesButtons(Composite parent) {
        Group group = new Group(parent, 32);
        group.setText("Label Display");
        group.setLayout((Layout)new GridLayout(2, true));
        this.dispParamDir = this.createCheckButton((Composite)group, "Parameters Direction", 2048);
        this.dispParamMod = this.createCheckButton((Composite)group, "Parameters Modifiers", 65536);
        this.dispParamName = this.createCheckButton((Composite)group, "Parameters Name", 4096);
        this.dispVis = this.createCheckButton((Composite)group, "Visibility", 2);
        this.dispParamType = this.createCheckButton((Composite)group, "Parameters Type", 256);
        this.dispReturnType = this.createCheckButton((Composite)group, "Return Type", 512);
        this.dispParamMul = this.createCheckButton((Composite)group, "Parameters Multiplicity", 16384);
        this.dispParamDef = this.createCheckButton((Composite)group, "Parameters Default Value", 32768);
        this.dispParamVal = this.createCheckButton((Composite)group, "Parameters Value", 4);
        this.dispName = this.createCheckButton((Composite)group, "Name", 8);
        this.dispMod = this.createCheckButton((Composite)group, "Modifiers", 128);
    }

    protected void refreshButtons(SelectionEvent e) {
        this.dispParamDir.setSelection(MessagePreferencePage.isCheck(this.displayValue, 2048));
        this.dispParamMod.setSelection(MessagePreferencePage.isCheck(this.displayValue, 65536));
        this.dispParamName.setSelection(MessagePreferencePage.isCheck(this.displayValue, 4096));
        this.dispVis.setSelection(MessagePreferencePage.isCheck(this.displayValue, 2));
        this.dispParamType.setSelection(MessagePreferencePage.isCheck(this.displayValue, 256));
        this.dispReturnType.setSelection(MessagePreferencePage.isCheck(this.displayValue, 512));
        this.dispParamMul.setSelection(MessagePreferencePage.isCheck(this.displayValue, 16384));
        this.dispParamDef.setSelection(MessagePreferencePage.isCheck(this.displayValue, 32768));
        this.dispParamVal.setSelection(MessagePreferencePage.isCheck(this.displayValue, 4));
        this.dispName.setSelection(MessagePreferencePage.isCheck(this.displayValue, 8));
        this.dispMod.setSelection(MessagePreferencePage.isCheck(this.displayValue, 128));
        if (e != null && this.dispParamDef.getSelection() && this.dispParamVal.getSelection()) {
            if (e.widget == this.dispParamDef) {
                this.dispParamVal.setSelection(false);
                this.displayValue ^= 4;
            } else if (e.widget == this.dispParamVal) {
                this.dispParamDef.setSelection(false);
                this.displayValue ^= 0x8000;
            }
        }
    }

    protected void createPageContents(Composite parent) {
        super.createPageContents(parent);
        this.createLabelPreferencesButtons(parent);
        this.refreshButtons(null);
    }

    protected void loadDefaultPreferences() {
        this.displayValue = this.getPreferenceStore().getInt(LABEL_DISPLAY_PREFERENCE);
        this.refreshButtons(null);
    }

    protected void performDefaults() {
        this.loadDefaultPreferences();
        super.performDefaults();
    }

    public boolean performOk() {
        this.storePreferences();
        return super.performOk();
    }

    private static boolean isCheck(int value, int mask) {
        return (value & mask) != 0;
    }

    protected void storePreferences() {
        IPreferenceStore store = this.getPreferenceStore();
        if (this.displayValue != store.getInt(LABEL_DISPLAY_PREFERENCE)) {
            store.setValue(LABEL_DISPLAY_PREFERENCE, this.displayValue);
        }
    }

    protected Button createCheckButton(Composite parent, String label, int mask) {
        Button button = new Button(parent, 32);
        button.setText(label);
        button.addSelectionListener((SelectionListener)new AppearenceSelectionListener(mask));
        return button;
    }

    private class AppearenceSelectionListener
    implements SelectionListener {
        private final int style;

        public AppearenceSelectionListener(int style) {
            this.style = style;
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            MessagePreferencePage messagePreferencePage = MessagePreferencePage.this;
            messagePreferencePage.displayValue = messagePreferencePage.displayValue ^ this.style;
            MessagePreferencePage.this.refreshButtons(e);
        }
    }
}

