/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.editpolicies.IMaskManagedLabelEditPolicy;
import org.eclipse.papyrus.uml.diagram.common.helper.StereotypedElementLabelHelper;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.LifelineNameEditPart;
import org.eclipse.uml2.uml.ConnectableElement;
import org.eclipse.uml2.uml.Lifeline;
import org.eclipse.uml2.uml.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LifelineLabelHelper
extends StereotypedElementLabelHelper {
    private static LifelineLabelHelper labelHelper;
    protected final Map<Integer, String> masks = new HashMap<Integer, String>(7);
    private static final String UNAMED = "<Unnamed>";
    private static final String UNDEFINED = "<Undefined>";

    public static LifelineLabelHelper getInstance() {
        if (labelHelper == null) {
            labelHelper = new LifelineLabelHelper();
        }
        return labelHelper;
    }

    protected LifelineLabelHelper() {
        this.masks.put(2, "Show represent name");
        this.masks.put(4, "Show represent type");
        this.masks.put(8, "Always show undefined type");
        this.masks.put(16, "Always show lifeline name");
    }

    public String getMaskLabel(int value) {
        return this.masks.get(value);
    }

    public Collection<String> getMaskLabels() {
        return this.masks.values();
    }

    public Map<Integer, String> getMasks() {
        return this.masks;
    }

    public Set<Integer> getMaskValues() {
        return this.masks.keySet();
    }

    public Lifeline getUMLElement(GraphicalEditPart editPart) {
        return (Lifeline)((View)editPart.getModel()).getElement();
    }

    protected String elementLabel(GraphicalEditPart editPart) {
        if (editPart instanceof LifelineNameEditPart) {
            editPart = (GraphicalEditPart)editPart.getParent();
        }
        int displayValue = 6;
        IMaskManagedLabelEditPolicy policy = (IMaskManagedLabelEditPolicy)editPart.getEditPolicy((Object)"MaskManagedLabelPolicy");
        if (policy != null) {
            displayValue = policy.getCurrentDisplayValue();
        }
        return this.getCustomLabel(this.getUMLElement(editPart), displayValue);
    }

    private String getCustomLabel(Lifeline lifeline, int displayValue) {
        StringBuilder sb = new StringBuilder();
        this.appendName(lifeline, displayValue, sb);
        this.appendType(lifeline, displayValue, sb);
        return sb.toString();
    }

    protected void appendName(Lifeline lifeline, int displayValue, StringBuilder sb) {
        ConnectableElement element = lifeline.getRepresents();
        String lifelineName = lifeline.getName();
        if (element == null || LifelineLabelHelper.isCheck(displayValue, 16)) {
            this.appendString(sb, lifelineName, UNAMED);
        } else if (LifelineLabelHelper.isCheck(displayValue, 2)) {
            this.appendString(sb, element.getName(), UNAMED);
        } else if (!LifelineLabelHelper.isCheck(displayValue, 2)) {
            this.appendString(sb, lifelineName, UNAMED);
        }
    }

    protected void appendType(Lifeline lifeline, int displayValue, StringBuilder sb) {
        ConnectableElement element = lifeline.getRepresents();
        if (element == null) {
            return;
        }
        Type type = element.getType();
        if (LifelineLabelHelper.isCheck(displayValue, 4)) {
            if (type == null) {
                if (LifelineLabelHelper.isCheck(displayValue, 8)) {
                    sb.append(":").append(UNDEFINED);
                }
            } else {
                this.appendString(sb.append(":"), type.getName(), UNAMED);
            }
        }
    }

    private static boolean isCheck(int value, int mask) {
        return (value & mask) != 0;
    }

    private void appendString(StringBuilder sb, String str, String defaultValue) {
        if (str != null && str.length() > 0) {
            sb.append(str);
        } else {
            sb.append(defaultValue);
        }
    }
}

