/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.statemachine.custom.commands;

import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.diagram.core.commands.DeleteCommand;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.statemachine.custom.helpers.Zone;
import org.eclipse.uml2.uml.StateMachine;

public class CustomRegionDeleteCommand
extends DeleteCommand {
    public CustomRegionDeleteCommand(TransactionalEditingDomain editingDomain, View view) {
        super(editingDomain, view);
    }

    public boolean canExecute() {
        View compartment = (View)this.getView().eContainer();
        if (compartment.getElement() instanceof StateMachine) {
            return compartment.getChildren().size() != 1;
        }
        return true;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        View region = this.getView();
        View compartment = (View)region.eContainer();
        if (compartment.getChildren().size() != 1) {
            int regionWidth = Zone.getWidth(region);
            int regionHeight = Zone.getHeight(region);
            String s = Zone.getZone(region);
            List<View> neighbours = null;
            if (Zone.isRight(s)) {
                neighbours = Zone.getRegionLeftBorderOutsideNeighbours(region);
                for (View view : neighbours) {
                    int width = Zone.getWidth(view);
                    Zone.setWidth(view, width += regionWidth);
                }
            } else if (Zone.isLeft(s)) {
                neighbours = Zone.getRegionRightBorderOutsideNeighbours(region);
                for (View view : neighbours) {
                    int width = Zone.getWidth(view);
                    Zone.setWidth(view, width += regionWidth);
                    int x = Zone.getX(view);
                    Zone.setX(view, x -= regionWidth);
                }
            } else if (Zone.isTop(s)) {
                neighbours = Zone.getRegionBottomBorderOutsideNeighbours(region);
                for (View view : neighbours) {
                    int height = Zone.getHeight(view);
                    Zone.setHeight(view, height += regionHeight);
                    int y = Zone.getY(view);
                    Zone.setY(view, y -= regionHeight);
                }
            } else if (Zone.isBottom(s)) {
                neighbours = Zone.getRegionTopBorderOutsideNeighbours(region);
                for (View view : neighbours) {
                    int height = Zone.getHeight(view);
                    Zone.setHeight(view, height += regionHeight);
                }
            }
            Zone.resetRegionCounterpartZone(region);
        }
        ViewUtil.destroy((View)region);
        return CommandResult.newOKCommandResult();
    }
}

