/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.statemachine.custom.policies;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.diagram.ui.tools.DragEditPartsTrackerEx;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.common.commands.SemanticAdapter;
import org.eclipse.papyrus.uml.diagram.statemachine.custom.commands.CustomRegionResizeCommand;
import org.eclipse.papyrus.uml.diagram.statemachine.custom.figures.RegionFigure;
import org.eclipse.papyrus.uml.diagram.statemachine.custom.helpers.Zone;
import org.eclipse.papyrus.uml.diagram.statemachine.custom.policies.CustomRegionResizableEditPolicy;
import org.eclipse.papyrus.uml.diagram.statemachine.edit.parts.RegionCompartmentEditPart;
import org.eclipse.papyrus.uml.diagram.statemachine.edit.parts.RegionEditPart;

public class CustomRegionDragTracker
extends DragEditPartsTrackerEx {
    protected RegionEditPart regionEP = null;
    CustomRegionResizeCommand internalResizeCommand = null;
    Rectangle regionFigureBounds;

    public CustomRegionDragTracker(RegionEditPart regionEditPart) {
        super((EditPart)regionEditPart);
        this.regionEP = regionEditPart;
    }

    public Rectangle getRegionFigureBounds() {
        return this.regionFigureBounds.getCopy();
    }

    public RegionEditPart getTargetRegionEditPart() {
        EditPart ep = this.getTargetEditPart();
        if (ep != null && ep instanceof RegionCompartmentEditPart && ep.getParent().getParent().equals(this.regionEP.getParent())) {
            return (RegionEditPart)ep.getParent();
        }
        return null;
    }

    protected boolean handleButtonUp(int button) {
        try {
            if (this.internalResizeCommand != null) {
                this.internalResizeCommand.undo(null, null);
            }
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
        return super.handleButtonUp(button);
    }

    protected boolean handleDragStarted() {
        boolean b = super.handleDragStarted();
        CustomRegionResizableEditPolicy policy = (CustomRegionResizableEditPolicy)this.regionEP.getEditPolicy("PrimaryDrag Policy");
        this.regionEP.setSelected(0);
        View regionView = (View)this.regionEP.getModel();
        SemanticAdapter adaptableForRegion = new SemanticAdapter(null, (Object)regionView);
        ChangeBoundsRequest internalResizeRequest = new ChangeBoundsRequest();
        int regionWidth = Zone.getWidth(regionView);
        int regionHeight = Zone.getHeight(regionView);
        RegionFigure regionFigure = this.regionEP.getPrimaryShape();
        this.regionFigureBounds = regionFigure.getBounds().getCopy();
        regionFigure.translateToAbsolute((Translatable)this.regionFigureBounds);
        String zone = Zone.getZone(regionView);
        if (Zone.isRight(zone)) {
            internalResizeRequest.setResizeDirection(8);
            internalResizeRequest.setSizeDelta(new Dimension(-regionWidth, 0));
        } else if (Zone.isLeft(zone)) {
            internalResizeRequest.setResizeDirection(16);
            internalResizeRequest.setSizeDelta(new Dimension(-regionWidth, 0));
        } else if (Zone.isTop(zone)) {
            internalResizeRequest.setResizeDirection(4);
            internalResizeRequest.setSizeDelta(new Dimension(0, -regionHeight));
        } else if (Zone.isBottom(zone)) {
            internalResizeRequest.setResizeDirection(1);
            internalResizeRequest.setSizeDelta(new Dimension(0, -regionHeight));
        }
        this.internalResizeCommand = new CustomRegionResizeCommand((IAdaptable)adaptableForRegion, null, this.regionEP.getEditingDomain(), null, internalResizeRequest, null);
        try {
            this.internalResizeCommand.execute(null, null);
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
        return b;
    }
}

