/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.wizards;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.papyrus.infra.core.utils.DiResourceSet;
import org.eclipse.papyrus.uml.diagram.wizards.Activator;
import org.eclipse.papyrus.uml.diagram.wizards.CreateModelWizard;
import org.eclipse.papyrus.uml.diagram.wizards.Messages;
import org.eclipse.papyrus.uml.diagram.wizards.pages.NewModelFilePage;
import org.eclipse.papyrus.uml.diagram.wizards.pages.SelectDiagramCategoryPage;
import org.eclipse.ui.IWorkbench;

public class CreateSeveralModelsWizard
extends CreateModelWizard {
    private Map<String, NewModelFilePage> myCategory2modelFilePageMap = new TreeMap<String, NewModelFilePage>();
    private IStructuredSelection mySelection;
    private static final String NEW_MODEL_FILE_PAGE_PREFIX = "NewPapyrusModel_";

    protected NewModelFilePage createNewModelFilePage(IStructuredSelection selection) {
        return null;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        super.init(workbench, selection);
        this.mySelection = selection;
    }

    public IStatus diagramCategoryChanged(String ... newCategories) {
        List<String> newCategoriesList = Arrays.asList(newCategories);
        HashSet<String> keys = new HashSet<String>(this.myCategory2modelFilePageMap.keySet());
        for (String oldCategory : keys) {
            if (newCategoriesList.contains(oldCategory)) continue;
            this.myCategory2modelFilePageMap.remove(oldCategory);
        }
        String[] stringArray = newCategories;
        int n = newCategories.length;
        int n2 = 0;
        while (n2 < n) {
            String newCategory = stringArray[n2];
            if (!this.myCategory2modelFilePageMap.containsKey(newCategory)) {
                NewModelFilePage newPage = this.createNewModelFilePage(this.mySelection, newCategory);
                this.myCategory2modelFilePageMap.put(newCategory, newPage);
            }
            ++n2;
        }
        return Status.OK_STATUS;
    }

    protected NewModelFilePage createNewModelFilePage(IStructuredSelection selection, String categoryId) {
        NewModelFilePage newPage = new NewModelFilePage(CreateSeveralModelsWizard.createModelFilePageId(categoryId), selection);
        newPage.setWizard((IWizard)this);
        newPage.setDescription(Messages.bind((String)Messages.CreateSeveralModelsWizard_new_model_file_page_title, (Object)categoryId));
        return newPage;
    }

    public IWizardPage getNextPage(IWizardPage page) {
        String pageId = page.getName();
        if ("SelectDiagramKind".equals(pageId)) {
            String nextKey = this.myCategory2modelFilePageMap.keySet().iterator().next();
            return (IWizardPage)this.myCategory2modelFilePageMap.get(nextKey);
        }
        if (CreateSeveralModelsWizard.isModelFilePageId(pageId) && this.myCategory2modelFilePageMap.containsKey(CreateSeveralModelsWizard.getCategoryForPage(pageId))) {
            String category = CreateSeveralModelsWizard.getCategoryForPage(pageId);
            Iterator<String> iterator = this.myCategory2modelFilePageMap.keySet().iterator();
            while (iterator.hasNext()) {
                if (!category.equals(iterator.next()) || !iterator.hasNext()) continue;
                String nextKey = iterator.next();
                return (IWizardPage)this.myCategory2modelFilePageMap.get(nextKey);
            }
            return null;
        }
        return super.getNextPage(page);
    }

    public IWizardPage getPreviousPage(IWizardPage page) {
        return super.getPreviousPage(page);
    }

    protected SelectDiagramCategoryPage createSelectDiagramCategoryPage() {
        return new SelectDiagramCategoryPage(true);
    }

    public boolean performFinish() {
        String[] stringArray = this.getDiagramCategoryIds();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String category = stringArray[n2];
            IFile newFile = this.createNewModelFile(category);
            DiResourceSet diResourceSet = new DiResourceSet();
            this.createAndOpenPapyrusModel(diResourceSet, newFile, category);
            ++n2;
        }
        this.saveDiagramCategorySettings();
        this.saveDiagramKindSettings();
        return true;
    }

    protected IFile createNewModelFile(String category) {
        NewModelFilePage newModelFilePage = this.myCategory2modelFilePageMap.get(category);
        if (newModelFilePage == null) {
            Activator.log.error(Messages.bind((String)Messages.CreateSeveralModelsWizard_cannot_initiate_page, (Object)category), (Throwable)new Exception());
            return null;
        }
        return newModelFilePage.createNewFile();
    }

    private static String createModelFilePageId(String categoryId) {
        return NEW_MODEL_FILE_PAGE_PREFIX + categoryId;
    }

    private static boolean isModelFilePageId(String pageId) {
        return pageId.startsWith(NEW_MODEL_FILE_PAGE_PREFIX);
    }

    private static String getCategoryForPage(String pageId) {
        return pageId.substring(NEW_MODEL_FILE_PAGE_PREFIX.length());
    }
}

