/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.importt.handlers;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.papyrus.infra.widgets.editors.IElementSelector;
import org.eclipse.papyrus.infra.widgets.editors.MultipleValueSelectorDialog;
import org.eclipse.papyrus.infra.widgets.providers.IStaticContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.WorkspaceContentProvider;
import org.eclipse.papyrus.infra.widgets.selectors.ReferenceSelector;
import org.eclipse.papyrus.uml.extensionpoints.utils.Util;
import org.eclipse.papyrus.uml.importt.handlers.AbstractImportHandler;
import org.eclipse.papyrus.uml.importt.ui.PackageImportDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.uml2.uml.Package;

public class ImportPackageFromWorkspaceHandler
extends AbstractImportHandler {
    protected Command getCommand() {
        return new ImportFromFileCommand();
    }

    public class ImportFromFileCommand
    extends AbstractImportHandler.AbstractImportCommand {
        public ImportFromFileCommand() {
            super(new Runnable(){

                public void run() {
                    Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                    ReferenceSelector selector = new ReferenceSelector();
                    ILabelProvider labelProvider = WorkbenchLabelProvider.getDecoratingWorkbenchLabelProvider();
                    selector.setLabelProvider(labelProvider);
                    selector.setContentProvider((IStaticContentProvider)new WorkspaceContentProvider());
                    MultipleValueSelectorDialog chooseLib = new MultipleValueSelectorDialog(shell, (IElementSelector)selector);
                    chooseLib.setLabelProvider(WorkbenchLabelProvider.getDecoratingWorkbenchLabelProvider());
                    chooseLib.setUnique(true);
                    chooseLib.setTitle("Select the models to import");
                    chooseLib.open();
                    Object[] selection = chooseLib.getResult();
                    if (selection == null) {
                        return;
                    }
                    ResourceSet resourceSet = Util.getResourceSet((EObject)ImportPackageFromWorkspaceHandler.this.getSelectedElement());
                    Object[] objectArray = selection;
                    int n = selection.length;
                    int n2 = 0;
                    while (n2 < n) {
                        block13: {
                            Object selectedElement = objectArray[n2];
                            if (!(selectedElement instanceof IFile)) {
                                MessageDialog.openWarning((Shell)shell, (String)"Selection is not a File", (String)("The selected element is not a File: " + labelProvider.getText(selectedElement)));
                            } else {
                                Resource modelResource;
                                IFile currentFile = (IFile)selectedElement;
                                URI modelUri = URI.createURI((String)("platform:/resource" + currentFile.getFullPath()));
                                try {
                                    modelResource = resourceSet.getResource(modelUri, true);
                                }
                                catch (Exception ex) {
                                    MessageDialog.openWarning((Shell)shell, (String)"Invalid model", (String)("The selected file is not a valid model: " + labelProvider.getText(selectedElement)));
                                    modelResource = resourceSet.getResource(modelUri, false);
                                    if (modelResource == null) break block13;
                                    resourceSet.getResources().remove((Object)modelResource);
                                    break block13;
                                }
                                if (modelResource.getContents().isEmpty()) {
                                    MessageDialog.openWarning((Shell)shell, (String)"Model is empty", (String)("The selected model is empty: " + labelProvider.getText(selectedElement)));
                                } else if (!(modelResource.getContents().get(0) instanceof Package)) {
                                    MessageDialog.openWarning((Shell)shell, (String)"Model is not a Package", (String)("The selected model is not a valid UML Package: " + labelProvider.getText(selectedElement)));
                                } else {
                                    PackageImportDialog dialog = new PackageImportDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (Package)modelResource.getContents().get(0));
                                    if (dialog.open() == 0) {
                                        ArrayList result = dialog.getResult();
                                        for (Object resultElement : result) {
                                            Package selectedPackage = (Package)resultElement;
                                            if (dialog.isCopy()) {
                                                ImportPackageFromWorkspaceHandler.this.handleCopyPackage(selectedPackage);
                                                continue;
                                            }
                                            ImportPackageFromWorkspaceHandler.this.handleImportPackage(selectedPackage);
                                        }
                                    }
                                }
                            }
                        }
                        ++n2;
                    }
                }
            }, "Import Libraries", "Import Libraries from Workspace");
        }
    }
}

