/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.importt.handlers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.papyrus.uml.extensionpoints.library.FilteredRegisteredLibrariesSelectionDialog;
import org.eclipse.papyrus.uml.extensionpoints.library.RegisteredLibrary;
import org.eclipse.papyrus.uml.extensionpoints.utils.Util;
import org.eclipse.papyrus.uml.importt.handlers.AbstractImportHandler;
import org.eclipse.papyrus.uml.importt.ui.PackageImportDialog;
import org.eclipse.papyrus.uml.tools.utils.PackageUtil;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.uml2.uml.Package;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportRegisteredPackageHandler
extends AbstractImportHandler {
    protected Command getCommand() {
        return new ImportLibraryFromRepositoryCommand();
    }

    protected void importLibraries(RegisteredLibrary[] librariesToImport) {
        ResourceSet resourceSet = Util.getResourceSet((EObject)this.getSelectedElement());
        int i = 0;
        while (i < librariesToImport.length) {
            RegisteredLibrary currentLibrary = librariesToImport[i];
            URI modelUri = currentLibrary.uri;
            Resource modelResource = resourceSet.getResource(modelUri, true);
            PackageImportDialog dialog = new PackageImportDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (Package)modelResource.getContents().get(0));
            if (dialog.open() == 0) {
                ArrayList result = dialog.getResult();
                for (Object resultElement : result) {
                    Package selectedPackage = (Package)resultElement;
                    if (dialog.isCopy()) {
                        this.handleCopyPackage(selectedPackage);
                        continue;
                    }
                    this.handleImportPackage(selectedPackage);
                }
            }
            ++i;
        }
    }

    protected RegisteredLibrary[] getAvailableLibraries() {
        ArrayList<RegisteredLibrary> libraries = new ArrayList<RegisteredLibrary>();
        RegisteredLibrary[] allLibraries = RegisteredLibrary.getRegisteredLibraries();
        int i = 0;
        while (i < allLibraries.length) {
            RegisteredLibrary registeredLibrary = allLibraries[i];
            List importedPackageNames = PackageUtil.getImportedPackagesNames((Package)((Package)this.getSelectedElement()));
            if (!importedPackageNames.contains(registeredLibrary.getName())) {
                libraries.add(registeredLibrary);
            }
            ++i;
        }
        return libraries.toArray(new RegisteredLibrary[libraries.size()]);
    }

    protected Collection<RegisteredLibrary> getImportedLibraries() {
        ArrayList<RegisteredLibrary> libraries = new ArrayList<RegisteredLibrary>();
        RegisteredLibrary[] allLibraries = RegisteredLibrary.getRegisteredLibraries();
        int i = 0;
        while (i < allLibraries.length) {
            RegisteredLibrary registeredLibrary = allLibraries[i];
            List importedPackageNames = PackageUtil.getImportedPackagesNames((Package)((Package)this.getSelectedElement()));
            if (importedPackageNames.contains(registeredLibrary.getName())) {
                libraries.add(registeredLibrary);
            }
            ++i;
        }
        return libraries;
    }

    public class ImportLibraryFromRepositoryCommand
    extends AbstractImportHandler.AbstractImportCommand {
        public ImportLibraryFromRepositoryCommand() {
            super(new Runnable(){

                public void run() {
                    Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                    Object[] allLibraries = RegisteredLibrary.getRegisteredLibraries();
                    FilteredRegisteredLibrariesSelectionDialog dialog = new FilteredRegisteredLibrariesSelectionDialog(shell, true, allLibraries, ImportRegisteredPackageHandler.this.getImportedLibraries());
                    dialog.open();
                    if (dialog.getReturnCode() == 0) {
                        List<Object> librariesToImport = Arrays.asList(dialog.getResult());
                        ImportRegisteredPackageHandler.this.importLibraries(librariesToImport.toArray(new RegisteredLibrary[librariesToImport.size()]));
                    }
                }
            }, "Import Libraries", "Import Libraries from Repository");
        }
    }
}

