/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.profile.model;

import java.util.Collection;
import java.util.Map;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.papyrus.infra.core.resource.IModelSetSnippet;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.resource.NotFoundException;
import org.eclipse.papyrus.infra.core.resource.uml.UmlModel;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.uml.profile.Activator;
import org.eclipse.papyrus.uml.profile.model.RefreshProfileDialog;
import org.eclipse.papyrus.uml.tools.commands.ApplyProfileCommand;
import org.eclipse.papyrus.uml.tools.utils.ProfileUtil;
import org.eclipse.swt.widgets.Display;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;

public class ProfileApplicationModel
implements IModelSetSnippet {
    protected Package rootPackage;

    public void start(ModelSet modelsManager) {
        UmlModel umlModel = (UmlModel)modelsManager.getModel("org.eclipse.papyrus.infra.core.resource.uml.UmlModel");
        if (umlModel == null) {
            return;
        }
        this.rootPackage = this.getRootPackage(umlModel);
        if (this.rootPackage == null) {
            return;
        }
        this.checkAndRefreshProfiles(this.rootPackage);
    }

    protected Package getRootPackage(UmlModel umlModel) {
        try {
            EObject root = umlModel.lookupRoot();
            if (root instanceof Package) {
                return (Package)root;
            }
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        return null;
    }

    protected boolean checkAndRefreshProfiles(Package currentPackage) {
        for (Profile profile : currentPackage.getAppliedProfiles()) {
            if (!ProfileUtil.isDirty((Package)currentPackage, (Profile)profile)) continue;
            RefreshProfileDialog dialog = new RefreshProfileDialog(Display.getCurrent().getActiveShell(), this.rootPackage);
            dialog.setCallback(this.getCallback(dialog));
            dialog.open();
            return true;
        }
        for (Package nestedPackage : currentPackage.getNestedPackages()) {
            if (!this.checkAndRefreshProfiles(nestedPackage)) continue;
            return true;
        }
        return false;
    }

    protected Runnable getCallback(final RefreshProfileDialog dialog) {
        return new Runnable(){

            public void run() {
                Map<Package, Collection<Profile>> profilesToReapply = dialog.getProfilesToReapply();
                EditingDomain domain = EMFHelper.resolveEditingDomain((EObject)ProfileApplicationModel.this.rootPackage);
                if (domain instanceof TransactionalEditingDomain) {
                    CompoundCommand command = new CompoundCommand();
                    for (Map.Entry<Package, Collection<Profile>> profiles : profilesToReapply.entrySet()) {
                        command.append((Command)new ApplyProfileCommand(profiles.getKey(), profiles.getValue(), (TransactionalEditingDomain)domain));
                    }
                    domain.getCommandStack().execute((Command)command);
                } else {
                    Activator.log.error((Throwable)new IllegalArgumentException("Cannot reapply profiles on Package " + ProfileApplicationModel.this.rootPackage.getQualifiedName() + ". The EditingDomain cannot be found"));
                }
            }
        };
    }

    public void dispose(ModelSet modelsManager) {
        this.rootPackage = null;
    }
}

