/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.service.types.helper.advice;

import com.google.common.collect.Sets;
import java.util.HashSet;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.AbstractEditHelperAdvice;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyDependentsRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.papyrus.commands.DestroyElementPapyrusCommand;
import org.eclipse.uml2.uml.Activity;
import org.eclipse.uml2.uml.ActivityEdge;
import org.eclipse.uml2.uml.ActivityNode;
import org.eclipse.uml2.uml.UMLPackage;

public class ActivityNodeHelperAdvice
extends AbstractEditHelperAdvice {
    protected ICommand getBeforeDestroyDependentsCommand(DestroyDependentsRequest request) {
        CompositeCommand cc = new CompositeCommand("Before Command for an Activity Node");
        ICommand destroyEdgeCommand = this.getDestroyActivityEdgeCommand(request);
        if (destroyEdgeCommand != null) {
            cc.compose((IUndoableOperation)destroyEdgeCommand);
        }
        if (cc != null && !cc.isEmpty()) {
            return cc;
        }
        return super.getBeforeDestroyDependentsCommand(request);
    }

    protected ICommand getAfterDestroyDependentsCommand(DestroyDependentsRequest request) {
        CompositeCommand cc = new CompositeCommand("After Command for an Activity Node");
        ICommand removedFromOwnedNodeCommand = this.getRemoveFromDerivedFeature(request);
        if (removedFromOwnedNodeCommand != null) {
            cc.compose((IUndoableOperation)removedFromOwnedNodeCommand);
        }
        if (cc != null && !cc.isEmpty()) {
            return cc;
        }
        return super.getAfterDestroyDependentsCommand(request);
    }

    protected ICommand getRemoveFromDerivedFeature(DestroyDependentsRequest request) {
        ActivityNode activityNode;
        EStructuralFeature containingFeature;
        EObject eObject = request.getElementToDestroy();
        if (eObject instanceof ActivityNode && UMLPackage.Literals.ACTIVITY__OWNED_NODE.equals(containingFeature = (activityNode = (ActivityNode)eObject).eContainingFeature())) {
            Activity holder = (Activity)activityNode.eContainer();
            return new AbstractTransactionalCommand((TransactionalEditingDomain)AdapterFactoryEditingDomain.getEditingDomainFor((EObject)activityNode), "test", null){

                protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                    Object elements = holder.eGet((EStructuralFeature)UMLPackage.Literals.ACTIVITY__NODE);
                    if (elements instanceof EList) {
                        EList collection = (EList)elements;
                        collection.remove((Object)activityNode);
                    }
                    return CommandResult.newOKCommandResult();
                }
            };
        }
        return null;
    }

    protected ICommand getDestroyActivityEdgeCommand(DestroyDependentsRequest request) {
        EObject eObject = request.getElementToDestroy();
        if (eObject instanceof ActivityNode) {
            ActivityNode activityNode = (ActivityNode)eObject;
            EList incomings = activityNode.getIncomings();
            EList outgoings = activityNode.getOutgoings();
            HashSet edges = Sets.newHashSet();
            if (incomings != null && !incomings.isEmpty()) {
                edges.addAll(incomings);
            }
            if (outgoings != null && !outgoings.isEmpty()) {
                edges.addAll(outgoings);
            }
            if (!edges.isEmpty()) {
                CompositeCommand cc = new CompositeCommand("Detele Incomings and outgoings edges from activity node");
                for (ActivityEdge e : edges) {
                    DestroyElementRequest destroyRequest = new DestroyElementRequest((EObject)e, false);
                    DestroyElementPapyrusCommand destroyCommand = new DestroyElementPapyrusCommand(destroyRequest);
                    if (destroyCommand == null || !destroyCommand.canExecute()) continue;
                    cc.compose((IUndoableOperation)destroyCommand);
                }
                return cc;
            }
        }
        return null;
    }
}

