/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.table.widget.celleditors.composite;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.facet.widgets.celleditors.AbstractCellEditorComposite;
import org.eclipse.emf.facet.widgets.celleditors.internal.Messages;
import org.eclipse.emf.facet.widgets.internal.CustomizableLabelProvider;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.fieldassist.ComboContentAdapter;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.SimpleContentProposalProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.papyrus.infra.widgets.editors.ReferenceCombo;
import org.eclipse.papyrus.infra.widgets.editors.TreeSelectorDialog;
import org.eclipse.papyrus.uml.tools.providers.UMLContentProvider;
import org.eclipse.papyrus.uml.tools.providers.UMLLabelProvider;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnaryReferencePapyrusCellEditorComposite
extends AbstractCellEditorComposite<EObject> {
    private static final int GRID_DATA_HEIGHT = 50;
    private final Button button;
    private final Combo combo;
    private final ReferenceCombo referenceCombo;
    private final Control parentControl;
    private EObject source;
    private final Map<String, EObject> fElements = new TreeMap<String, EObject>();
    private EObject semanticRoot;
    private EStructuralFeature feature;

    public UnaryReferencePapyrusCellEditorComposite(final Composite parent, List<EObject> eObjects, final EObject source, final EStructuralFeature feature) {
        super(parent);
        this.source = source;
        this.feature = feature;
        this.parentControl = parent;
        CustomizableLabelProvider customizableLabelProvider = new CustomizableLabelProvider();
        for (EObject eObject : eObjects) {
            String label = customizableLabelProvider.getText(eObject);
            if (this.fElements.get(label) != null) {
                int suffix = 2;
                while (this.fElements.get(String.valueOf(label) + " (" + suffix + ")") != null) {
                    ++suffix;
                }
                this.fElements.put(String.valueOf(label) + " (" + suffix + ")", eObject);
                continue;
            }
            this.fElements.put(label, eObject);
        }
        GridLayout compositeLayout = new GridLayout(2, false);
        compositeLayout.marginHeight = 0;
        compositeLayout.marginWidth = 0;
        compositeLayout.horizontalSpacing = 0;
        this.setLayout((Layout)compositeLayout);
        this.combo = new Combo((Composite)this, 4);
        this.referenceCombo = null;
        FontData[] fontData = Display.getDefault().getSystemFont().getFontData();
        fontData[0].setHeight(fontData[0].getHeight());
        Font font = new Font((Device)Display.getDefault(), fontData);
        this.combo.setFont(font);
        for (String label : this.fElements.keySet()) {
            this.combo.add(label);
        }
        GridData comboGridData = new GridData(4, 4, true, true);
        this.combo.setLayoutData((Object)comboGridData);
        UnaryReferencePapyrusCellEditorComposite.addCompletionHandler(this.combo, this.fElements.keySet());
        this.combo.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.keyCode == 13 && event.stateMask == 0 || event.keyCode == 0x1000050 && event.stateMask == 0) {
                    if (UnaryReferencePapyrusCellEditorComposite.this.isValid()) {
                        UnaryReferencePapyrusCellEditorComposite.this.commit();
                    } else {
                        MessageDialog.openWarning((Shell)parent.getShell(), (String)Messages.UnaryReferenceCellEditorComposite_0, (String)Messages.UnaryReferenceCellEditorComposite_1);
                    }
                } else if (event.keyCode == 27 && event.stateMask == 0) {
                    UnaryReferencePapyrusCellEditorComposite.this.close();
                }
            }
        });
        this.button = new Button((Composite)this, 8);
        this.button.setText("...");
        GridData buttonGridData = new GridData(4, 4, false, true);
        buttonGridData.heightHint = 50;
        this.button.setLayoutData((Object)buttonGridData);
        this.button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                final UMLContentProvider provider = new UMLContentProvider(source, feature);
                UMLLabelProvider labelProvider = new UMLLabelProvider();
                TreeSelectorDialog dialog = new TreeSelectorDialog(Display.getCurrent().getActiveShell()){

                    public void okPressed() {
                        Object[] selectedElements = new Object[this.getResult().length];
                        Object[] result = this.getResult();
                        int i = 0;
                        while (i < result.length) {
                            Object adapted;
                            selectedElements[i] = adapted = provider.getAdaptedValue(result[i]);
                            ++i;
                        }
                        String selectedElementLabel = null;
                        if (selectedElements.length > 0) {
                            Set<Map.Entry<String, EObject>> entrySet = UnaryReferencePapyrusCellEditorComposite.this.getfElements().entrySet();
                            for (Map.Entry<String, EObject> entry : entrySet) {
                                if (entry.getValue() != selectedElements[0]) continue;
                                selectedElementLabel = entry.getKey();
                                break;
                            }
                        }
                        UnaryReferencePapyrusCellEditorComposite.this.getCombo().setText(selectedElementLabel);
                        UnaryReferencePapyrusCellEditorComposite.this.commit();
                        super.okPressed();
                        super.close();
                    }
                };
                dialog.setLabelProvider((ILabelProvider)labelProvider);
                dialog.setContentProvider((ITreeContentProvider)provider);
                if (source != null) {
                    dialog.setInitialElementSelections(Collections.singletonList(source.eGet(feature)));
                }
                dialog.setTitle(feature.getEType().getName());
                dialog.open();
            }
        });
        final Listener clickListener = new Listener(){

            public void handleEvent(Event event) {
                Control control;
                if (event.widget instanceof Control && (control = (Control)event.widget).getShell() == UnaryReferencePapyrusCellEditorComposite.this.getParentControl().getShell() && event.widget != UnaryReferencePapyrusCellEditorComposite.this.getButton() && event.widget != UnaryReferencePapyrusCellEditorComposite.this.getCombo() && UnaryReferencePapyrusCellEditorComposite.this.isValid()) {
                    UnaryReferencePapyrusCellEditorComposite.this.commit();
                }
            }
        };
        Display.getDefault().addFilter(3, clickListener);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                Display.getDefault().removeFilter(3, clickListener);
            }
        });
        this.combo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                UnaryReferencePapyrusCellEditorComposite.this.fireChanged();
            }
        });
        this.combo.forceFocus();
    }

    protected boolean isValid() {
        return this.fElements.get(this.combo.getText()) != null;
    }

    private static void addCompletionHandler(Combo comboBox, Collection<String> completions) {
        String[] completionsArray = completions.toArray(new String[completions.size()]);
        SimpleContentProposalProvider contentProposalProvider = new SimpleContentProposalProvider(completionsArray);
        contentProposalProvider.setFiltering(true);
        ContentProposalAdapter adapter = new ContentProposalAdapter((Control)comboBox, (IControlContentAdapter)new ComboContentAdapter(), (IContentProposalProvider)contentProposalProvider, null, null);
        adapter.setProposalAcceptanceStyle(2);
    }

    public EObject getValue() {
        EObject eObject = this.fElements.get(this.combo.getText());
        return eObject;
    }

    protected void commit() {
        this.fireCommit();
    }

    public void setValue(EObject value) {
        int d = 0;
        ++d;
    }

    protected Button getButton() {
        return this.button;
    }

    protected Combo getCombo() {
        return this.combo;
    }

    protected Control getParentControl() {
        return this.parentControl;
    }

    protected Map<String, EObject> getfElements() {
        return this.fElements;
    }
}

