/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.tools.databinding;

import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.value.AbstractObservableValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.ValueDiff;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.papyrus.commands.wrappers.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrus.infra.tools.databinding.AggregatedObservable;
import org.eclipse.papyrus.uml.tools.Activator;
import org.eclipse.papyrus.uml.tools.databinding.AggregatedPapyrusObservableValue;
import org.eclipse.papyrus.uml.tools.databinding.CommandBasedObservableValue;
import org.eclipse.papyrus.uml.tools.helper.UMLDatabindingHelper;
import org.eclipse.uml2.uml.UMLPackage;

public class MultiplicityObservableValue
extends AbstractObservableValue
implements IChangeListener,
CommandBasedObservableValue,
AggregatedObservable {
    public static String ANY = "0..*";
    public static String STAR = "*";
    public static String ONE = "1";
    public static String OPTIONAL = "0..1";
    public static String ONE_OR_MORE = "1..*";
    public static String SEPARATOR = "..";
    private IObservableValue lowerBound;
    private IObservableValue upperBound;
    private IObservableValue lowerValue;
    private IObservableValue upperValue;
    private IObservableValue lowerValueSpecification;
    private IObservableValue upperValueSpecification;
    private EStructuralFeature lowerFeature;
    private EStructuralFeature upperFeature;
    private EObject eObject;
    private EditingDomain domain;

    public MultiplicityObservableValue(EObject eObject, EditingDomain domain) {
        this.eObject = eObject;
        this.domain = domain;
        this.lowerFeature = UMLPackage.eINSTANCE.getMultiplicityElement_Lower();
        this.upperFeature = UMLPackage.eINSTANCE.getMultiplicityElement_Upper();
        EReference lowerValueFeature = UMLPackage.eINSTANCE.getMultiplicityElement_LowerValue();
        EReference upperValueFeature = UMLPackage.eINSTANCE.getMultiplicityElement_UpperValue();
        EAttribute lowerValueSpecificationFeature = UMLPackage.eINSTANCE.getLiteralInteger_Value();
        EAttribute upperValueSpecificationFeature = UMLPackage.eINSTANCE.getLiteralUnlimitedNatural_Value();
        this.lowerBound = UMLDatabindingHelper.getObservableValue(eObject, this.lowerFeature, domain);
        this.upperBound = UMLDatabindingHelper.getObservableValue(eObject, this.upperFeature, domain);
        this.lowerValue = UMLDatabindingHelper.getObservableValue(eObject, (EStructuralFeature)lowerValueFeature, domain);
        this.upperValue = UMLDatabindingHelper.getObservableValue(eObject, (EStructuralFeature)upperValueFeature, domain);
        this.lowerValueSpecification = this.getValueSpecification(this.lowerValue, (EStructuralFeature)lowerValueSpecificationFeature, domain);
        this.upperValueSpecification = this.getValueSpecification(this.upperValue, (EStructuralFeature)upperValueSpecificationFeature, domain);
        this.lowerValue.addChangeListener((IChangeListener)this);
        this.upperValue.addChangeListener((IChangeListener)this);
        if (this.lowerValueSpecification != null) {
            this.lowerValueSpecification.addChangeListener((IChangeListener)this);
        }
        if (this.upperValueSpecification != null) {
            this.upperValueSpecification.addChangeListener((IChangeListener)this);
        }
    }

    private IObservableValue getValueSpecification(IObservableValue source, EStructuralFeature specificationFeature, EditingDomain domain) {
        if (source.getValue() == null) {
            return null;
        }
        return UMLDatabindingHelper.getObservableValue((EObject)source.getValue(), specificationFeature, domain);
    }

    public void handleChange(ChangeEvent event) {
        boolean fireChange = false;
        if (event.getSource() == this.lowerValue || event.getSource() == this.upperValue) {
            fireChange = true;
            this.lowerValueSpecification = this.getValueSpecification(this.lowerValue, (EStructuralFeature)UMLPackage.eINSTANCE.getLiteralInteger_Value(), this.domain);
            this.upperValueSpecification = this.getValueSpecification(this.upperValue, (EStructuralFeature)UMLPackage.eINSTANCE.getLiteralUnlimitedNatural_Value(), this.domain);
        }
        if (event.getSource() == this.lowerValueSpecification || event.getSource() == this.upperValueSpecification) {
            fireChange = true;
        }
        if (fireChange) {
            final Object value = this.getValue();
            this.fireValueChange(new ValueDiff(){

                public Object getOldValue() {
                    return null;
                }

                public Object getNewValue() {
                    return value;
                }
            });
        }
    }

    public synchronized void dispose() {
        this.lowerValue.removeChangeListener((IChangeListener)this);
        this.upperValue.removeChangeListener((IChangeListener)this);
        if (this.lowerValueSpecification != null) {
            this.lowerValueSpecification.removeChangeListener((IChangeListener)this);
            this.lowerValueSpecification.dispose();
        }
        if (this.upperValueSpecification != null) {
            this.upperValueSpecification.removeChangeListener((IChangeListener)this);
            this.upperValueSpecification.dispose();
        }
        this.lowerValue.dispose();
        this.upperValue.dispose();
        this.lowerBound.dispose();
        this.upperBound.dispose();
        super.dispose();
    }

    public Object getValueType() {
        return String.class;
    }

    protected String doGetValue() {
        int lower = 0;
        int upper = 0;
        Object lowerValue = this.lowerBound.getValue();
        Object upperValue = this.upperBound.getValue();
        lower = (Integer)lowerValue;
        upper = (Integer)upperValue;
        if (lower == 0 && upper == -1) {
            return ANY;
        }
        if (lower == 0 && upper == 1) {
            return OPTIONAL;
        }
        if (lower == 1 && upper == -1) {
            return ONE_OR_MORE;
        }
        if (lower == 1 && upper == 1) {
            return ONE;
        }
        return String.valueOf(lower) + SEPARATOR + (upper < 0 ? STAR : Integer.valueOf(upper));
    }

    protected void doSetValue(Object value) {
        Command command = this.getCommand(value);
        this.domain.getCommandStack().execute(command);
    }

    private Command getSetCommand(EStructuralFeature feature, int value) {
        IElementEditService provider = ElementEditServiceUtils.getCommandProvider((Object)this.eObject);
        if (provider != null) {
            SetRequest request = new SetRequest(this.eObject, feature, (Object)value);
            ICommand createGMFCommand = provider.getEditCommand((IEditCommandRequest)request);
            GMFtoEMFCommandWrapper emfCommand = new GMFtoEMFCommandWrapper(createGMFCommand);
            return emfCommand;
        }
        return null;
    }

    public Command getCommand(Object value) {
        int upper;
        int lower;
        String val = (String)value;
        if (val.equals(ANY) || val.equals(STAR)) {
            lower = 0;
            upper = -1;
        } else if (val.equals(OPTIONAL)) {
            lower = 0;
            upper = 1;
        } else if (val.equals(ONE_OR_MORE)) {
            lower = 1;
            upper = -1;
        } else if (val.equals(ONE)) {
            lower = 1;
            upper = 1;
        } else if (val.matches("^[0-9]+(..[0-9*]+)?$")) {
            try {
                if (val.contains(SEPARATOR)) {
                    lower = Integer.parseInt(val.substring(0, val.indexOf(SEPARATOR)));
                    String upperString = val.substring(val.indexOf(SEPARATOR) + SEPARATOR.length(), val.length());
                    if (STAR.equals(upperString)) {
                        upper = -1;
                    }
                    upper = Integer.parseInt(upperString);
                }
                lower = Integer.parseInt(val);
                upper = Integer.parseInt(val);
            }
            catch (NumberFormatException ex) {
                return UnexecutableCommand.INSTANCE;
            }
        } else {
            return UnexecutableCommand.INSTANCE;
        }
        if (upper > 0 && upper < lower || upper == 0) {
            return UnexecutableCommand.INSTANCE;
        }
        try {
            Command lowerSetCommand = this.getSetCommand(this.lowerFeature, lower);
            Command upperSetCommand = this.getSetCommand(this.upperFeature, upper);
            CompoundCommand command = new CompoundCommand("Set multiplicity");
            command.append(lowerSetCommand);
            command.append(upperSetCommand);
            return command;
        }
        catch (Exception ex) {
            Activator.log.error((Throwable)ex);
            return UnexecutableCommand.INSTANCE;
        }
    }

    public AggregatedObservable aggregate(IObservable observable) {
        try {
            return new AggregatedPapyrusObservableValue(this.domain, this, observable);
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
    }

    public boolean hasDifferentValues() {
        return false;
    }
}

