/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.tools.providers;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ResizableCompartmentEditPart;
import org.eclipse.gmf.runtime.diagram.ui.services.editpart.EditPartService;
import org.eclipse.gmf.runtime.notation.BasicCompartment;
import org.eclipse.gmf.runtime.notation.DecorationNode;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.papyrus.infra.core.editorsfactory.IPageIconsRegistry;
import org.eclipse.papyrus.infra.core.editorsfactory.PageIconsRegistry;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.utils.ServiceUtilsForActionHandlers;
import org.eclipse.papyrus.infra.emf.providers.EMFLabelProvider;
import org.eclipse.papyrus.uml.tools.Activator;
import org.eclipse.papyrus.uml.tools.utils.ImageUtil;
import org.eclipse.papyrus.uml.tools.utils.TypeUtil;
import org.eclipse.swt.graphics.Image;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.ClassifierTemplateParameter;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.ElementImport;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.InstanceValue;
import org.eclipse.uml2.uml.LiteralNull;
import org.eclipse.uml2.uml.LiteralString;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.OperationTemplateParameter;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageImport;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.TemplateParameter;
import org.eclipse.uml2.uml.TemplateParameterSubstitution;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.ValueSpecification;
import org.eclipse.uml2.uml.util.UMLUtil;

public class UMLLabelProvider
extends EMFLabelProvider
implements ILabelProvider {
    public static final String ICON_METACLASS = "/icons/Metaclass.gif";
    public static final String ICON_COMPARTMENT = "/icons/none_comp_vis.gif";

    protected Image getImage(EObject element) {
        if ((element = this.resolveElement(element)) instanceof Class && TypeUtil.isMetaclass((Type)((Type)element))) {
            return org.eclipse.papyrus.infra.widgets.Activator.getDefault().getImage("org.eclipse.papyrus.uml.tools", ICON_METACLASS);
        }
        if (element instanceof Element) {
            Image image = Activator.getDefault().getIconElement((Element)element);
            return image == null ? super.getImage(element) : image;
        }
        if (element instanceof BasicCompartment || element instanceof DecorationNode) {
            return org.eclipse.papyrus.infra.widgets.Activator.getDefault().getImage("org.eclipse.papyrus.uml.tools", ICON_COMPARTMENT);
        }
        if (element instanceof Diagram) {
            IPageIconsRegistry registry = null;
            try {
                registry = (IPageIconsRegistry)ServiceUtilsForActionHandlers.getInstance().getServiceRegistry().getService(IPageIconsRegistry.class);
            }
            catch (ServiceException serviceException) {
                // empty catch block
            }
            if (registry == null) {
                registry = new PageIconsRegistry();
            }
            return registry.getEditorIcon((Object)element);
        }
        return super.getImage(element);
    }

    protected EObject resolveElement(EObject inputElement) {
        if (inputElement == null) {
            return null;
        }
        Element baseElement = UMLUtil.getBaseElement((EObject)inputElement);
        if (baseElement != null) {
            return baseElement;
        }
        return inputElement;
    }

    protected String getText(EObject element) {
        IGraphicalEditPart dummyEP;
        if ((element = this.resolveElement(element)) == null) {
            return "<Undefined>";
        }
        if (element instanceof org.eclipse.uml2.uml.Image) {
            org.eclipse.uml2.uml.Image image = (org.eclipse.uml2.uml.Image)element;
            String imageName = ImageUtil.getName((org.eclipse.uml2.uml.Image)image);
            String location = image.getLocation();
            if (this.isEmptyString(imageName)) {
                if (this.isEmptyString(location)) {
                    return "Image";
                }
                return location;
            }
            if (this.isEmptyString(location)) {
                return imageName;
            }
            return String.valueOf(imageName) + " : " + location;
        }
        if (element instanceof PackageImport) {
            Package importedPackage = ((PackageImport)element).getImportedPackage();
            if (importedPackage == null) {
                return "<Package Import>";
            }
            return "<Package Import> " + importedPackage.getName();
        }
        if (element instanceof ElementImport) {
            PackageableElement importedElement = ((ElementImport)element).getImportedElement();
            if (importedElement == null) {
                return "<Element Import>";
            }
            return "<Element Import> " + importedElement.getName();
        }
        if (element instanceof NamedElement) {
            if (element instanceof ValueSpecification) {
                String value = null;
                if (element instanceof InstanceValue) {
                    InstanceSpecification specification = ((InstanceValue)element).getInstance();
                    if (specification != null) {
                        value = this.getText((EObject)specification);
                    }
                } else {
                    value = element instanceof LiteralString ? "\"" + ((ValueSpecification)element).stringValue() + "\"" : (element instanceof LiteralNull ? "null" : ((ValueSpecification)element).stringValue());
                }
                if (value != null) {
                    if (((NamedElement)element).isSetName()) {
                        return String.valueOf(((NamedElement)element).getName()) + "=" + value;
                    }
                    return value;
                }
                if (((NamedElement)element).isSetName()) {
                    return ((NamedElement)element).getName();
                }
                return "";
            }
            return ((NamedElement)element).getName();
        }
        if (element instanceof TemplateParameter) {
            TemplateParameter templateParam = (TemplateParameter)element;
            if (templateParam.getParameteredElement() == null) {
                return "<UNDEFINED>";
            }
            String out = "";
            if (templateParam.getParameteredElement() instanceof NamedElement) {
                NamedElement namedElement = (NamedElement)templateParam.getParameteredElement();
                out = String.valueOf(namedElement.getName()) + ": " + namedElement.eClass().getName();
            }
            if (templateParam instanceof OperationTemplateParameter) {
                if (templateParam.getParameteredElement() != null) {
                    Operation op = (Operation)templateParam.getParameteredElement();
                    out = this.displayOperation(op);
                }
            } else if (templateParam instanceof ClassifierTemplateParameter && !((ClassifierTemplateParameter)templateParam).getConstrainingClassifiers().isEmpty()) {
                out = String.valueOf(out) + ">";
                int i = 0;
                while (i < ((ClassifierTemplateParameter)templateParam).getConstrainingClassifiers().size()) {
                    out = String.valueOf(out) + ((Classifier)((ClassifierTemplateParameter)templateParam).getConstrainingClassifiers().get(i)).getName();
                    if (i < ((ClassifierTemplateParameter)templateParam).getConstrainingClassifiers().size() - 1) {
                        out = String.valueOf(out) + ", ";
                    }
                    ++i;
                }
            }
            if (templateParam.getDefault() instanceof Operation) {
                out = String.valueOf(out) + "=" + this.displayOperation((Operation)templateParam.getDefault());
            } else if (templateParam.getDefault() instanceof NamedElement) {
                out = String.valueOf(out) + "=" + ((NamedElement)templateParam.getDefault()).getName();
            }
            return out;
        }
        if (element instanceof TemplateParameterSubstitution) {
            String out = "";
            TemplateParameterSubstitution substitution = (TemplateParameterSubstitution)element;
            if (substitution.getFormal() != null && substitution.getFormal().getParameteredElement() instanceof NamedElement) {
                out = String.valueOf(out) + ((NamedElement)substitution.getFormal().getParameteredElement()).getName();
            }
            if (substitution.getActual() instanceof NamedElement) {
                out = String.valueOf(out) + " -> " + ((NamedElement)substitution.getActual()).getName() + "\n";
            }
            return out;
        }
        if (element instanceof Element) {
            String className = element.eClass().getName();
            return className;
        }
        if (element instanceof Diagram) {
            return ((Diagram)element).getName();
        }
        if (element instanceof View && (dummyEP = EditPartService.getInstance().createGraphicEditPart((View)element)) instanceof ResizableCompartmentEditPart) {
            return ((ResizableCompartmentEditPart)dummyEP).getCompartmentName();
        }
        return super.getText(element);
    }

    private boolean isEmptyString(String s) {
        return s == null || s.trim().equals("");
    }

    protected String displayOperation(Operation op) {
        String out = String.valueOf(op.getName()) + "(";
        for (Parameter param : op.getOwnedParameters()) {
            out = String.valueOf(out) + param.getName();
            if (param.equals(op.getOwnedParameters().get(op.getOwnedParameters().size() - 1))) continue;
            out = String.valueOf(out) + ", ";
        }
        out = String.valueOf(out) + ")";
        return out;
    }
}

