/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.views.modelexplorer.core.ui.pagebookview;

import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.papyrus.infra.services.decoration.util.IPapyrusDecoration;
import org.eclipse.papyrus.views.modelexplorer.Activator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelExplorerDecorationAdapter {
    protected Image decoratorTarget;
    protected EList<IPapyrusDecoration> decorations;
    protected int decorationPosition;
    private final Point size16 = new Point(16, 16);

    public ModelExplorerDecorationAdapter(Image baseImage) {
        this.decoratorTarget = baseImage;
    }

    public Image getDecoratorTarget() {
        return this.decoratorTarget;
    }

    public void setDecorations(EList<IPapyrusDecoration> decorations) {
        this.decorations = decorations;
    }

    public void setDecoratorTarget(Image decoratorTarget) {
        this.decoratorTarget = decoratorTarget;
    }

    public void setDecorationPosition(int decorationPosition) {
        this.decorationPosition = decorationPosition;
    }

    public Image getDecoratedImage() {
        if (this.decorations == null) {
            return this.decoratorTarget;
        }
        Image decoratedImage = null;
        String decoratedImageId = this.calcId();
        decoratedImage = Activator.getDefault().getImageRegistry().get(decoratedImageId);
        if (decoratedImage == null) {
            ImageDescriptor[] decorationImages = new ImageDescriptor[5];
            for (IPapyrusDecoration decoration : this.decorations) {
                decorationImages[decoration.getPositionForJFace()] = decoration.getDecorationImageForME();
            }
            DecorationOverlayIcon decoratedImageDesc = new DecorationOverlayIcon(this.decoratorTarget, decorationImages, this.size16);
            Activator.getDefault().getImageRegistry().put(decoratedImageId, (ImageDescriptor)decoratedImageDesc);
            return Activator.getDefault().getImageRegistry().get(decoratedImageId);
        }
        return decoratedImage;
    }

    public String calcId() {
        String decoratedImageId = this.decoratorTarget.toString();
        for (IPapyrusDecoration decoration : this.decorations) {
            decoratedImageId = String.valueOf(decoratedImageId) + decoration.getDecorationImageForME().toString() + decoration.getPosition();
        }
        return decoratedImageId;
    }
}

