/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.views.modelexplorer.handler;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.utils.BusinessModelResolver;
import org.eclipse.papyrus.infra.core.utils.ServiceUtilsForActionHandlers;
import org.eclipse.papyrus.views.modelexplorer.Activator;
import org.eclipse.papyrus.views.modelexplorer.handler.AbstractModelExplorerHandler;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCommandHandler
extends AbstractModelExplorerHandler {
    protected abstract Command getCommand();

    protected EObject getSelectedElement() {
        Object selection;
        EObject eObject = null;
        IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        ISelection iSelection = selection = activeWorkbenchWindow != null ? activeWorkbenchWindow.getSelectionService().getSelection() : null;
        if (selection != null) {
            Object businessObject;
            if (selection instanceof IStructuredSelection) {
                IStructuredSelection structuredSelection = (IStructuredSelection)selection;
                selection = structuredSelection.getFirstElement();
            }
            if (selection instanceof IAdaptable) {
                selection = ((IAdaptable)selection).getAdapter(EObject.class);
            }
            if ((businessObject = BusinessModelResolver.getInstance().getBusinessModel(selection)) instanceof EObject) {
                eObject = (EObject)businessObject;
            }
        }
        return eObject;
    }

    protected List<EObject> getSelectedElements() {
        ISelection selection;
        ArrayList<EObject> selectedEObjects = new ArrayList<EObject>();
        IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        ISelection iSelection = selection = activeWorkbenchWindow != null ? activeWorkbenchWindow.getSelectionService().getSelection() : null;
        if (selection != null) {
            if (selection instanceof IStructuredSelection) {
                IStructuredSelection structuredSelection = (IStructuredSelection)selection;
                Object[] objectArray = structuredSelection.toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    EObject selectedElement;
                    Object current = objectArray[n2];
                    if (current instanceof IAdaptable && (selectedElement = (EObject)((IAdaptable)current).getAdapter(EObject.class)) != null) {
                        selectedEObjects.add(selectedElement);
                    }
                    ++n2;
                }
            } else {
                EObject selectedElement = null;
                if (selection instanceof IAdaptable) {
                    selectedElement = (EObject)((IAdaptable)selection).getAdapter(EObject.class);
                }
                if (selectedElement == null) {
                    selectedElement = (EObject)Platform.getAdapterManager().getAdapter((Object)selection, EObject.class);
                }
                if (selectedElement != null) {
                    selectedEObjects.add(selectedElement);
                }
            }
        }
        return selectedEObjects;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        try {
            ServiceUtilsForActionHandlers.getInstance().getTransactionalEditingDomain().getCommandStack().execute(this.getCommand());
        }
        catch (ServiceException e) {
            Activator.log.error("Unexpected error while executing command.", (Throwable)e);
        }
        return null;
    }

    public boolean isEnabled() {
        Command command = this.getCommand();
        return command != null && this.getCommand().canExecute();
    }
}

