/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.views.modelexplorer.provider;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.IPageMngr;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.utils.ServiceUtilsForActionHandlers;
import org.eclipse.papyrus.views.modelexplorer.ModelExplorerPageBookView;
import org.eclipse.ui.IWorkbenchPart;

public class PropertyTester
extends org.eclipse.core.expressions.PropertyTester {
    public static final String IS_EOBJECT = "isEObject";
    public static final String IS_MODEL_EXPLORER = "isModelExplorer";
    public static final String IS_PAGE = "isPage";

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        if (IS_EOBJECT.equals(property) && receiver instanceof IStructuredSelection) {
            boolean answer = this.isObject((IStructuredSelection)receiver);
            return new Boolean(answer).equals(expectedValue);
        }
        if (IS_MODEL_EXPLORER.equals(property) && receiver instanceof IWorkbenchPart) {
            boolean answer = this.isModelExplorer((IWorkbenchPart)receiver);
            return new Boolean(answer).equals(expectedValue);
        }
        if (IS_PAGE.equals(property) && receiver instanceof IStructuredSelection) {
            boolean answer = this.isPage((IStructuredSelection)receiver);
            return new Boolean(answer).equals(expectedValue);
        }
        return false;
    }

    private boolean isPage(IStructuredSelection selection) {
        IPageMngr pageMngr = this.getPageManager();
        if (pageMngr != null && !selection.isEmpty()) {
            for (Object current : selection) {
                if (current instanceof IAdaptable) {
                    EObject eObject = (EObject)((IAdaptable)current).getAdapter(EObject.class);
                    if (pageMngr.allPages().contains(eObject)) continue;
                    return false;
                }
                if (pageMngr.allPages().contains(current)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    protected IPageMngr getPageManager() {
        IPageMngr pageMngr = null;
        try {
            ServiceUtilsForActionHandlers instance = ServiceUtilsForActionHandlers.getInstance();
            if (instance != null) {
                pageMngr = instance.getIPageMngr();
            }
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (ServiceException serviceException) {
            // empty catch block
        }
        return pageMngr;
    }

    private boolean isModelExplorer(IWorkbenchPart receiver) {
        return receiver instanceof ModelExplorerPageBookView;
    }

    private boolean isObject(IStructuredSelection selection) {
        if (!selection.isEmpty()) {
            for (Object current : selection) {
                if (current instanceof IAdaptable) {
                    EObject eObject = (EObject)((IAdaptable)current).getAdapter(EObject.class);
                    if (eObject != null) continue;
                    return false;
                }
                return false;
            }
            return true;
        }
        return false;
    }
}

