/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.views.properties.preferences;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.papyrus.views.properties.contexts.Context;
import org.eclipse.papyrus.views.properties.messages.Messages;
import org.eclipse.papyrus.views.properties.runtime.ConfigurationConflict;
import org.eclipse.papyrus.views.properties.runtime.ConfigurationManager;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class Preferences
extends PreferencePage
implements IWorkbenchPreferencePage {
    private boolean changeOccured = false;
    private final ContextState contextState = new ContextState();
    private Map<Context, Button> checkboxes = new HashMap<Context, Button>();

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        Composite self = new Composite(parent, 0);
        self.setLayout((Layout)new GridLayout(1, false));
        self.setLayoutData((Object)new GridData(4, 4, true, true));
        Label label = new Label(self, 0);
        label.setText(Messages.Preferences_Contexts);
        ConfigurationManager configurationManager = ConfigurationManager.instance;
        this.contextState.init();
        for (Context context : configurationManager.getCustomizableContexts()) {
            boolean applied = configurationManager.isApplied(context);
            Button checkbox = new Button(self, 32);
            checkbox.setText(this.getLabel(context));
            checkbox.setSelection(applied);
            final Context theContext = context;
            this.contextState.setContextState(theContext, applied);
            checkbox.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    Preferences.this.contextState.setContextState(theContext, ((Button)e.widget).getSelection());
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            this.checkboxes.put(context, checkbox);
        }
        this.changeOccured = false;
        return null;
    }

    public boolean performOk() {
        return this.contextState.saveContext() && super.performOk();
    }

    public void performApply() {
        this.contextState.saveContext();
    }

    public void performDefaults() {
        for (Context context : ConfigurationManager.instance.getContexts()) {
            boolean applied = ConfigurationManager.instance.isPlugin(context);
            Button checkbox = this.checkboxes.get(context);
            if (checkbox != null) {
                checkbox.setSelection(applied);
            }
            this.contextState.setContextState(context, applied);
        }
    }

    private String getLabel(Context context) {
        return String.valueOf(context.getName()) + " (" + (ConfigurationManager.instance.isPlugin(context) ? Messages.Preferences_Plugin : Messages.Preferences_Custom) + ")";
    }

    private class ContextState {
        private Map<Context, Boolean> contexts = new HashMap<Context, Boolean>();

        public void init() {
            this.contexts.clear();
        }

        public void setContextState(Context context, boolean applied) {
            this.contexts.put(context, applied);
            Preferences.this.changeOccured = true;
        }

        public boolean saveContext() {
            for (Map.Entry<Context, Boolean> entry : this.contexts.entrySet()) {
                if (entry.getValue().booleanValue()) {
                    ConfigurationManager.instance.enableContext(entry.getKey(), false);
                    continue;
                }
                ConfigurationManager.instance.disableContext(entry.getKey(), false);
            }
            ConfigurationManager.instance.update();
            Collection<ConfigurationConflict> conflicts = ConfigurationManager.instance.checkConflicts();
            if (Preferences.this.changeOccured && !conflicts.isEmpty()) {
                String errorMessage = Messages.Preferences_ConflictWarning1;
                for (ConfigurationConflict conflict : conflicts) {
                    errorMessage = String.valueOf(errorMessage) + conflict.toString() + "\n";
                }
                errorMessage = String.valueOf(errorMessage) + Messages.Preferences_ConflictWarning2;
                MessageDialog dialog = new MessageDialog(Preferences.this.getShell(), Messages.Preferences_ConflictWarningTitle, null, errorMessage, 4, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL}, 1);
                int result = dialog.open();
                if (result != 0) {
                    return false;
                }
            }
            Preferences.this.changeOccured = false;
            return true;
        }
    }
}

