/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.views.properties.providers;

import java.util.Collection;
import java.util.TreeMap;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.papyrus.infra.widgets.providers.ExtensibleLabelProvider;
import org.eclipse.papyrus.infra.widgets.providers.IFilteredLabelProvider;
import org.eclipse.papyrus.views.properties.Activator;

public class SelectionLabelProvider
extends ExtensibleLabelProvider {
    public static final String EXTENSION_ID = "org.eclipse.papyrus.views.properties.labelprovider";
    public static final String LABEL_PROVIDER_PROPERTY = "labelProvider";
    public static final String PRIORITY_PROPERTY = "priority";
    protected final TreeMap<Integer, Collection<IFilteredLabelProvider>> labelProviders = new TreeMap();

    public SelectionLabelProvider() {
        this.readExtensionPoint();
    }

    protected void readExtensionPoint() {
        IConfigurationElement[] config;
        IConfigurationElement[] iConfigurationElementArray = config = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_ID);
        int n = config.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement e = iConfigurationElementArray[n2];
            try {
                IFilteredLabelProvider provider = (IFilteredLabelProvider)e.createExecutableExtension(LABEL_PROVIDER_PROPERTY);
                int priority = Integer.parseInt(e.getAttribute(PRIORITY_PROPERTY));
                this.registerProvider(priority, provider);
            }
            catch (Exception ex) {
                Activator.log.error("Cannot load the label provider : " + e.getAttribute(LABEL_PROVIDER_PROPERTY), (Throwable)ex);
            }
            ++n2;
        }
    }
}

