/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.feature;

import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.core.util.IdUtil;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.dialogs.FeatureSelectionDialog;
import org.eclipse.pde.internal.ui.util.SWTUtil;
import org.eclipse.pde.internal.ui.wizards.BundleProviderHistoryUtil;
import org.eclipse.pde.internal.ui.wizards.feature.AbstractFeatureSpecPage;
import org.eclipse.pde.internal.ui.wizards.feature.FeatureData;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class PatchSpecPage
extends AbstractFeatureSpecPage {
    private Combo fPatchProviderCombo;
    private Button fBrowseButton;
    private Text fPatchIdText;
    private Text fPatchNameText;
    private Text fFeatureIdText;

    public PatchSpecPage() {
        this.setTitle(PDEUIMessages.PatchSpec_title);
        this.setDescription(PDEUIMessages.NewFeatureWizard_SpecPage_desc);
    }

    protected void initialize() {
        String projectName = this.getProjectName();
        if (this.fInitialId == null) {
            this.fPatchIdText.setText(IdUtil.getValidId((String)projectName));
        }
        if (this.fInitialName == null) {
            this.fPatchNameText.setText(projectName);
        }
        this.setMessage(PDEUIMessages.FeaturePatch_MainPage_desc);
    }

    protected String validateContent() {
        this.fFeatureToPatch = PDECore.getDefault().getFeatureModelManager().findFeatureModel(this.fFeatureIdText.getText(), this.fFeatureVersionText.getText());
        if (this.fFeatureToPatch != null) {
            this.setMessage(null);
            return null;
        }
        this.setMessage(NLS.bind((String)PDEUIMessages.NewFeaturePatch_SpecPage_notFound, (Object)this.fFeatureIdText.getText(), (Object)this.fFeatureVersionText.getText()), 2);
        this.getContainer().updateButtons();
        return null;
    }

    public IWizardPage getNextPage() {
        if (this.fFeatureToPatch == null) {
            return null;
        }
        return super.getNextPage();
    }

    private String getPatchId() {
        if (this.fPatchIdText == null) {
            return "";
        }
        return this.fPatchIdText.getText();
    }

    private String getPatchName() {
        if (this.fPatchNameText == null) {
            return "";
        }
        return this.fPatchNameText.getText();
    }

    private String getPatchProvider() {
        if (this.fPatchProviderCombo == null) {
            return "";
        }
        return this.fPatchProviderCombo.getText();
    }

    public FeatureData getFeatureData() {
        FeatureData data = new FeatureData();
        data.id = this.getPatchId();
        data.version = "1.0.0";
        data.provider = this.getPatchProvider();
        data.name = this.getPatchName();
        data.library = this.getInstallHandlerLibrary();
        data.isPatch = true;
        data.featureToPatchId = this.fFeatureIdText.getText();
        data.featureToPatchVersion = this.fFeatureVersionText.getText();
        return data;
    }

    protected String verifyIdRules() {
        String id = this.fPatchIdText.getText();
        if (id == null || id.length() == 0) {
            return PDEUIMessages.NewFeatureWizard_SpecPage_pmissing;
        }
        if (!IdUtil.isValidCompositeID((String)id)) {
            return PDEUIMessages.NewFeatureWizard_SpecPage_invalidId;
        }
        return super.verifyIdRules();
    }

    protected String getHelpId() {
        return "org.eclipse.pde.doc.user.new_patch_data";
    }

    protected void createTopGroup(Composite container) {
        Group patchGroup = new Group(container, 0);
        patchGroup.setLayout((Layout)new GridLayout(2, false));
        GridData gd = new GridData(768);
        gd.verticalIndent = 10;
        patchGroup.setLayoutData((Object)gd);
        patchGroup.setText(PDEUIMessages.NewFeatureWizard_SpecPage_patchProperties);
        Label label = new Label((Composite)patchGroup, 0);
        label.setText(PDEUIMessages.NewFeaturePatch_SpecPage_id);
        this.fPatchIdText = new Text((Composite)patchGroup, 2048);
        this.fPatchIdText.setLayoutData((Object)new GridData(768));
        label = new Label((Composite)patchGroup, 0);
        label.setText(PDEUIMessages.NewFeaturePatch_SpecPage_name);
        this.fPatchNameText = new Text((Composite)patchGroup, 2048);
        this.fPatchNameText.setLayoutData((Object)new GridData(768));
        label = new Label((Composite)patchGroup, 0);
        label.setText(PDEUIMessages.NewFeaturePatch_SpecPage_provider);
        this.fPatchProviderCombo = new Combo((Composite)patchGroup, 2052);
        this.fPatchProviderCombo.setLayoutData((Object)new GridData(768));
        BundleProviderHistoryUtil.loadHistory(this.fPatchProviderCombo, this.getDialogSettings());
        this.createInstallHandlerText((Composite)patchGroup);
    }

    protected void createContents(Composite container) {
        this.createTopGroup(container);
        Group group = new Group(container, 0);
        group.setLayout((Layout)new GridLayout(2, false));
        GridData gd = new GridData(768);
        gd.verticalIndent = 10;
        group.setLayoutData((Object)gd);
        group.setText(PDEUIMessages.BaseFeatureSpecPage_patchGroup_title);
        Label label = new Label((Composite)group, 0);
        label.setText(PDEUIMessages.NewFeatureWizard_SpecPage_id);
        Composite patchcontainer = new Composite((Composite)group, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 5;
        patchcontainer.setLayout((Layout)layout);
        patchcontainer.setLayoutData((Object)new GridData(768));
        this.fFeatureIdText = new Text(patchcontainer, 2048);
        this.fFeatureIdText.setLayoutData((Object)new GridData(768));
        this.fBrowseButton = new Button(patchcontainer, 8);
        this.fBrowseButton.setText(PDEUIMessages.BaseFeatureSpecPage_browse);
        this.fBrowseButton.setLayoutData((Object)new GridData(128));
        this.fBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FeatureSelectionDialog dialog = new FeatureSelectionDialog(PatchSpecPage.this.getShell(), PDECore.getDefault().getFeatureModelManager().getModels(), false);
                dialog.create();
                if (dialog.open() == 0) {
                    Object[] result = dialog.getResult();
                    IFeatureModel selectedModel = (IFeatureModel)result[0];
                    PatchSpecPage.this.fSelfModification = true;
                    PatchSpecPage.this.fFeatureIdText.setText(selectedModel.getFeature().getId());
                    PatchSpecPage.this.fFeatureNameText.setText(selectedModel.getFeature().getLabel());
                    PatchSpecPage.this.fSelfModification = false;
                    PatchSpecPage.this.fFeatureVersionText.setText(selectedModel.getFeature().getVersion());
                    PatchSpecPage.this.fFeatureToPatch = selectedModel;
                }
            }
        });
        SWTUtil.setButtonDimensionHint(this.fBrowseButton);
        this.createCommonInput((Composite)group);
    }

    protected void attachListeners(ModifyListener listener) {
        this.fPatchIdText.addModifyListener(listener);
        this.fPatchNameText.addModifyListener(listener);
        this.fPatchProviderCombo.addModifyListener(listener);
        this.fFeatureIdText.addModifyListener(listener);
    }

    protected String getFeatureId() {
        return this.fFeatureIdText.getText();
    }

    protected void updateNameRelativeFields() {
        if (this.fPatchIdText == null || this.fPatchNameText == null) {
            return;
        }
        this.fSelfModification = true;
        String id = IdUtil.getValidId((String)this.getProjectName());
        this.fPatchIdText.setText(id);
        this.fPatchNameText.setText(IdUtil.getValidName((String)id));
        if (this.fPatchProviderCombo.getText().length() == 0) {
            this.fPatchProviderCombo.setText(IdUtil.getValidProvider((String)id));
        }
        this.fSelfModification = false;
    }

    protected void saveSettings(IDialogSettings settings) {
        BundleProviderHistoryUtil.saveHistory(this.fPatchProviderCombo, settings);
    }
}

