/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jaxb.dynamic;

import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.bind.JAXBException;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.dynamic.DynamicClassLoader;
import org.eclipse.persistence.dynamic.DynamicEntity;
import org.eclipse.persistence.dynamic.DynamicHelper;
import org.eclipse.persistence.dynamic.DynamicType;
import org.eclipse.persistence.dynamic.DynamicTypeBuilder;
import org.eclipse.persistence.internal.descriptors.InstantiationPolicy;
import org.eclipse.persistence.internal.jaxb.JaxbClassLoader;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.jaxb.JAXBContext;
import org.eclipse.persistence.jaxb.compiler.Generator;
import org.eclipse.persistence.jaxb.dynamic.metadata.Metadata;
import org.eclipse.persistence.jaxb.dynamic.metadata.OXMMetadata;
import org.eclipse.persistence.oxm.XMLContext;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.sessions.factories.SessionManager;
import org.eclipse.persistence.sessions.factories.XMLSessionConfigLoader;
import org.w3c.dom.Node;
import org.xml.sax.EntityResolver;

public class DynamicJAXBContext
extends JAXBContext {
    DynamicJAXBContext(JAXBContext.JAXBContextInput input) throws JAXBException {
        super(input);
    }

    public DynamicClassLoader getDynamicClassLoader() {
        return ((DynamicJAXBContextInput)this.contextInput).getClassLoader();
    }

    private ArrayList<DynamicHelper> getHelpers() {
        return ((DynamicJAXBContextState)this.contextState).getHelpers();
    }

    public DynamicType getDynamicType(String javaName) {
        for (DynamicHelper helper : this.getHelpers()) {
            DynamicType type = helper.getType(javaName);
            if (type == null) continue;
            return type;
        }
        return null;
    }

    public DynamicEntity newDynamicEntity(String javaName) throws IllegalArgumentException {
        IllegalArgumentException ex = null;
        for (DynamicHelper helper : this.getHelpers()) {
            try {
                return helper.newDynamicEntity(javaName);
            }
            catch (IllegalArgumentException e) {
                ex = e;
            }
        }
        throw ex;
    }

    public DynamicEntity newDynamicEntity(DynamicType dynamicType) {
        return dynamicType.newDynamicEntity();
    }

    public Object getEnumConstant(String enumName, String constantName) throws ClassNotFoundException, JAXBException {
        T[] enumConstants;
        Object valueToReturn = null;
        Class enumClass = this.getDynamicClassLoader().loadClass(enumName);
        T[] TArray = enumConstants = enumClass.getEnumConstants();
        int n = enumConstants.length;
        int n2 = 0;
        while (n2 < n) {
            Object enumConstant = TArray[n2];
            if (enumConstant.toString().equals(constantName)) {
                valueToReturn = enumConstant;
            }
            ++n2;
        }
        if (valueToReturn != null) {
            return valueToReturn;
        }
        throw new JAXBException((Throwable)org.eclipse.persistence.exceptions.JAXBException.enumConstantNotFound((String)(String.valueOf(enumName) + "." + constantName)));
    }

    static abstract class DynamicJAXBContextInput
    extends JAXBContext.JAXBContextInput {
        public DynamicJAXBContextInput(Map properties, ClassLoader classLoader) {
            super(properties, classLoader);
            DynamicClassLoader dClassLoader = null;
            if (classLoader == null) {
                classLoader = Thread.currentThread().getContextClassLoader();
            }
            if (classLoader instanceof DynamicClassLoader) {
                dClassLoader = (DynamicClassLoader)classLoader;
            } else {
                JaxbClassLoader jaxbLoader = new JaxbClassLoader(classLoader);
                dClassLoader = new DynamicClassLoader((ClassLoader)jaxbLoader);
            }
            this.classLoader = dClassLoader;
        }

        public DynamicClassLoader getClassLoader() {
            return (DynamicClassLoader)this.classLoader;
        }
    }

    static class DynamicJAXBContextState
    extends JAXBContext.JAXBContextState {
        private ArrayList<DynamicHelper> helpers;
        private DynamicClassLoader dClassLoader;

        public DynamicJAXBContextState(DynamicClassLoader loader) {
            this.helpers = new ArrayList();
        }

        public DynamicJAXBContextState(XMLContext ctx) {
            super(ctx);
        }

        public ArrayList<DynamicHelper> getHelpers() {
            return this.helpers;
        }

        public void setHelpers(ArrayList<DynamicHelper> helpers) {
            this.helpers = helpers;
        }

        public DynamicClassLoader getDynamicClassLoader() {
            return this.dClassLoader;
        }

        public void setDynamicClassLoader(DynamicClassLoader dClassLoader) {
            this.dClassLoader = dClassLoader;
        }
    }

    static class MetadataContextInput
    extends DynamicJAXBContextInput {
        public MetadataContextInput(Map properties, ClassLoader classLoader) {
            super(properties, classLoader);
        }

        @Override
        protected JAXBContext.JAXBContextState createContextState() throws JAXBException {
            DynamicJAXBContextState state = new DynamicJAXBContextState((DynamicClassLoader)this.classLoader);
            OXMMetadata oxmMetadata = new OXMMetadata((DynamicClassLoader)this.classLoader, this.properties);
            Generator g = new Generator(((Metadata)oxmMetadata).getJavaModelInput(), oxmMetadata.getBindings(), this.classLoader, null);
            Project p = null;
            Project dp = null;
            try {
                p = g.generateProject();
                List descriptors = p.getOrderedDescriptors();
                for (ClassDescriptor classDescriptor : descriptors) {
                    try {
                        if (classDescriptor.getJavaClass() != null) continue;
                        classDescriptor.setJavaClass(this.classLoader.getParent().loadClass(classDescriptor.getJavaClassName()));
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        classDescriptor.setInstantiationPolicy(new InstantiationPolicy());
                    }
                }
                dp = DynamicTypeBuilder.loadDynamicProject((Project)p, null, (DynamicClassLoader)((DynamicClassLoader)this.classLoader));
            }
            catch (Exception e) {
                throw new JAXBException((Throwable)org.eclipse.persistence.exceptions.JAXBException.errorCreatingDynamicJAXBContext((Exception)e));
            }
            XMLContext ctx = new XMLContext(dp, this.classLoader, this.sessionEventListeners());
            state.setXMLContext(ctx);
            List sessions = ctx.getSessions();
            for (Object session : sessions) {
                state.getHelpers().add(new DynamicHelper((DatabaseSession)session));
            }
            return state;
        }
    }

    static class SchemaContextInput
    extends DynamicJAXBContextInput {
        private Object schema = null;
        private EntityResolver entityResolver;
        public static final String SCHEMAMETADATA_CLASS_NAME = "org.eclipse.persistence.jaxb.dynamic.metadata.SchemaMetadata";

        public SchemaContextInput(Object schema, EntityResolver resolver, Map properties, ClassLoader classLoader) {
            super(properties, classLoader);
            this.schema = schema;
            this.entityResolver = resolver;
        }

        @Override
        protected JAXBContext.JAXBContextState createContextState() throws JAXBException {
            DynamicJAXBContextState state = new DynamicJAXBContextState((DynamicClassLoader)this.classLoader);
            Metadata schemaMetadata = null;
            Object constructorArg = this.schema instanceof Node ? this.schema : (this.schema instanceof InputStream ? new StreamSource((InputStream)this.schema) : (Source)this.schema);
            try {
                Class schemaMetadataClass = PrivilegedAccessHelper.getClassForName((String)SCHEMAMETADATA_CLASS_NAME);
                Class[] constructorClassArgs = new Class[]{DynamicClassLoader.class, Map.class, constructorArg.getClass(), EntityResolver.class};
                Constructor constructor = PrivilegedAccessHelper.getConstructorFor((Class)schemaMetadataClass, (Class[])constructorClassArgs, (boolean)true);
                Object[] contructorObjectArgs = new Object[]{(DynamicClassLoader)this.classLoader, this.properties, constructorArg, this.entityResolver};
                schemaMetadata = (Metadata)PrivilegedAccessHelper.invokeConstructor((Constructor)constructor, (Object[])contructorObjectArgs);
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                if (cause instanceof JAXBException) {
                    throw (JAXBException)cause;
                }
                if (cause instanceof org.eclipse.persistence.exceptions.JAXBException) {
                    throw (org.eclipse.persistence.exceptions.JAXBException)cause;
                }
                throw new JAXBException((Throwable)e);
            }
            catch (org.eclipse.persistence.exceptions.JAXBException e) {
                throw e;
            }
            catch (Exception e) {
                throw new JAXBException((Throwable)e);
            }
            Generator g = new Generator(schemaMetadata.getJavaModelInput(), schemaMetadata.getBindings(), this.classLoader, null);
            Project p = null;
            Project dp = null;
            try {
                p = g.generateProject();
                List descriptors = p.getOrderedDescriptors();
                for (ClassDescriptor classDescriptor : descriptors) {
                    classDescriptor.setInstantiationPolicy(new InstantiationPolicy());
                }
                dp = DynamicTypeBuilder.loadDynamicProject((Project)p, null, (DynamicClassLoader)((DynamicClassLoader)this.classLoader));
            }
            catch (Exception e) {
                throw new JAXBException((Throwable)org.eclipse.persistence.exceptions.JAXBException.errorCreatingDynamicJAXBContext((Exception)e));
            }
            XMLContext ctx = new XMLContext(dp, (ClassLoader)((DynamicClassLoader)this.classLoader), this.sessionEventListeners());
            state.setXMLContext(ctx);
            List sessions = ctx.getSessions();
            for (Object session : sessions) {
                state.getHelpers().add(new DynamicHelper((DatabaseSession)session));
            }
            return state;
        }
    }

    static class SessionsXmlContextInput
    extends DynamicJAXBContextInput {
        private String sessions;

        public SessionsXmlContextInput(String sessionNames, Map properties, ClassLoader classLoader) {
            super(properties, classLoader);
            this.sessions = sessionNames;
        }

        @Override
        protected JAXBContext.JAXBContextState createContextState() throws JAXBException {
            DynamicJAXBContextState state = new DynamicJAXBContextState((DynamicClassLoader)this.classLoader);
            StringTokenizer st = new StringTokenizer(this.sessions, ":");
            ArrayList<Project> dynamicProjects = new ArrayList<Project>(st.countTokens());
            XMLSessionConfigLoader loader = new XMLSessionConfigLoader();
            while (st.hasMoreTokens()) {
                DatabaseSession dbSession = (DatabaseSession)SessionManager.getManager().getSession(loader, st.nextToken(), this.classLoader, false, true);
                Project p = DynamicTypeBuilder.loadDynamicProject((Project)dbSession.getProject(), null, (DynamicClassLoader)((DynamicClassLoader)this.classLoader));
                dynamicProjects.add(p);
            }
            XMLContext xmlContext = new XMLContext(dynamicProjects);
            state.setXMLContext(xmlContext);
            List sessions = xmlContext.getSessions();
            for (Object session : sessions) {
                state.getHelpers().add(new DynamicHelper((DatabaseSession)session));
            }
            return state;
        }
    }
}

