/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.oracleddl.test.ddlparser;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import org.eclipse.persistence.tools.oracleddl.metadata.ArgumentType;
import org.eclipse.persistence.tools.oracleddl.metadata.ArgumentTypeDirection;
import org.eclipse.persistence.tools.oracleddl.metadata.DatabaseType;
import org.eclipse.persistence.tools.oracleddl.metadata.NumericType;
import org.eclipse.persistence.tools.oracleddl.metadata.ProcedureType;
import org.eclipse.persistence.tools.oracleddl.metadata.ScalarDatabaseTypeEnum;
import org.eclipse.persistence.tools.oracleddl.metadata.VarChar2Type;
import org.eclipse.persistence.tools.oracleddl.metadata.visit.UnresolvedTypesVisitor;
import org.eclipse.persistence.tools.oracleddl.parser.DDLParser;
import org.eclipse.persistence.tools.oracleddl.parser.ParseException;
import org.eclipse.persistence.tools.oracleddl.util.DatabaseTypesRepository;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class ProcedureDDLTestSuite {
    static final String CREATE_PROCEDURE_PREFIX = "CREATE PROCEDURE ";
    static DDLParser parser = null;
    static final String EMPTY_PROCEDURE = "EMPTY_PROCEDURE";
    static final String CREATE_EMPTY_PROCEDURE = "CREATE PROCEDURE EMPTY_PROCEDURE IS BEGIN null; END";
    static final String DUMMY_PROCEDURE = "DUMMY_PROCEDURE";
    static final String DUMMY_ARG = "DUM";
    static final String CREATE_DUMMY_PROCEDURE = "CREATE PROCEDURE DUMMY_PROCEDURE (DUM IN VARCHAR2) AS BEGIN null;END";
    static final String DUMMY_PROCEDURE_SCHEMA = "SCOTT";
    static final String CREATE_DUMMY_PROCEDURE_SCHEMA = "CREATE PROCEDURE SCOTT.DUMMY_PROCEDURE (DUM IN VARCHAR2) AS BEGIN null;END";
    static final String PROCEDURE_W_IN_OUT_ARGS = "INOUTARGSSP";
    static final String IN_ARG = "T";
    static final String OUT_ARG = "U";
    static final String OUT_ARG2 = "V";
    static final String CREATE_PROCEDURE_W_IN_OUT_ARGS = "CREATE PROCEDURE INOUTARGSSP ( T IN VARCHAR2, U OUT VARCHAR2, V OUT NUMERIC) AS BEGIN null;END";
    static final String PROCEDURE_W_SYS_REFCURSOR = "GETALL";
    static final String SYS_REF_OUT_ARG = "SIMPL";
    static final String CREATE_PROCEDURE_W_SYS_REFCURSOR = "CREATE PROCEDURE GETALL ( SIMPL OUT SYS_REFCURSOR) AS BEGIN OPEN SIMPL FOR SELECT * FROM simplesp;END";
    static final String PROCEDURE_W_INOUT_ARG = "INOUTARGSP";
    static final String INOUT_ARG = "X";
    static final String CREATE_PROCEDURE_W_INOUT_ARG = "CREATE PROCEDURE INOUTARGSP ( X IN OUT NUMERIC) AS BEGIN null;END";
    static final String PROCEDURE_W_KEYWORDS = "KEYWORDSP";
    static final String IN_ARG1 = "OPERATOR";
    static final String IN_ARG2 = "TIMESTAMP";
    static final String CREATE_PROCEDURE_W_KEYWORDS = "CREATE PROCEDURE KEYWORDSP ( OPERATOR IN VARCHAR2, TIMESTAMP IN DATE) AS BEGIN null;END";

    @BeforeClass
    public static void setUp() {
        parser = new DDLParser(new InputStream(){

            @Override
            public int read() throws IOException {
                return 0;
            }
        });
        parser.setTypesRepository(new DatabaseTypesRepository());
    }

    @Test
    public void testEmptyProcedure() {
        parser.ReInit(new StringReader(CREATE_EMPTY_PROCEDURE));
        boolean worked = true;
        ProcedureType procedureType = null;
        try {
            procedureType = parser.parseTopLevelProcedure();
        }
        catch (ParseException pe) {
            worked = false;
        }
        Assert.assertTrue((String)"empty procedure should parse", (boolean)worked);
        Assert.assertEquals((String)"empty procedure wrong name", (Object)procedureType.getProcedureName(), (Object)EMPTY_PROCEDURE);
        Assert.assertTrue((String)"empty procedure should have no arguments", (boolean)procedureType.getArguments().isEmpty());
    }

    @Test
    public void testDummyProcedure() {
        parser.ReInit(new StringReader(CREATE_DUMMY_PROCEDURE));
        boolean worked = true;
        String message = "";
        ProcedureType procedureType = null;
        try {
            procedureType = parser.parseTopLevelProcedure();
        }
        catch (ParseException pe) {
            message = pe.getMessage();
            worked = false;
        }
        Assert.assertTrue((String)("dummy procedure did not parse:\n" + message), (boolean)worked);
        UnresolvedTypesVisitor l = new UnresolvedTypesVisitor();
        l.visit(procedureType);
        Assert.assertTrue((String)"dummy procedure should not contain any unresolved datatypes", (boolean)l.getUnresolvedTypes().isEmpty());
        Assert.assertEquals((String)"dummy procedure wrong name", (Object)procedureType.getProcedureName(), (Object)DUMMY_PROCEDURE);
        Assert.assertTrue((String)"dummy procedure should have 1 argument", (procedureType.getArguments().size() == 1 ? 1 : 0) != 0);
        ArgumentType arg1 = procedureType.getArguments().get(0);
        Assert.assertEquals((String)"dummy procedure's argument wrong name", (Object)arg1.getArgumentName(), (Object)DUMMY_ARG);
    }

    @Test
    public void testDummyProcedure_WithSchema() {
        parser.ReInit(new StringReader(CREATE_DUMMY_PROCEDURE_SCHEMA));
        boolean worked = true;
        String message = "";
        ProcedureType procedureType = null;
        try {
            procedureType = parser.parseTopLevelProcedure();
        }
        catch (ParseException pe) {
            message = pe.getMessage();
            worked = false;
        }
        Assert.assertTrue((String)("dummy procedure(with schema) did not parse:\n" + message), (boolean)worked);
        UnresolvedTypesVisitor l = new UnresolvedTypesVisitor();
        l.visit(procedureType);
        Assert.assertTrue((String)"dummy procedure(with schema) should not contain any unresolved datatypes", (boolean)l.getUnresolvedTypes().isEmpty());
        Assert.assertEquals((String)"dummy procedure wrong schema", (Object)procedureType.getSchema(), (Object)DUMMY_PROCEDURE_SCHEMA);
        Assert.assertEquals((String)"dummy procedure wrong name", (Object)procedureType.getProcedureName(), (Object)DUMMY_PROCEDURE);
        Assert.assertTrue((String)"dummy procedure should have 1 argument", (procedureType.getArguments().size() == 1 ? 1 : 0) != 0);
        ArgumentType arg1 = procedureType.getArguments().get(0);
        Assert.assertEquals((String)"dummy procedure's argument wrong name", (Object)arg1.getArgumentName(), (Object)DUMMY_ARG);
    }

    @Test
    public void testProcedure_With_In_Out_Args() {
        parser.ReInit(new StringReader(CREATE_PROCEDURE_W_IN_OUT_ARGS));
        boolean worked = true;
        String message = "";
        ProcedureType procedureType = null;
        try {
            procedureType = parser.parseTopLevelProcedure();
        }
        catch (ParseException pe) {
            message = pe.getMessage();
            worked = false;
        }
        Assert.assertTrue((String)("procedure with in and out args did not parse:\n" + message), (boolean)worked);
        UnresolvedTypesVisitor l = new UnresolvedTypesVisitor();
        l.visit(procedureType);
        Assert.assertTrue((String)"procedure with in and out args should not contain any unresolved datatypes", (boolean)l.getUnresolvedTypes().isEmpty());
        Assert.assertEquals((String)"procedure with in and out args wrong name", (Object)procedureType.getProcedureName(), (Object)PROCEDURE_W_IN_OUT_ARGS);
        Assert.assertTrue((String)"procedure with in and out args should have 3 arguments", (procedureType.getArguments().size() == 3 ? 1 : 0) != 0);
        ArgumentType arg1 = procedureType.getArguments().get(0);
        Assert.assertEquals((String)"procedure with in and out args - arg1 wrong name", (Object)arg1.getArgumentName(), (Object)IN_ARG);
        DatabaseType arg1Type = arg1.getEnclosedType();
        Assert.assertEquals((String)("incorrect type for " + arg1.getArgumentName() + " type"), (Object)new VarChar2Type().getTypeName(), (Object)arg1Type.getTypeName());
        Assert.assertTrue((String)("incorrect direction for " + arg1.getArgumentName()), (arg1.getDirection() == ArgumentTypeDirection.IN ? 1 : 0) != 0);
        ArgumentType arg2 = procedureType.getArguments().get(1);
        Assert.assertEquals((String)"procedure with in and out args - arg2 wrong name", (Object)arg2.getArgumentName(), (Object)OUT_ARG);
        DatabaseType arg2Type = arg2.getEnclosedType();
        Assert.assertEquals((String)("incorrect type for " + arg2.getArgumentName() + " type"), (Object)new VarChar2Type().getTypeName(), (Object)arg2Type.getTypeName());
        Assert.assertTrue((String)("incorrect direction for " + arg2.getArgumentName()), (arg2.getDirection() == ArgumentTypeDirection.OUT ? 1 : 0) != 0);
        ArgumentType arg3 = procedureType.getArguments().get(2);
        Assert.assertEquals((String)"procedure with in and out args - arg3 wrong name", (Object)arg3.getArgumentName(), (Object)OUT_ARG2);
        DatabaseType arg3Type = arg3.getEnclosedType();
        Assert.assertEquals((String)("incorrect type for " + arg3.getArgumentName() + " type"), (Object)new NumericType().getTypeName(), (Object)arg3Type.getTypeName());
        Assert.assertTrue((String)("incorrect direction for " + arg3.getArgumentName()), (arg3.getDirection() == ArgumentTypeDirection.OUT ? 1 : 0) != 0);
    }

    @Test
    public void testProcedure_With_Sys_Refcursor() {
        parser.ReInit(new StringReader(CREATE_PROCEDURE_W_SYS_REFCURSOR));
        boolean worked = true;
        String message = "";
        ProcedureType procedureType = null;
        try {
            procedureType = parser.parseTopLevelProcedure();
        }
        catch (ParseException pe) {
            message = pe.getMessage();
            worked = false;
        }
        Assert.assertTrue((String)("procedure with SYS_REFCURSOR did not parse:\n" + message), (boolean)worked);
        UnresolvedTypesVisitor l = new UnresolvedTypesVisitor();
        l.visit(procedureType);
        Assert.assertTrue((String)"procedure with SYS_REFCURSOR should not contain any unresolved datatypes", (boolean)l.getUnresolvedTypes().isEmpty());
        Assert.assertEquals((String)"procedure with SYS_REFCURSOR wrong name", (Object)procedureType.getProcedureName(), (Object)PROCEDURE_W_SYS_REFCURSOR);
        Assert.assertTrue((String)"procedure with SYS_REFCURSOR should have 1 argument", (procedureType.getArguments().size() == 1 ? 1 : 0) != 0);
        ArgumentType arg1 = procedureType.getArguments().get(0);
        Assert.assertEquals((String)"procedure with SYS_REFCURSOR - arg1 wrong name", (Object)arg1.getArgumentName(), (Object)SYS_REF_OUT_ARG);
        DatabaseType arg1Type = arg1.getEnclosedType();
        Assert.assertEquals((String)("incorrect type for " + arg1.getArgumentName() + " type"), (Object)ScalarDatabaseTypeEnum.SYS_REFCURSOR_TYPE.getTypeName(), (Object)arg1Type.getTypeName());
        Assert.assertTrue((String)("incorrect direction for " + arg1.getArgumentName()), (arg1.getDirection() == ArgumentTypeDirection.OUT ? 1 : 0) != 0);
    }

    @Test
    public void testProcedure_With_InOut_Arg() {
        parser.ReInit(new StringReader(CREATE_PROCEDURE_W_INOUT_ARG));
        boolean worked = true;
        String message = "";
        ProcedureType procedureType = null;
        try {
            procedureType = parser.parseTopLevelProcedure();
        }
        catch (ParseException pe) {
            message = pe.getMessage();
            worked = false;
        }
        Assert.assertTrue((String)("procedure with INOUT arg did not parse:\n" + message), (boolean)worked);
        UnresolvedTypesVisitor l = new UnresolvedTypesVisitor();
        l.visit(procedureType);
        Assert.assertTrue((String)"procedure with INOUT arg should not contain any unresolved datatypes", (boolean)l.getUnresolvedTypes().isEmpty());
        Assert.assertEquals((String)"procedure with INOUT arg wrong name", (Object)procedureType.getProcedureName(), (Object)PROCEDURE_W_INOUT_ARG);
        Assert.assertTrue((String)"procedure with INOUT arg should have 1 argument", (procedureType.getArguments().size() == 1 ? 1 : 0) != 0);
        ArgumentType arg1 = procedureType.getArguments().get(0);
        Assert.assertEquals((String)"procedure with INOUT arg - arg1 wrong name", (Object)arg1.getArgumentName(), (Object)INOUT_ARG);
        DatabaseType arg1Type = arg1.getEnclosedType();
        Assert.assertEquals((String)("incorrect type for " + arg1.getArgumentName() + " type"), (Object)new NumericType().getTypeName(), (Object)arg1Type.getTypeName());
        Assert.assertTrue((String)("incorrect direction for " + arg1.getArgumentName()), (arg1.getDirection() == ArgumentTypeDirection.INOUT ? 1 : 0) != 0);
    }

    @Test
    public void testProcedure_With_Keyword() {
        parser.ReInit(new StringReader(CREATE_PROCEDURE_W_KEYWORDS));
        boolean worked = true;
        String message = "";
        ProcedureType procedureType = null;
        try {
            procedureType = parser.parseTopLevelProcedure();
        }
        catch (ParseException pe) {
            message = pe.getMessage();
            worked = false;
        }
        Assert.assertTrue((String)("procedure with keywords did not parse:\n" + message), (boolean)worked);
        Assert.assertEquals((String)"incorrect procedure name KEYWORDSP", (Object)PROCEDURE_W_KEYWORDS, (Object)procedureType.getProcedureName());
    }
}

