/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.typeinference.evaluators;

import java.util.LinkedList;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.evaluation.types.MultiTypeType;
import org.eclipse.dltk.ti.GoalState;
import org.eclipse.dltk.ti.ISourceModuleContext;
import org.eclipse.dltk.ti.goals.ExpressionTypeGoal;
import org.eclipse.dltk.ti.goals.GoalEvaluator;
import org.eclipse.dltk.ti.goals.IGoal;
import org.eclipse.dltk.ti.types.IEvaluatedType;
import org.eclipse.php.internal.core.typeinference.PHPClassType;
import org.eclipse.php.internal.core.typeinference.PHPModelUtils;
import org.eclipse.php.internal.core.typeinference.goals.AbstractMethodReturnTypeGoal;
import org.eclipse.php.internal.core.typeinference.goals.IteratorTypeGoal;
import org.eclipse.php.internal.core.typeinference.goals.MethodElementReturnTypeGoal;
import org.eclipse.php.internal.core.typeinference.goals.phpdoc.PHPDocMethodReturnTypeGoal;

public class IteratorTypeGoalEvaluator
extends GoalEvaluator {
    private IEvaluatedType result;

    public IteratorTypeGoalEvaluator(IGoal goal) {
        super(goal);
    }

    public IGoal[] init() {
        IteratorTypeGoal typedGoal = (IteratorTypeGoal)this.goal;
        return new IGoal[]{new ExpressionTypeGoal(this.goal.getContext(), typedGoal.getExpression())};
    }

    public Object produceResult() {
        return this.result;
    }

    public IGoal[] subGoalDone(IGoal subgoal, Object result, GoalState state) {
        if (state != GoalState.RECURSIVE) {
            if (result instanceof PHPClassType) {
                block7: {
                    if (subgoal instanceof ExpressionTypeGoal) {
                        ISourceModule sourceModule = ((ISourceModuleContext)subgoal.getContext()).getSourceModule();
                        PHPClassType classType = (PHPClassType)((Object)result);
                        LinkedList<AbstractMethodReturnTypeGoal> subGoals = new LinkedList<AbstractMethodReturnTypeGoal>();
                        try {
                            IType[] types;
                            IType[] iTypeArray = types = PHPModelUtils.getTypes(classType.getTypeName(), sourceModule, 0, null);
                            int n = types.length;
                            int n2 = 0;
                            while (n2 < n) {
                                IType type = iTypeArray[n2];
                                IType[] superTypes = PHPModelUtils.getSuperClasses(type, null);
                                if (this.isImplementedIterator(superTypes)) {
                                    subGoals.add(new MethodElementReturnTypeGoal(subgoal.getContext(), new IType[]{type}, "current"));
                                    subGoals.add(new PHPDocMethodReturnTypeGoal(subgoal.getContext(), new IType[]{type}, "current"));
                                }
                                ++n2;
                            }
                            return subGoals.toArray(new IGoal[subGoals.size()]);
                        }
                        catch (ModelException e) {
                            if (!DLTKCore.DEBUG) break block7;
                            e.printStackTrace();
                        }
                    }
                }
                MultiTypeType type = new MultiTypeType();
                type.addType((IEvaluatedType)result);
                this.result = type;
                return IGoal.NO_GOALS;
            }
            this.result = (IEvaluatedType)result;
        }
        return IGoal.NO_GOALS;
    }

    private boolean isImplementedIterator(IType[] superClasses) {
        if (superClasses == null) {
            return false;
        }
        IType[] iTypeArray = superClasses;
        int n = superClasses.length;
        int n2 = 0;
        while (n2 < n) {
            IType superClass = iTypeArray[n2];
            if (superClass.getFullyQualifiedName().equalsIgnoreCase("Iterator")) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

