/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.text.correction;

import org.eclipse.dltk.compiler.problem.CategorizedProblem;
import org.eclipse.dltk.compiler.problem.IProblem;
import org.eclipse.dltk.ui.editor.IScriptAnnotation;
import org.eclipse.php.internal.core.ast.nodes.ASTNode;
import org.eclipse.php.internal.core.ast.nodes.Program;
import org.eclipse.php.internal.core.ast.visitor.Visitor;
import org.eclipse.php.internal.core.corext.dom.NodeFinder;
import org.eclipse.php.internal.ui.text.correction.IProblemLocation;

public class ProblemLocation
implements IProblemLocation {
    private final int fId;
    private final String[] fArguments;
    private final int fOffset;
    private final int fLength;
    private final boolean fIsError;
    private final String fMarkerType;

    public ProblemLocation(int offset, int length, IScriptAnnotation annotation) {
        this.fId = annotation.getId() != null ? Integer.parseInt(annotation.getId().name()) : -1;
        this.fArguments = annotation.getArguments();
        this.fOffset = offset;
        this.fLength = length;
        this.fIsError = "org.eclipse.dltk.ui.error".equals(annotation.getType());
        String markerType = annotation.getMarkerType();
        this.fMarkerType = markerType != null ? markerType : "org.eclipse.dltk.core.problem";
    }

    public ProblemLocation(int offset, int length, int id, String[] arguments, boolean isError, String markerType) {
        this.fId = id;
        this.fArguments = arguments;
        this.fOffset = offset;
        this.fLength = length;
        this.fIsError = isError;
        this.fMarkerType = markerType;
    }

    public ProblemLocation(IProblem problem) {
        this.fId = problem.getID() != null ? Integer.parseInt(problem.getID().name()) : -1;
        this.fArguments = problem.getArguments();
        this.fOffset = problem.getSourceStart();
        this.fLength = problem.getSourceEnd() - this.fOffset + 1;
        this.fIsError = problem.isError();
        this.fMarkerType = problem instanceof CategorizedProblem ? ((CategorizedProblem)problem).getMarkerType() : "org.eclipse.dltk.core.problem";
    }

    public int getProblemId() {
        return this.fId;
    }

    public String[] getProblemArguments() {
        return this.fArguments;
    }

    public int getLength() {
        return this.fLength;
    }

    public int getOffset() {
        return this.fOffset;
    }

    public boolean isError() {
        return this.fIsError;
    }

    public String getMarkerType() {
        return this.fMarkerType;
    }

    public ASTNode getCoveringNode(Program astRoot) {
        NodeFinder finder = new NodeFinder(this.fOffset, this.fLength);
        astRoot.accept((Visitor)finder);
        return finder.getCoveringNode();
    }

    public ASTNode getCoveredNode(Program astRoot) {
        NodeFinder finder = new NodeFinder(this.fOffset, this.fLength);
        astRoot.accept((Visitor)finder);
        return finder.getCoveredNode();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("Id: ").append(this.getErrorCode(this.fId)).append('\n');
        buf.append('[').append(this.fOffset).append(", ").append(this.fLength).append(']').append('\n');
        String[] arg = this.fArguments;
        if (arg != null) {
            int i = 0;
            while (i < arg.length) {
                buf.append(arg[i]);
                buf.append('\n');
                ++i;
            }
        }
        return buf.toString();
    }

    private String getErrorCode(int code) {
        StringBuffer buf = new StringBuffer();
        if ((code & 0x1000000) != 0) {
            buf.append("TypeRelated + ");
        }
        if ((code & 0x2000000) != 0) {
            buf.append("FieldRelated + ");
        }
        if ((code & 0x8000000) != 0) {
            buf.append("ConstructorRelated + ");
        }
        if ((code & 0x4000000) != 0) {
            buf.append("MethodRelated + ");
        }
        if ((code & 0x10000000) != 0) {
            buf.append("ImportRelated + ");
        }
        if ((code & 0x20000000) != 0) {
            buf.append("Internal + ");
        }
        if ((code & 0x40000000) != 0) {
            buf.append("Syntax + ");
        }
        if ((code & Integer.MIN_VALUE) != 0) {
            buf.append("PHPdoc + ");
        }
        buf.append(code & 0xFFFFFF);
        return buf.toString();
    }
}

