/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.core;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ptp.core.IModelManager;
import org.eclipse.ptp.core.PTPCorePlugin;
import org.eclipse.ptp.core.Preferences;
import org.eclipse.ptp.core.elements.IPUniverse;
import org.eclipse.ptp.core.events.IResourceManagerErrorEvent;
import org.eclipse.ptp.core.jobs.IJobControl;
import org.eclipse.ptp.core.listeners.IResourceManagerListener;
import org.eclipse.ptp.core.messages.Messages;
import org.eclipse.ptp.internal.core.elements.PUniverse;
import org.eclipse.ptp.internal.core.events.ResourceManagerAddedEvent;
import org.eclipse.ptp.internal.core.events.ResourceManagerChangedEvent;
import org.eclipse.ptp.internal.core.events.ResourceManagerErrorEvent;
import org.eclipse.ptp.internal.core.events.ResourceManagerRemovedEvent;
import org.eclipse.ptp.rmsystem.AbstractResourceManagerFactory;
import org.eclipse.ptp.rmsystem.IResourceManager;
import org.eclipse.ptp.rmsystem.IResourceManagerComponentConfiguration;
import org.eclipse.ptp.rmsystem.IResourceManagerConfiguration;
import org.eclipse.ptp.rmsystem.IResourceManagerControl;
import org.eclipse.ptp.rmsystem.IResourceManagerControlFactory;
import org.eclipse.ptp.rmsystem.IResourceManagerMonitor;
import org.eclipse.ptp.rmsystem.IResourceManagerMonitorFactory;
import org.eclipse.ptp.rmsystem.ResourceManagerServiceProvider;
import org.eclipse.ptp.services.core.IService;
import org.eclipse.ptp.services.core.IServiceConfiguration;
import org.eclipse.ptp.services.core.IServiceModelEvent;
import org.eclipse.ptp.services.core.IServiceModelEventListener;
import org.eclipse.ptp.services.core.IServiceModelManager;
import org.eclipse.ptp.services.core.IServiceProvider;
import org.eclipse.ptp.services.core.ServiceModelManager;

@Deprecated
public class ModelManager
implements IModelManager {
    private static String RM_NAME = "resourceManager";
    private static String RM_CONTROL_NAME = "resourceManagerControl";
    private static String RM_MONITOR_NAME = "resourceManagerMonitor";
    private static String ID_ATTRIBUTE = "id";
    private static String CLASS_ATTRIBUTE = "class";
    private static String EXTENSION_POINT = "org.eclipse.ptp.core.resourceManagers";
    private final IServiceModelEventListener fServiceEventListener = new IServiceModelEventListener(){

        public void handleEvent(IServiceModelEvent event) {
            switch (event.getType()) {
                case 2: {
                    IResourceManager rm;
                    IServiceProvider provider = ((IServiceConfiguration)event.getSource()).getServiceProvider(ModelManager.this.fLaunchService);
                    if (provider == null || !(provider instanceof ResourceManagerServiceProvider) || (rm = ModelManager.this.getResourceManagerFromUniqueName(((ResourceManagerServiceProvider)provider).getUniqueName())) == null) break;
                    ModelManager.this.doRemoveResourceManager(rm);
                    break;
                }
                case 4: {
                    RMFactory factory;
                    IResourceManager rm;
                    IServiceProvider newProvider;
                    IServiceConfiguration config = (IServiceConfiguration)event.getSource();
                    if (event.getOldProvider() != null || (newProvider = config.getServiceProvider(ModelManager.this.fLaunchService)) == null || !(newProvider instanceof ResourceManagerServiceProvider) || (rm = ModelManager.this.getResourceManagerFromUniqueName(((ResourceManagerServiceProvider)newProvider).getUniqueName())) != null || (factory = ModelManager.this.getResourceManagerFactory(newProvider.getId())) == null) break;
                    ModelManager.this.addResourceManager(ModelManager.this.createResourceManager(factory, newProvider));
                    break;
                }
                case 64: {
                    IResourceManager rm;
                    IServiceProvider provider = (IServiceProvider)event.getSource();
                    if (provider == null || !(provider instanceof ResourceManagerServiceProvider) || (rm = ModelManager.this.getResourceManagerFromUniqueName(((ResourceManagerServiceProvider)provider).getUniqueName())) == null) break;
                    ModelManager.this.fireResourceManagerChanged(rm);
                }
            }
        }
    };
    private static final ModelManager fInstance = new ModelManager();
    private final ListenerList fResourceManagerListeners = new ListenerList();
    private final IServiceModelManager fServiceManager = ServiceModelManager.getInstance();
    private final Map<String, IResourceManager> fResourceManagers = new ConcurrentHashMap<String, IResourceManager>();
    private final Map<String, IJobControl> fJobControllers = new ConcurrentHashMap<String, IJobControl>();
    private final IService fLaunchService = this.fServiceManager.getService("org.eclipse.ptp.core.LaunchService");
    private final IPUniverse fUniverse = new PUniverse();
    private Map<String, RMFactory> fResourceManagerFactories = null;
    private Map<String, IResourceManagerControlFactory> fResourceManagerControlFactories = null;
    private Map<String, IResourceManagerMonitorFactory> fResourceManagerMonitorFactories = null;

    public static ModelManager getInstance() {
        return fInstance;
    }

    public ModelManager() {
        this.fServiceManager.addEventListener(this.fServiceEventListener, 71);
    }

    public void addJobControl(IJobControl control) {
        this.fJobControllers.put(control.getControlId(), control);
    }

    public void addListener(IResourceManagerListener listener) {
        this.fResourceManagerListeners.add((Object)listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addResourceManager(IResourceManager rm) {
        Map<String, IResourceManager> map = this.fResourceManagers;
        synchronized (map) {
            this.fResourceManagers.put(rm.getUniqueName(), rm);
        }
        this.fireNewResourceManager(rm);
    }

    public void addResourceManagers(IResourceManager[] rms) {
        IResourceManager[] iResourceManagerArray = rms;
        int n = rms.length;
        int n2 = 0;
        while (n2 < n) {
            IResourceManager rm = iResourceManagerArray[n2];
            this.addResourceManager(rm);
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeResourceManagerUniqueName(String oldName, String newName) {
        IResourceManager rm = this.getResourceManagerFromUniqueName(oldName);
        if (rm != null) {
            Map<String, IResourceManager> map = this.fResourceManagers;
            synchronized (map) {
                this.fResourceManagers.put(oldName, null);
                this.fResourceManagers.put(newName, rm);
            }
        }
    }

    public IResourceManagerConfiguration createBaseConfiguration(IServiceProvider provider) {
        RMFactory factory = this.getResourceManagerFactory(provider.getId());
        if (factory != null) {
            return factory.getFactory().createConfiguration(provider);
        }
        return null;
    }

    public IResourceManagerComponentConfiguration createControlConfiguration(IServiceProvider provider) {
        IResourceManagerControlFactory controlFactory;
        RMFactory factory = this.getResourceManagerFactory(provider.getId());
        if (factory != null && (controlFactory = this.fResourceManagerControlFactories.get(factory.getControlId())) != null) {
            return controlFactory.createControlConfiguration(provider);
        }
        return null;
    }

    public IResourceManagerComponentConfiguration createMonitorConfiguration(IServiceProvider provider) {
        IResourceManagerMonitorFactory monitorFactory;
        RMFactory factory = this.getResourceManagerFactory(provider.getId());
        if (factory != null && (monitorFactory = this.fResourceManagerMonitorFactories.get(factory.getMonitorId())) != null) {
            return monitorFactory.createMonitorConfiguration(provider);
        }
        return null;
    }

    public void fireResourceManagerChanged(IResourceManager rm) {
        ResourceManagerChangedEvent e = new ResourceManagerChangedEvent(rm);
        Object[] objectArray = this.fResourceManagerListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((IResourceManagerListener)listener).handleEvent(e);
            ++n2;
        }
    }

    public void fireResourceManagerError(IResourceManager rm, String message) {
        ResourceManagerErrorEvent e = new ResourceManagerErrorEvent(rm, message);
        Object[] objectArray = this.fResourceManagerListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((IResourceManagerListener)listener).handleEvent(e);
            ++n2;
        }
    }

    public String getControlFactoryId(String rmId) {
        RMFactory factory = this.getResourceManagerFactory(rmId);
        if (factory != null) {
            return factory.getControlId();
        }
        return null;
    }

    public IJobControl getJobControl(String id) {
        IJobControl control = this.fJobControllers.get(id);
        if (control == null) {
            control = this.fResourceManagers.get(id);
        }
        return control;
    }

    public String getMonitorFactoryId(String rmId) {
        RMFactory factory = this.getResourceManagerFactory(rmId);
        if (factory != null) {
            return factory.getMonitorId();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IResourceManager getResourceManagerFromUniqueName(String rmUniqueName) {
        Map<String, IResourceManager> map = this.fResourceManagers;
        synchronized (map) {
            return this.fResourceManagers.get(rmUniqueName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IResourceManager[] getResourceManagers() {
        Map<String, IResourceManager> map = this.fResourceManagers;
        synchronized (map) {
            return this.fResourceManagers.values().toArray(new IResourceManager[0]);
        }
    }

    public IPUniverse getUniverse() {
        return this.fUniverse;
    }

    public void handleEvent(IResourceManagerErrorEvent e) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadResourceManagers() throws CoreException {
        HashSet<IResourceManager> rmsNeedStarting = new HashSet<IResourceManager>();
        this.fServiceManager.getActiveConfiguration();
        Map<String, IResourceManager> map = this.fResourceManagers;
        synchronized (map) {
            for (IResourceManager rm : this.fResourceManagers.values()) {
                if (!rm.getConfiguration().getAutoStart()) continue;
                rmsNeedStarting.add(rm);
            }
        }
        if (Preferences.getBoolean(PTPCorePlugin.getUniqueIdentifier(), "autoStartRMs")) {
            this.startResourceManagers(rmsNeedStarting.toArray(new IResourceManager[0]));
        }
    }

    public void removeJobControl(IJobControl control) {
        this.fJobControllers.remove(control.getControlId());
    }

    public void removeListener(IResourceManagerListener listener) {
        this.fResourceManagerListeners.remove((Object)listener);
    }

    public void removeResourceManager(IResourceManager rm) {
        IServiceProvider provider = (IServiceProvider)rm.getConfiguration().getAdapter(IServiceProvider.class);
        if (provider != null) {
            this.removeProviderFromConfiguration(provider);
        }
        this.doRemoveResourceManager(rm);
    }

    public void removeResourceManagers(IResourceManager[] rms) {
        IResourceManager[] iResourceManagerArray = rms;
        int n = rms.length;
        int n2 = 0;
        while (n2 < n) {
            IResourceManager rm = iResourceManagerArray[n2];
            this.removeResourceManager(rm);
            ++n2;
        }
    }

    public void saveResourceManagers() {
    }

    public void shutdown() throws CoreException {
        this.saveResourceManagers();
        this.stopResourceManagers();
        this.disposeResourceManagers();
        this.fResourceManagerListeners.clear();
    }

    public void start() throws CoreException {
        this.loadResourceManagers();
    }

    public void stopResourceManagers() throws CoreException {
        IResourceManager[] iResourceManagerArray = this.getResourceManagers();
        int n = iResourceManagerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResourceManager resourceManager = iResourceManagerArray[n2];
            resourceManager.stop();
            ++n2;
        }
    }

    private String addControlFactory(IConfigurationElement element) {
        String id = element.getAttribute(ID_ATTRIBUTE);
        if (element.getAttribute(CLASS_ATTRIBUTE) != null) {
            try {
                IResourceManagerControlFactory factory = (IResourceManagerControlFactory)element.createExecutableExtension(CLASS_ATTRIBUTE);
                this.fResourceManagerControlFactories.put(id, factory);
            }
            catch (Exception e) {
                PTPCorePlugin.log(e);
            }
        }
        return id;
    }

    private String addMonitorFactory(IConfigurationElement element) {
        String id = element.getAttribute(ID_ATTRIBUTE);
        if (element.getAttribute(CLASS_ATTRIBUTE) != null) {
            try {
                IResourceManagerMonitorFactory factory = (IResourceManagerMonitorFactory)element.createExecutableExtension(CLASS_ATTRIBUTE);
                this.fResourceManagerMonitorFactories.put(id, factory);
            }
            catch (Exception e) {
                PTPCorePlugin.log(e);
            }
        }
        return id;
    }

    private IResourceManager createResourceManager(RMFactory factory, IServiceProvider provider) {
        IResourceManagerMonitorFactory monitorFactory;
        IResourceManagerControl control = null;
        IResourceManagerMonitor monitor = null;
        IResourceManagerControlFactory controlFactory = this.fResourceManagerControlFactories.get(factory.getControlId());
        if (controlFactory != null) {
            IResourceManagerComponentConfiguration controlConfig = controlFactory.createControlConfiguration(provider);
            control = controlFactory.createControl(controlConfig);
        }
        if ((monitorFactory = this.fResourceManagerMonitorFactories.get(factory.getMonitorId())) != null) {
            IResourceManagerComponentConfiguration monitorConfig = monitorFactory.createMonitorConfiguration(provider);
            monitor = monitorFactory.createMonitor(monitorConfig);
        }
        IResourceManagerConfiguration config = factory.getFactory().createConfiguration(provider);
        return factory.getFactory().create(config, control, monitor);
    }

    private void disposeResourceManagers() {
        IResourceManager[] iResourceManagerArray = this.getResourceManagers();
        int n = iResourceManagerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResourceManager resourceManager = iResourceManagerArray[n2];
            resourceManager.dispose();
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRemoveResourceManager(IResourceManager rm) {
        Map<String, IResourceManager> map = this.fResourceManagers;
        synchronized (map) {
            this.fResourceManagers.remove(rm.getUniqueName());
        }
        this.fireRemoveResourceManager(rm);
        rm.dispose();
    }

    private void fireNewResourceManager(IResourceManager rm) {
        ResourceManagerAddedEvent event = new ResourceManagerAddedEvent(this, rm);
        Object[] objectArray = this.fResourceManagerListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((IResourceManagerListener)listener).handleEvent(event);
            ++n2;
        }
    }

    private void fireRemoveResourceManager(IResourceManager rm) {
        ResourceManagerRemovedEvent event = new ResourceManagerRemovedEvent(this, rm);
        Object[] objectArray = this.fResourceManagerListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((IResourceManagerListener)listener).handleEvent(event);
            ++n2;
        }
    }

    private void getResourceManagerFactories() {
        if (this.fResourceManagerFactories == null) {
            this.fResourceManagerFactories = new HashMap<String, RMFactory>();
            this.fResourceManagerControlFactories = new HashMap<String, IResourceManagerControlFactory>();
            this.fResourceManagerMonitorFactories = new HashMap<String, IResourceManagerMonitorFactory>();
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IExtensionPoint extensionPoint = registry.getExtensionPoint(EXTENSION_POINT);
            IExtension[] iExtensionArray = extensionPoint.getExtensions();
            int n = iExtensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension ext = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = ext.getConfigurationElements();
                int n3 = iConfigurationElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement ce = iConfigurationElementArray[n4];
                    if (ce.getName().equals(RM_NAME)) {
                        RMFactory factory = new RMFactory();
                        IConfigurationElement[] el = ce.getChildren();
                        if (el.length == 2) {
                            try {
                                factory.setFactory((AbstractResourceManagerFactory)ce.createExecutableExtension(CLASS_ATTRIBUTE));
                                factory.setControlId(this.addControlFactory(el[0]));
                                factory.setMonitorId(this.addMonitorFactory(el[1]));
                                factory.setId(ce.getAttribute(ID_ATTRIBUTE));
                                this.fResourceManagerFactories.put(factory.getId(), factory);
                            }
                            catch (Exception e) {
                                PTPCorePlugin.log(e);
                            }
                        }
                    } else if (ce.getName().equals(RM_CONTROL_NAME)) {
                        this.addControlFactory(ce);
                    } else if (ce.getName().equals(RM_MONITOR_NAME)) {
                        this.addMonitorFactory(ce);
                    }
                    ++n4;
                }
                ++n2;
            }
        }
    }

    private RMFactory getResourceManagerFactory(String id) {
        this.getResourceManagerFactories();
        return this.fResourceManagerFactories.get(id);
    }

    private void removeProviderFromConfiguration(IServiceProvider provider) {
        Set configs = this.fServiceManager.getConfigurations();
        for (IServiceConfiguration config : configs) {
            if (config.getServiceProvider(this.fLaunchService) != provider) continue;
            config.setServiceProvider(this.fLaunchService, null);
            break;
        }
    }

    private void startResourceManagers(IResourceManager[] rmsNeedStarting) throws CoreException {
        RMStartupJob job = new RMStartupJob(rmsNeedStarting);
        job.schedule();
    }

    private class RMFactory {
        private String fId;
        private String fControlId;
        private String fMonitorId;
        private AbstractResourceManagerFactory fFactory;

        private RMFactory() {
        }

        public String getControlId() {
            return this.fControlId;
        }

        public AbstractResourceManagerFactory getFactory() {
            return this.fFactory;
        }

        public String getId() {
            return this.fId;
        }

        public String getMonitorId() {
            return this.fMonitorId;
        }

        public void setControlId(String id) {
            this.fControlId = id;
        }

        public void setFactory(AbstractResourceManagerFactory factory) {
            this.fFactory = factory;
        }

        public void setId(String id) {
            this.fId = id;
        }

        public void setMonitorId(String id) {
            this.fMonitorId = id;
        }
    }

    private class RMStartupJob
    extends Job {
        private final IResourceManager[] resourceManagers;

        public RMStartupJob(IResourceManager[] rms) {
            super(Messages.ModelManager_0);
            this.resourceManagers = rms;
        }

        protected IStatus run(IProgressMonitor monitor) {
            SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)this.resourceManagers.length);
            try {
                IResourceManager[] iResourceManagerArray = this.resourceManagers;
                int n = this.resourceManagers.length;
                int n2 = 0;
                while (n2 < n) {
                    IResourceManager rm = iResourceManagerArray[n2];
                    rm.start((IProgressMonitor)subMon.newChild(1));
                    if (subMon.isCanceled()) {
                        IStatus iStatus = Status.CANCEL_STATUS;
                        return iStatus;
                    }
                    try {
                        ++n2;
                    }
                    catch (CoreException e) {
                        IStatus iStatus = e.getStatus();
                        return iStatus;
                    }
                }
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            finally {
                if (monitor != null) {
                    monitor.done();
                }
            }
        }
    }
}

