/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rdt.server.dstore.core;

import java.io.IOException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.dstore.core.client.ClientConnection;
import org.eclipse.dstore.core.client.ConnectionStatus;
import org.eclipse.dstore.core.model.DataElement;
import org.eclipse.dstore.core.model.DataStore;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.ptp.rdt.server.dstore.internal.core.DebugUtil;
import org.eclipse.ptp.rdt.server.dstore.messages.Messages;
import org.eclipse.ptp.rdt.ui.subsystems.StatusMonitor;
import org.eclipse.ptp.remote.core.IRemoteConnection;
import org.eclipse.ptp.remote.core.exception.RemoteConnectionException;
import org.eclipse.ptp.remote.core.server.AbstractRemoteServerRunner;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class DStoreServer
extends AbstractRemoteServerRunner {
    public static String SERVER_ID = "org.eclipse.ptp.rdt.server.dstore.RemoteToolsDStoreServer";
    private DStoreState fState = DStoreState.WAITING_FOR_SUCCESS_STRING;
    private ClientConnection fDStoreConnection = null;
    private int fDStorePort = 0;
    private final int TIMEOUT = 60000;
    private static final String SUCCESS_STRING = "Server Started Successfully";

    public DStoreServer() {
        super(Messages.DStoreServer_0);
    }

    public DataStore getDataStore() {
        if (this.getServerState() != AbstractRemoteServerRunner.ServerState.RUNNING) {
            try {
                if (this.getServerState() == AbstractRemoteServerRunner.ServerState.STOPPED) {
                    this.startServer((IProgressMonitor)new NullProgressMonitor());
                }
                this.waitForServerStart(60000);
            }
            catch (IOException e) {
                Status status = new Status(4, "org.eclipse.ptp.rdt.server.dstore", 0, e.getMessage(), (Throwable)e);
                Display.getDefault().asyncExec(new Runnable((IStatus)status){
                    private final /* synthetic */ IStatus val$status;
                    {
                        this.val$status = iStatus;
                    }

                    public void run() {
                        ErrorDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Messages.DStoreServer_serverError, (String)Messages.DStoreServer_unableToStart, (IStatus)this.val$status);
                    }
                });
            }
        }
        if (this.getServerState() == AbstractRemoteServerRunner.ServerState.RUNNING) {
            ClientConnection conn = this.getClientConnection();
            assert (conn != null);
            return conn.getDataStore();
        }
        return null;
    }

    private ClientConnection getClientConnection() {
        if (this.fDStoreConnection == null && this.getRemoteConnection() != null) {
            this.fDStoreConnection = new ClientConnection(this.getRemoteConnection().getName());
        }
        return this.fDStoreConnection;
    }

    protected void doServerFinished(IProgressMonitor monitor) {
        try {
            if (this.fDStoreConnection != null) {
                this.fDStoreConnection.disconnect();
                this.fDStoreConnection = null;
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    protected boolean doServerStarting(IProgressMonitor monitor) {
        try {
            this.fState = DStoreState.WAITING_FOR_SUCCESS_STRING;
            return true;
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    protected boolean doServerStarted(IProgressMonitor monitor) {
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            ConnectionStatus status;
            int port;
            try {
                port = this.getRemoteConnection().forwardLocalPort("localhost", this.fDStorePort, (IProgressMonitor)subMon.newChild(10));
            }
            catch (RemoteConnectionException e) {
                if (DebugUtil.SERVER_TRACING) {
                    System.err.println(String.valueOf(Messages.DStoreServer_1) + e.getLocalizedMessage());
                }
                if (monitor != null) {
                    monitor.done();
                }
                return false;
            }
            this.getClientConnection().setHost("localhost");
            this.getClientConnection().setPort(Integer.toString(port));
            if (DebugUtil.SERVER_TRACING) {
                System.out.println(Messages.DStoreServer_2);
            }
            if ((status = this.getClientConnection().connect(null, 0)).isConnected()) {
                DataStore dataStore = this.getClientConnection().getDataStore();
                dataStore.showTicket(null);
                dataStore.registerLocalClassLoader(((Object)((Object)this)).getClass().getClassLoader());
                DataElement res = dataStore.activateMiner("org.eclipse.ptp.internal.rdt.core.miners.CDTMiner");
                StatusMonitor smonitor = StatusMonitor.getStatusMonitorFor((IRemoteConnection)this.getRemoteConnection(), (DataStore)dataStore);
                try {
                    smonitor.waitForUpdate(res, (IProgressMonitor)subMon.newChild(5));
                }
                catch (InterruptedException interruptedException) {
                    if (monitor != null) {
                        monitor.done();
                    }
                    return false;
                }
                if (DebugUtil.SERVER_TRACING) {
                    System.out.println(Messages.DStoreServer_3);
                }
                return true;
            }
            return false;
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    protected boolean doVerifyServerRunningFromStderr(String output) {
        switch (this.fState) {
            case WAITING_FOR_SUCCESS_STRING: {
                if (!output.startsWith(SUCCESS_STRING)) break;
                this.fState = DStoreState.WAITING_FOR_PORT;
                if (!DebugUtil.SERVER_TRACING) break;
                System.out.println(Messages.DStoreServer_4);
                break;
            }
            case WAITING_FOR_PORT: {
                if (!output.matches("^[0-9]+$")) break;
                this.fDStorePort = Integer.parseInt(output);
                this.fState = DStoreState.COMPLETED;
                if (!DebugUtil.SERVER_TRACING) break;
                System.out.println(String.valueOf(Messages.DStoreServer_5) + this.fDStorePort);
                break;
            }
            case COMPLETED: {
                return true;
            }
        }
        return false;
    }

    protected boolean doVerifyServerRunningFromStdout(String output) {
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum DStoreState {
        WAITING_FOR_SUCCESS_STRING,
        WAITING_FOR_PORT,
        COMPLETED;

    }
}

