/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rdt.sync.core;

import java.util.NoSuchElementException;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.ptp.rdt.sync.core.ResourceMatcher;
import org.eclipse.ptp.rdt.sync.core.messages.Messages;
import org.osgi.service.prefs.Preferences;

public class PathResourceMatcher
extends ResourceMatcher {
    private static final String ATTR_PATH = "path";
    IPath path;

    public PathResourceMatcher(IPath p) {
        this.path = p == null ? new Path("") : p;
    }

    @Override
    public boolean match(IResource candidate) {
        if (candidate == null) {
            return false;
        }
        return this.path.isPrefixOf(candidate.getProjectRelativePath());
    }

    @Override
    public String toString() {
        return this.path.toOSString();
    }

    @Override
    public int hashCode() {
        return this.path.toOSString().hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PathResourceMatcher)) {
            return false;
        }
        PathResourceMatcher other = (PathResourceMatcher)obj;
        return this.path.toOSString().equals(other.path.toOSString());
    }

    @Override
    public void saveMatcher(Preferences prefRootNode) {
        super.saveMatcher(prefRootNode);
        prefRootNode.put(ATTR_PATH, this.path.toPortableString());
    }

    public static ResourceMatcher loadMatcher(Preferences prefRootNode) throws NoSuchElementException {
        String p = prefRootNode.get(ATTR_PATH, null);
        if (p == null) {
            throw new NoSuchElementException(Messages.PathResourceMatcher_0);
        }
        return new PathResourceMatcher(Path.fromPortableString((String)p));
    }
}

