/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rdt.sync.core;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.ptp.rdt.sync.core.PathResourceMatcher;
import org.eclipse.ptp.rdt.sync.core.RDTSyncCorePlugin;
import org.eclipse.ptp.rdt.sync.core.ResourceMatcher;
import org.eclipse.ptp.rdt.sync.core.messages.Messages;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class SyncFileFilter {
    private static final String PATTERN_NODE_NAME = "pattern";
    private static final String PATTERN_TYPE_KEY = "pattern-type";
    private static final String NUM_PATTERNS_KEY = "num-patterns";
    private final LinkedList<ResourceMatcher> filteredPaths = new LinkedList();
    private final Map<ResourceMatcher, PatternType> patternToTypeMap = new HashMap<ResourceMatcher, PatternType>();

    private SyncFileFilter() {
    }

    public SyncFileFilter(SyncFileFilter oldFilter) {
        this.filteredPaths.addAll(oldFilter.filteredPaths);
        this.patternToTypeMap.putAll(oldFilter.patternToTypeMap);
    }

    public static SyncFileFilter createEmptyFilter() {
        return new SyncFileFilter();
    }

    public static SyncFileFilter createBuiltInDefaultFilter() {
        SyncFileFilter sff = new SyncFileFilter();
        sff.addDefaults();
        return sff;
    }

    public ResourceMatcher[] getPatterns() {
        return this.filteredPaths.toArray(new ResourceMatcher[this.filteredPaths.size()]);
    }

    public PatternType getPatternType(ResourceMatcher pattern) {
        return this.patternToTypeMap.get(pattern);
    }

    public void addDefaults() {
        this.addPattern(new PathResourceMatcher((IPath)new Path(".project")), PatternType.EXCLUDE);
        this.addPattern(new PathResourceMatcher((IPath)new Path(".cproject")), PatternType.EXCLUDE);
        this.addPattern(new PathResourceMatcher((IPath)new Path(".settings")), PatternType.EXCLUDE);
        this.addPattern(new PathResourceMatcher((IPath)new Path(".ptp-sync")), PatternType.EXCLUDE);
    }

    public void addPattern(ResourceMatcher pattern, PatternType type) {
        if (this.patternToTypeMap.get(pattern) != null) {
            this.filteredPaths.remove(pattern);
        }
        this.filteredPaths.add(0, pattern);
        this.patternToTypeMap.put(pattern, type);
    }

    public void removePattern(ResourceMatcher pattern) {
        this.filteredPaths.remove(pattern);
        this.patternToTypeMap.remove(pattern);
    }

    public boolean promote(ResourceMatcher pattern) {
        int oldIndex = this.filteredPaths.indexOf(pattern);
        if (oldIndex > 0) {
            this.filteredPaths.remove(oldIndex);
            this.filteredPaths.add(oldIndex - 1, pattern);
            return true;
        }
        return false;
    }

    public boolean demote(ResourceMatcher pattern) {
        int oldIndex = this.filteredPaths.indexOf(pattern);
        if (oldIndex > -1 && oldIndex < this.filteredPaths.size() - 1) {
            this.filteredPaths.remove(oldIndex);
            this.filteredPaths.add(oldIndex + 1, pattern);
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean shouldIgnore(IResource r) {
        if (r instanceof IFolder) {
            try {
                IResource[] iResourceArray = ((IFolder)r).members();
                int n = iResourceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource member = iResourceArray[n2];
                    if (!this.shouldIgnore(member)) {
                        return false;
                    }
                    ++n2;
                }
            }
            catch (CoreException coreException) {}
        }
        for (ResourceMatcher pm : this.filteredPaths) {
            if (!pm.match(r)) continue;
            PatternType type = this.patternToTypeMap.get(pm);
            assert (pm != null);
            return type == PatternType.EXCLUDE;
        }
        return false;
    }

    public void saveFilter(Preferences prefRootNode) {
        try {
            prefRootNode.node(PATTERN_NODE_NAME).removeNode();
            prefRootNode.flush();
        }
        catch (BackingStoreException e) {
            RDTSyncCorePlugin.log(Messages.SyncFileFilter_2, e);
            return;
        }
        Preferences prefPatternNode = prefRootNode.node(PATTERN_NODE_NAME);
        prefPatternNode.putInt(NUM_PATTERNS_KEY, this.filteredPaths.size());
        int i = 0;
        for (ResourceMatcher pm : this.filteredPaths) {
            Preferences prefMatcherNode = prefPatternNode.node(Integer.toString(i));
            prefMatcherNode.put(PATTERN_TYPE_KEY, this.patternToTypeMap.get(pm).name());
            pm.saveMatcher(prefMatcherNode);
            ++i;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static SyncFileFilter loadFilter(Preferences prefRootNode) {
        try {
            if (!prefRootNode.nodeExists(PATTERN_NODE_NAME)) {
                return null;
            }
            Preferences prefPatternNode = prefRootNode.node(PATTERN_NODE_NAME);
            int numPatterns = prefPatternNode.getInt(NUM_PATTERNS_KEY, -1);
            if (numPatterns == -1) {
                RDTSyncCorePlugin.log(Messages.SyncFileFilter_1);
                return null;
            }
            SyncFileFilter filter = SyncFileFilter.createEmptyFilter();
            int i = numPatterns - 1;
            while (true) {
                if (i < 0) {
                    return filter;
                }
                if (!prefPatternNode.nodeExists(Integer.toString(i))) {
                    RDTSyncCorePlugin.log(Messages.SyncFileFilter_1);
                    return null;
                }
                Preferences prefMatcherNode = prefPatternNode.node(Integer.toString(i));
                String typeName = prefMatcherNode.get(PATTERN_TYPE_KEY, null);
                if (typeName == null) {
                    RDTSyncCorePlugin.log(Messages.SyncFileFilter_1);
                    return null;
                }
                PatternType type = PatternType.valueOf(typeName);
                ResourceMatcher pm = ResourceMatcher.loadMatcher(prefMatcherNode);
                filter.addPattern(pm, type);
                --i;
            }
        }
        catch (BackingStoreException e) {
            RDTSyncCorePlugin.log(Messages.SyncFileFilter_1, e);
            return null;
        }
        catch (InvocationTargetException e) {
            RDTSyncCorePlugin.log(Messages.SyncFileFilter_1, e);
            return null;
        }
        catch (ParserConfigurationException e) {
            RDTSyncCorePlugin.log(Messages.SyncFileFilter_1, e);
            return null;
        }
    }

    public static enum PatternType {
        EXCLUDE,
        INCLUDE;

    }
}

