/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rdt.sync.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.regex.PatternSyntaxException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.preference.IPreferencePageContainer;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.window.ApplicationWindow;
import org.eclipse.ptp.rdt.sync.core.BuildConfigurationManager;
import org.eclipse.ptp.rdt.sync.core.BuildScenario;
import org.eclipse.ptp.rdt.sync.core.MissingConnectionException;
import org.eclipse.ptp.rdt.sync.core.PathResourceMatcher;
import org.eclipse.ptp.rdt.sync.core.RegexResourceMatcher;
import org.eclipse.ptp.rdt.sync.core.RemoteContentProvider;
import org.eclipse.ptp.rdt.sync.core.ResourceMatcher;
import org.eclipse.ptp.rdt.sync.core.SyncFileFilter;
import org.eclipse.ptp.rdt.sync.core.SyncManager;
import org.eclipse.ptp.rdt.sync.ui.messages.Messages;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public class SyncFileFilterPage
extends ApplicationWindow
implements IWorkbenchPreferencePage {
    private static final int ERROR_DISPLAY_SECONDS = 3;
    private static final Display display = Display.getCurrent();
    private final int windowWidth;
    private final int viewHeight;
    private final IProject project;
    private final SyncFileFilter filter;
    private final FilterSaveTarget saveTarget;
    private CheckboxTreeViewer treeViewer;
    private Table patternTable;
    private Button showRemoteButton;
    private Label remoteErrorLabel;
    private Button upButton;
    private Button downButton;
    private Button removeButton;
    private Text newPath;
    private Button excludeButtonForPath;
    private Button includeButtonForPath;
    private Text newRegex;
    private Button excludeButtonForRegex;
    private Button includeButtonForRegex;
    private Label patternErrorLabel;
    private Button cancelButton;
    private Button okButton;
    private final SyncFilePreferencePage preferencePage;

    public SyncFileFilterPage() {
        this(null, true, null, null);
    }

    private SyncFileFilterPage(IProject p, boolean isPreferencePage, SyncFileFilter targetFilter, Shell parent) {
        super(parent);
        this.project = p;
        this.preferencePage = isPreferencePage ? new SyncFilePreferencePage() : null;
        if (targetFilter == null) {
            if (this.project == null) {
                this.filter = SyncManager.getDefaultFileFilter();
                this.saveTarget = FilterSaveTarget.DEFAULT;
            } else {
                this.filter = SyncManager.getFileFilter((IProject)this.project);
                this.saveTarget = FilterSaveTarget.PROJECT;
            }
        } else {
            this.filter = targetFilter;
            this.saveTarget = FilterSaveTarget.NONE;
        }
        this.windowWidth = SyncFileFilterPage.display.getBounds().width / 3;
        this.viewHeight = SyncFileFilterPage.display.getBounds().height / 5;
        this.setReturnCode(1);
    }

    public static int open(IProject p, Shell parent) {
        return new SyncFileFilterPage(p, false, null, parent).open();
    }

    public static int openBlocking(SyncFileFilter f, Shell parent) {
        SyncFileFilterPage page = new SyncFileFilterPage(null, false, f, parent);
        page.setBlockOnOpen(true);
        return page.open();
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.project == null) {
            shell.setText(Messages.SyncFileFilterPage_20);
        } else {
            shell.setText(Messages.SyncFileFilterPage_0);
        }
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gl = new GridLayout(1, false);
        gl.verticalSpacing = 20;
        composite.setLayout((Layout)gl);
        if (this.project != null) {
            Composite treeViewerComposite = new Composite(composite, 2048);
            treeViewerComposite.setLayout((Layout)new GridLayout(2, false));
            treeViewerComposite.setLayoutData((Object)new GridData(this.windowWidth, this.viewHeight));
            Label treeViewerLabel = new Label(treeViewerComposite, 0);
            treeViewerLabel.setText(Messages.SyncFileFilterPage_1);
            treeViewerLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
            this.formatAsHeader(treeViewerLabel);
            this.treeViewer = new CheckboxTreeViewer(treeViewerComposite);
            this.treeViewer.getTree().setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
            this.treeViewer.setContentProvider((IContentProvider)new SFTTreeContentProvider());
            this.treeViewer.setLabelProvider((IBaseLabelProvider)new SFTTreeLabelProvider());
            this.treeViewer.setCheckStateProvider(new ICheckStateProvider(){

                public boolean isChecked(Object element) {
                    return !SyncFileFilterPage.this.filter.shouldIgnore((IResource)element);
                }

                public boolean isGrayed(Object element) {
                    return false;
                }
            });
            this.treeViewer.addCheckStateListener(new ICheckStateListener(){

                public void checkStateChanged(CheckStateChangedEvent event) {
                    IPath path = ((IResource)event.getElement()).getProjectRelativePath();
                    if (event.getChecked()) {
                        SyncFileFilterPage.this.filter.addPattern((ResourceMatcher)new PathResourceMatcher(path), SyncFileFilter.PatternType.INCLUDE);
                    } else {
                        SyncFileFilterPage.this.filter.addPattern((ResourceMatcher)new PathResourceMatcher(path), SyncFileFilter.PatternType.EXCLUDE);
                    }
                    SyncFileFilterPage.this.update();
                }
            });
            this.treeViewer.setInput((Object)this.project);
            this.showRemoteButton = new Button(treeViewerComposite, 32);
            this.showRemoteButton.setText(Messages.SyncFileFilterPage_2);
            this.showRemoteButton.setSelection(((SFTTreeContentProvider)this.treeViewer.getContentProvider()).getShowRemoteFiles());
            this.showRemoteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    SyncFileFilterPage.this.update();
                }
            });
            this.remoteErrorLabel = new Label(treeViewerComposite, 0x1000000);
            this.remoteErrorLabel.setForeground(display.getSystemColor(4));
            this.remoteErrorLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
        }
        Composite patternTableComposite = new Composite(composite, 2048);
        patternTableComposite.setLayout((Layout)new GridLayout(2, false));
        patternTableComposite.setLayoutData((Object)new GridData(this.windowWidth, this.viewHeight));
        patternTableComposite.setLayoutData((Object)new GridData(4, 128, true, false));
        Label patternTableLabel = new Label(patternTableComposite, 0);
        patternTableLabel.setText(Messages.SyncFileFilterPage_3);
        this.formatAsHeader(patternTableLabel);
        patternTableLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 4, 1));
        this.patternTable = new Table(patternTableComposite, 2818);
        this.patternTable.setLayoutData((Object)new GridData(4, 4, true, true, 1, 3));
        new TableColumn(this.patternTable, 16384, 0);
        new TableColumn(this.patternTable, 16384, 1);
        this.upButton = new Button(patternTableComposite, 8);
        this.upButton.setText(Messages.SyncFileFilterPage_6);
        this.upButton.setLayoutData((Object)new GridData(4, 128, false, false));
        this.upButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TableItem[] selectedPatternItems = SyncFileFilterPage.this.patternTable.getSelection();
                if (selectedPatternItems.length != 1) {
                    return;
                }
                int patternIndex = SyncFileFilterPage.this.patternTable.getSelectionIndex();
                if (SyncFileFilterPage.this.filter.promote((ResourceMatcher)selectedPatternItems[0].getData())) {
                    --patternIndex;
                }
                SyncFileFilterPage.this.update();
                SyncFileFilterPage.this.patternTable.select(patternIndex);
            }
        });
        this.downButton = new Button(patternTableComposite, 8);
        this.downButton.setText(Messages.SyncFileFilterPage_7);
        this.downButton.setLayoutData((Object)new GridData(4, 128, false, false));
        this.downButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TableItem[] selectedPatternItems = SyncFileFilterPage.this.patternTable.getSelection();
                if (selectedPatternItems.length != 1) {
                    return;
                }
                int patternIndex = SyncFileFilterPage.this.patternTable.getSelectionIndex();
                if (SyncFileFilterPage.this.filter.demote((ResourceMatcher)selectedPatternItems[0].getData())) {
                    ++patternIndex;
                }
                SyncFileFilterPage.this.update();
                SyncFileFilterPage.this.patternTable.select(patternIndex);
            }
        });
        this.removeButton = new Button(patternTableComposite, 8);
        this.removeButton.setText(Messages.SyncFileFilterPage_8);
        this.removeButton.setLayoutData((Object)new GridData(4, 1024, false, false));
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TableItem[] selectedPatternItems;
                TableItem[] tableItemArray = selectedPatternItems = SyncFileFilterPage.this.patternTable.getSelection();
                int n = selectedPatternItems.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem selectedPatternItem = tableItemArray[n2];
                    ResourceMatcher selectedPattern = (ResourceMatcher)selectedPatternItem.getData();
                    SyncFileFilterPage.this.filter.removePattern(selectedPattern);
                    ++n2;
                }
                SyncFileFilterPage.this.update();
            }
        });
        Composite patternEnterComposite = new Composite(composite, 0);
        patternEnterComposite.setLayout((Layout)new GridLayout(4, false));
        patternEnterComposite.setLayoutData((Object)new GridData(4, 128, true, false));
        new Label(patternEnterComposite, 0).setText(Messages.SyncFileFilterPage_5);
        this.newPath = new Text(patternEnterComposite, 0);
        this.newPath.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.excludeButtonForPath = new Button(patternEnterComposite, 8);
        this.excludeButtonForPath.setText(Messages.SyncFileFilterPage_10);
        this.excludeButtonForPath.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.excludeButtonForPath.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SyncFileFilterPage.this.enterNewPathPattern(SyncFileFilter.PatternType.EXCLUDE);
            }
        });
        this.includeButtonForPath = new Button(patternEnterComposite, 8);
        this.includeButtonForPath.setText(Messages.SyncFileFilterPage_11);
        this.includeButtonForPath.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.includeButtonForPath.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SyncFileFilterPage.this.enterNewPathPattern(SyncFileFilter.PatternType.INCLUDE);
            }
        });
        new Label(patternEnterComposite, 0).setText(Messages.SyncFileFilterPage_9);
        this.newRegex = new Text(patternEnterComposite, 0);
        this.newRegex.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.excludeButtonForRegex = new Button(patternEnterComposite, 8);
        this.excludeButtonForRegex.setText(Messages.SyncFileFilterPage_10);
        this.excludeButtonForRegex.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.excludeButtonForRegex.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SyncFileFilterPage.this.enterNewRegexPattern(SyncFileFilter.PatternType.EXCLUDE);
            }
        });
        this.includeButtonForRegex = new Button(patternEnterComposite, 8);
        this.includeButtonForRegex.setText(Messages.SyncFileFilterPage_11);
        this.includeButtonForRegex.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.includeButtonForRegex.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SyncFileFilterPage.this.enterNewRegexPattern(SyncFileFilter.PatternType.INCLUDE);
            }
        });
        this.patternErrorLabel = new Label(patternEnterComposite, 0);
        this.patternErrorLabel.setForeground(display.getSystemColor(4));
        this.patternErrorLabel.setLayoutData((Object)new GridData(4, 4, true, true, 4, 1));
        if (this.preferencePage == null) {
            Label horizontalLine = new Label(patternEnterComposite, 258);
            horizontalLine.setLayoutData((Object)new GridData(4, 1, true, false, 4, 1));
            new Label(patternEnterComposite, 0).setVisible(false);
            new Label(patternEnterComposite, 0).setVisible(false);
            this.cancelButton = new Button(patternEnterComposite, 8);
            this.cancelButton.setText(Messages.SyncFileFilterPage_13);
            this.cancelButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
            this.cancelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    SyncFileFilterPage.this.close();
                }
            });
            this.okButton = new Button(patternEnterComposite, 8);
            this.okButton.setText(Messages.SyncFileFilterPage_14);
            this.okButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
            this.okButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    if (SyncFileFilterPage.this.saveTarget == FilterSaveTarget.DEFAULT) {
                        SyncManager.saveDefaultFileFilter((SyncFileFilter)SyncFileFilterPage.this.filter);
                    } else if (SyncFileFilterPage.this.saveTarget == FilterSaveTarget.PROJECT) {
                        if (!$assertionsDisabled && SyncFileFilterPage.this.project == null) {
                            throw new AssertionError();
                        }
                        SyncManager.saveFileFilter((IProject)SyncFileFilterPage.this.project, (SyncFileFilter)SyncFileFilterPage.this.filter);
                    }
                    SyncFileFilterPage.this.setReturnCode(0);
                    SyncFileFilterPage.this.close();
                }
            });
        }
        this.update();
        return composite;
    }

    private void formatAsHeader(Label widget) {
        FontData[] fontData;
        FontData[] fontDataArray = fontData = widget.getFont().getFontData();
        int n = fontData.length;
        int n2 = 0;
        while (n2 < n) {
            FontData data = fontDataArray[n2];
            data.setStyle(1);
            ++n2;
        }
        final Font newFont = new Font((Device)display, fontData);
        widget.setFont(newFont);
        widget.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                newFont.dispose();
            }
        });
    }

    private void enterNewPathPattern(SyncFileFilter.PatternType type) {
        String pattern = this.newPath.getText();
        if (pattern.isEmpty()) {
            return;
        }
        PathResourceMatcher matcher = null;
        matcher = new PathResourceMatcher((IPath)new Path(pattern));
        this.filter.addPattern((ResourceMatcher)matcher, type);
        this.newPath.setText("");
        this.update();
    }

    private void enterNewRegexPattern(SyncFileFilter.PatternType type) {
        String pattern = this.newRegex.getText();
        if (pattern.isEmpty()) {
            return;
        }
        RegexResourceMatcher matcher = null;
        try {
            matcher = new RegexResourceMatcher(pattern);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            this.patternErrorLabel.setText(Messages.SyncFileFilterPage_15);
            display.timerExec(3000, new Runnable(){

                @Override
                public void run() {
                    if (SyncFileFilterPage.this.patternErrorLabel.isDisposed()) {
                        return;
                    }
                    SyncFileFilterPage.this.patternErrorLabel.setText("");
                }
            });
            return;
        }
        this.filter.addPattern((ResourceMatcher)matcher, type);
        this.newRegex.setText("");
        this.update();
    }

    private void update() {
        this.patternTable.removeAll();
        ResourceMatcher[] resourceMatcherArray = this.filter.getPatterns();
        int n = resourceMatcherArray.length;
        int n2 = 0;
        while (n2 < n) {
            ResourceMatcher pattern = resourceMatcherArray[n2];
            TableItem ti = new TableItem(this.patternTable, 16384);
            ti.setData((Object)pattern);
            String[] tableValues = new String[2];
            String patternType = this.filter.getPatternType(pattern) == SyncFileFilter.PatternType.EXCLUDE ? Messages.SyncFileFilterPage_21 : Messages.SyncFileFilterPage_22;
            if (pattern instanceof PathResourceMatcher) {
                patternType = String.valueOf(patternType) + " " + Messages.SyncFileFilterPage_16;
            } else if (pattern instanceof RegexResourceMatcher) {
                patternType = String.valueOf(patternType) + " " + Messages.SyncFileFilterPage_17;
            }
            tableValues[0] = patternType = String.valueOf(patternType) + ":  ";
            tableValues[1] = pattern.toString();
            ti.setText(tableValues);
            FontData currentFontData = ti.getFont().getFontData()[0];
            Font italicizedFont = new Font((Device)display, new FontData(currentFontData.getName(), currentFontData.getHeight(), 2));
            ti.setFont(1, italicizedFont);
            ++n2;
        }
        this.patternTable.getColumn(0).pack();
        this.patternTable.getColumn(1).pack();
        if (this.project != null) {
            boolean showRemote = this.showRemoteButton.getSelection();
            if (showRemote) {
                if (!((SFTTreeContentProvider)this.treeViewer.getContentProvider()).isConnected()) {
                    showRemote = false;
                    this.remoteErrorLabel.setText(Messages.SyncFileFilterPage_19);
                } else {
                    this.remoteErrorLabel.setText("");
                }
            }
            this.showRemoteButton.setSelection(showRemote);
            ((SFTTreeContentProvider)this.treeViewer.getContentProvider()).setShowRemoteFiles(showRemote);
            this.treeViewer.refresh();
        }
    }

    public Point computeSize() {
        return this.preferencePage.computeSize();
    }

    public boolean isValid() {
        return this.preferencePage.isValid();
    }

    public boolean okToLeave() {
        return this.preferencePage.okToLeave();
    }

    public boolean performCancel() {
        return this.preferencePage.performCancel();
    }

    public boolean performOk() {
        return this.preferencePage.performOk();
    }

    public void setContainer(IPreferencePageContainer preferencePageContainer) {
        this.preferencePage.setContainer(preferencePageContainer);
    }

    public void setSize(Point size) {
        this.preferencePage.setSize(size);
    }

    public void createControl(Composite parent) {
        this.preferencePage.createControl(parent);
    }

    public void dispose() {
        this.preferencePage.dispose();
    }

    public Control getControl() {
        return this.preferencePage.getControl();
    }

    public String getDescription() {
        return this.preferencePage.getDescription();
    }

    public String getErrorMessage() {
        return this.preferencePage.getErrorMessage();
    }

    public Image getImage() {
        return this.preferencePage.getImage();
    }

    public String getMessage() {
        return this.preferencePage.getMessage();
    }

    public String getTitle() {
        return this.preferencePage.getTitle();
    }

    public void performHelp() {
        this.preferencePage.performHelp();
    }

    public void setDescription(String description) {
        this.preferencePage.setDescription(description);
    }

    public void setImageDescriptor(ImageDescriptor image) {
        this.preferencePage.setImageDescriptor(image);
    }

    public void setTitle(String title) {
        this.preferencePage.setTitle(title);
    }

    public void setVisible(boolean visible) {
        this.preferencePage.setVisible(visible);
    }

    public void init(IWorkbench workbench) {
        this.preferencePage.init(workbench);
    }

    private static enum FilterSaveTarget {
        NONE,
        DEFAULT,
        PROJECT;

    }

    private class SFTTreeContentProvider
    implements ITreeContentProvider {
        private final RemoteContentProvider remoteFiles;
        private boolean showRemoteFiles = false;

        public SFTTreeContentProvider() {
            IConfiguration bconf = ManagedBuildManager.getBuildInfo((IResource)SyncFileFilterPage.this.project).getDefaultConfiguration();
            BuildScenario bs = BuildConfigurationManager.getInstance().getBuildScenarioForBuildConfiguration(bconf);
            if (bs == null) {
                this.remoteFiles = null;
            } else {
                RemoteContentProvider tmpRCP;
                try {
                    tmpRCP = new RemoteContentProvider(bs.getRemoteConnection(), (IPath)new Path(bs.getLocation(SyncFileFilterPage.this.project)), SyncFileFilterPage.this.project);
                }
                catch (MissingConnectionException missingConnectionException) {
                    tmpRCP = null;
                }
                this.remoteFiles = tmpRCP;
            }
        }

        public boolean getShowRemoteFiles() {
            return this.showRemoteFiles;
        }

        public void setShowRemoteFiles(boolean b) {
            this.showRemoteFiles = b;
        }

        public Object[] getChildren(Object element) {
            ArrayList<IResource> children = new ArrayList<IResource>();
            if (element instanceof IFolder) {
                int n;
                int n2;
                Object[] objectArray;
                block7: {
                    if (((IFolder)element).isAccessible()) {
                        try {
                            objectArray = ((IFolder)element).members();
                            n2 = objectArray.length;
                            n = 0;
                            while (n < n2) {
                                IResource localChild = objectArray[n];
                                children.add(localChild);
                                ++n;
                            }
                        }
                        catch (CoreException coreException) {
                            if ($assertionsDisabled) break block7;
                            throw new AssertionError();
                        }
                    }
                }
                if (this.showRemoteFiles && this.remoteFiles != null) {
                    objectArray = this.remoteFiles.getChildren(element);
                    n2 = objectArray.length;
                    n = 0;
                    while (n < n2) {
                        IResource remoteChild = objectArray[n];
                        this.addUniqueResource(children, remoteChild);
                        ++n;
                    }
                }
            }
            return children.toArray();
        }

        public Object getParent(Object element) {
            return ((IResource)element).getParent();
        }

        public boolean hasChildren(Object element) {
            Object[] obj = this.getChildren(element);
            return obj == null ? false : obj.length > 0;
        }

        public Object[] getElements(Object element) {
            ArrayList<IResource> children = new ArrayList<IResource>();
            if (element instanceof IProject && ((IProject)element).isAccessible()) {
                int n;
                int n2;
                Object[] objectArray;
                block6: {
                    try {
                        objectArray = ((IProject)element).members();
                        n2 = objectArray.length;
                        n = 0;
                        while (n < n2) {
                            IResource localChild = objectArray[n];
                            children.add(localChild);
                            ++n;
                        }
                    }
                    catch (CoreException coreException) {
                        if ($assertionsDisabled) break block6;
                        throw new AssertionError();
                    }
                }
                if (this.showRemoteFiles && this.remoteFiles != null) {
                    objectArray = this.remoteFiles.getElements(element);
                    n2 = objectArray.length;
                    n = 0;
                    while (n < n2) {
                        IResource remoteChild = objectArray[n];
                        this.addUniqueResource(children, remoteChild);
                        ++n;
                    }
                }
            }
            return children.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer element, Object arg1, Object arg2) {
        }

        private boolean addUniqueResource(Collection<IResource> resList, IResource newRes) {
            for (IResource res : resList) {
                if (!res.getProjectRelativePath().equals((Object)newRes.getProjectRelativePath())) continue;
                return false;
            }
            resList.add(newRes);
            return true;
        }

        public boolean isConnected() {
            if (this.remoteFiles == null) {
                return false;
            }
            return this.remoteFiles.isOpen();
        }
    }

    private class SFTTreeLabelProvider
    implements ILabelProvider {
        private final Image folderImage = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
        private final Image fileImage = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FILE");

        private SFTTreeLabelProvider() {
        }

        public Image getImage(Object element) {
            if (element instanceof IFolder) {
                return this.folderImage;
            }
            return this.fileImage;
        }

        public String getText(Object element) {
            return ((IResource)element).getName();
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String arg1) {
            return false;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    public class SyncFilePreferencePage
    extends PreferencePage
    implements IWorkbenchPreferencePage {
        protected Control createContents(Composite parent) {
            return SyncFileFilterPage.this.createContents(parent);
        }

        public boolean performOk() {
            SyncManager.saveDefaultFileFilter((SyncFileFilter)SyncFileFilterPage.this.filter);
            return true;
        }

        public void init(IWorkbench workbench) {
        }
    }
}

