/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rdt.sync.ui.properties;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICResourceDescription;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IMultiConfiguration;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.core.MultiConfiguration;
import org.eclipse.cdt.managedbuilder.ui.properties.AbstractSingleBuildPage;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.ptp.rdt.sync.core.BuildConfigurationManager;
import org.eclipse.ptp.rdt.sync.core.BuildScenario;
import org.eclipse.ptp.rdt.sync.core.MissingConnectionException;
import org.eclipse.ptp.rdt.sync.core.SyncManager;
import org.eclipse.ptp.rdt.sync.ui.RDTSyncUIPlugin;
import org.eclipse.ptp.rdt.sync.ui.messages.Messages;
import org.eclipse.ptp.remote.core.IRemoteConnection;
import org.eclipse.ptp.remote.core.IRemoteFileManager;
import org.eclipse.ptp.remote.core.IRemoteServices;
import org.eclipse.ptp.remote.core.PTPRemoteCorePlugin;
import org.eclipse.ptp.remote.ui.IRemoteUIConnectionManager;
import org.eclipse.ptp.remote.ui.IRemoteUIFileManager;
import org.eclipse.ptp.remote.ui.IRemoteUIServices;
import org.eclipse.ptp.remote.ui.PTPRemoteUIPlugin;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.statushandlers.StatusManager;

public class BuildRemotePropertiesPage
extends AbstractSingleBuildPage {
    private IRemoteConnection fSelectedConnection = null;
    private IRemoteServices fSelectedProvider = null;
    private IConfiguration fConfigBeforeSwitch = null;
    private boolean fWidgetsReady = false;
    private final Map<Integer, IRemoteServices> fComboIndexToRemoteServicesProviderMap = new HashMap<Integer, IRemoteServices>();
    private final Map<IRemoteServices, Integer> fComboRemoteServicesProviderToIndexMap = new HashMap<IRemoteServices, Integer>();
    private final Map<Integer, IRemoteConnection> fComboIndexToRemoteConnectionMap = new HashMap<Integer, IRemoteConnection>();
    private final Map<IRemoteConnection, Integer> fComboRemoteConnectionToIndexMap = new HashMap<IRemoteConnection, Integer>();
    private final Map<String, PageSettings> fConfigToPageSettings = new HashMap<String, PageSettings>();
    private Button fSyncToggleButton;
    private Button fBrowseButton;
    private Button fNewConnectionButton;
    private Combo fProviderCombo;
    private Combo fConnectionCombo;
    private Text fRootLocationText;
    private Composite composite;

    public void createWidgets(Composite parent) {
        this.composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        this.composite.setLayout((Layout)layout);
        GridData gd = new GridData(4, 4, true, true);
        this.composite.setLayoutData((Object)gd);
        this.fSyncToggleButton = new Button(this.composite, 32);
        this.fSyncToggleButton.setText(Messages.BuildRemotePropertiesPage_0);
        this.fSyncToggleButton.setLayoutData((Object)new GridData(16384, 4, false, false, 3, 1));
        this.fSyncToggleButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                BuildRemotePropertiesPage.this.setEnabledForAllWidgets(BuildRemotePropertiesPage.this.fSyncToggleButton.getSelection());
                BuildRemotePropertiesPage.this.update();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                BuildRemotePropertiesPage.this.setEnabledForAllWidgets(BuildRemotePropertiesPage.this.fSyncToggleButton.getSelection());
                BuildRemotePropertiesPage.this.update();
            }
        });
        Label providerLabel = new Label(this.composite, 16384);
        providerLabel.setText(Messages.BRPPage_RemoteProviderLabel);
        this.fProviderCombo = new Combo(this.composite, 12);
        gd = new GridData(1, 1, false, false);
        gd.horizontalSpan = 2;
        this.fProviderCombo.setLayoutData((Object)gd);
        this.fProviderCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BuildRemotePropertiesPage.this.handleServicesSelected();
            }
        });
        Label connectionLabel = new Label(this.composite, 16384);
        connectionLabel.setText(Messages.BRPPage_ConnectionLabel);
        this.fConnectionCombo = new Combo(this.composite, 12);
        this.fConnectionCombo.setLayoutData((Object)new GridData(4, 4, true, false));
        this.fConnectionCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BuildRemotePropertiesPage.this.handleConnectionSelected();
            }
        });
        this.fNewConnectionButton = new Button(this.composite, 8);
        this.fNewConnectionButton.setText(Messages.BRPPage_ConnectionButton);
        this.fNewConnectionButton.setEnabled(false);
        this.fNewConnectionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IRemoteUIConnectionManager connectionManager = BuildRemotePropertiesPage.this.getUIConnectionManager();
                if (connectionManager != null) {
                    connectionManager.newConnection(BuildRemotePropertiesPage.this.fNewConnectionButton.getShell());
                }
                BuildRemotePropertiesPage.this.populateConnectionCombo(BuildRemotePropertiesPage.this.fConnectionCombo);
                BuildRemotePropertiesPage.this.update();
            }
        });
        Label rootLocationLabel = new Label(this.composite, 16384);
        rootLocationLabel.setText(Messages.BRPPage_RootLocation);
        this.fRootLocationText = new Text(this.composite, 2052);
        gd = new GridData(768);
        gd.horizontalSpan = 1;
        gd.grabExcessHorizontalSpace = true;
        gd.widthHint = 250;
        this.fRootLocationText.setLayoutData((Object)gd);
        this.fRootLocationText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BuildRemotePropertiesPage.this.update();
            }
        });
        this.fBrowseButton = new Button(this.composite, 8);
        this.fBrowseButton.setText(Messages.BRPPage_BrowseButton);
        this.fBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (BuildRemotePropertiesPage.this.fSelectedConnection != null) {
                    IRemoteUIFileManager fileMgr;
                    IRemoteUIServices remoteUIServices;
                    BuildRemotePropertiesPage.this.checkConnection();
                    if (BuildRemotePropertiesPage.this.fSelectedConnection.isOpen() && (remoteUIServices = PTPRemoteUIPlugin.getDefault().getRemoteUIServices(BuildRemotePropertiesPage.this.fSelectedProvider)) != null && (fileMgr = remoteUIServices.getUIFileManager()) != null) {
                        fileMgr.setConnection(BuildRemotePropertiesPage.this.fSelectedConnection);
                        String correctPath = BuildRemotePropertiesPage.this.fRootLocationText.getText();
                        String selectedPath = fileMgr.browseDirectory(BuildRemotePropertiesPage.this.fRootLocationText.getShell(), "Project Location (" + BuildRemotePropertiesPage.this.fSelectedConnection.getName() + ")", correctPath, 0);
                        if (selectedPath != null) {
                            BuildRemotePropertiesPage.this.fRootLocationText.setText(selectedPath);
                        }
                    }
                }
            }
        });
        this.fConfigBeforeSwitch = this.getCfg();
        this.setValues(this.getCfg());
        this.fWidgetsReady = true;
    }

    private void handleConnectionSelected() {
        int selectionIndex = this.fConnectionCombo.getSelectionIndex();
        this.fSelectedConnection = this.fComboIndexToRemoteConnectionMap.get(selectionIndex);
        this.update();
    }

    private void handleServicesSelected() {
        int selectionIndex = this.fProviderCombo.getSelectionIndex();
        this.fSelectedProvider = this.fComboIndexToRemoteServicesProviderMap.get(selectionIndex);
        this.populateConnectionCombo(this.fConnectionCombo);
        this.update();
    }

    private void populateConnectionCombo(Combo connectionCombo) {
        this.fSelectedConnection = null;
        connectionCombo.removeAll();
        IRemoteConnection[] connections = this.fSelectedProvider.getConnectionManager().getConnections();
        int k = 0;
        while (k < connections.length) {
            connectionCombo.add(connections[k].getName(), k);
            this.fComboIndexToRemoteConnectionMap.put(k, connections[k]);
            this.fComboRemoteConnectionToIndexMap.put(connections[k], k);
            ++k;
        }
    }

    private void populateRemoteProviderCombo(Combo providerCombo) {
        providerCombo.removeAll();
        IRemoteServices[] providers = PTPRemoteUIPlugin.getDefault().getRemoteServices(null);
        int k = 0;
        while (k < providers.length) {
            providerCombo.add(providers[k].getName(), k);
            this.fComboIndexToRemoteServicesProviderMap.put(k, providers[k]);
            this.fComboRemoteServicesProviderToIndexMap.put(providers[k], k);
            ++k;
        }
    }

    private boolean isConnectionManagerAvailable() {
        IRemoteUIConnectionManager connectionManager = this.getUIConnectionManager();
        return connectionManager != null;
    }

    public boolean performOk() {
        boolean syncAutoSetting = SyncManager.getSyncAuto();
        SyncManager.setSyncAuto((boolean)false);
        try {
            super.performOk();
            if (!this.fWidgetsReady) {
                return true;
            }
            this.storeSettings(this.fConfigBeforeSwitch);
            IProject project = this.getProject();
            ICConfigurationDescription[] iCConfigurationDescriptionArray = this.getCfgsReadOnly(project);
            int n = iCConfigurationDescriptionArray.length;
            int n2 = 0;
            while (n2 < n) {
                ICConfigurationDescription desc = iCConfigurationDescriptionArray[n2];
                IConfiguration config = this.getCfg(desc);
                if (config != null && !(config instanceof MultiConfiguration)) {
                    PageSettings systemSettings;
                    BuildConfigurationManager bcm = BuildConfigurationManager.getInstance();
                    PageSettings settings = this.fConfigToPageSettings.get(config.getId());
                    if (settings != null && !settings.equals(systemSettings = this.loadSettings(config))) {
                        this.saveConfig(config, settings);
                        if (systemSettings == null || settings.syncProvider != systemSettings.syncProvider) {
                            if (settings.syncProvider == null) {
                                bcm.modifyConfigurationAsSyncLocal(config);
                                try {
                                    BuildScenario localBuildScenario = bcm.createLocalBuildScenario(project);
                                    bcm.setBuildScenarioForBuildConfiguration(localBuildScenario, config);
                                }
                                catch (CoreException e) {
                                    RDTSyncUIPlugin.log(Messages.BuildRemotePropertiesPage_2, e);
                                }
                            } else {
                                bcm.modifyConfigurationAsSyncRemote(config);
                            }
                        }
                    }
                }
                ++n2;
            }
        }
        finally {
            SyncManager.setSyncAuto((boolean)syncAutoSetting);
        }
        return true;
    }

    private void saveConfig(IConfiguration config, PageSettings settings) {
        IProject project = config.getOwner().getProject();
        ManagedBuildManager.saveBuildInfo((IProject)project, (boolean)true);
        BuildConfigurationManager bcm = BuildConfigurationManager.getInstance();
        BuildScenario buildScenario = new BuildScenario(settings.syncProvider, settings.connection, settings.rootLocation);
        bcm.setBuildScenarioForBuildConfiguration(buildScenario, config);
    }

    private void checkConnection() {
        IRemoteUIConnectionManager mgr = this.getUIConnectionManager();
        if (mgr != null) {
            mgr.openConnectionWithProgress(this.fConnectionCombo.getShell(), null, this.fSelectedConnection);
        }
    }

    private IRemoteUIConnectionManager getUIConnectionManager() {
        if (this.fSelectedProvider == null) {
            return null;
        }
        IRemoteUIConnectionManager connectionManager = PTPRemoteUIPlugin.getDefault().getRemoteUIServices(this.fSelectedProvider).getUIConnectionManager();
        return connectionManager;
    }

    private void setValues(IConfiguration config) {
        Integer index;
        if (config instanceof IMultiConfiguration) {
            this.composite.setEnabled(false);
            return;
        }
        this.composite.setEnabled(true);
        this.populateRemoteProviderCombo(this.fProviderCombo);
        PageSettings settings = this.fConfigToPageSettings.get(this.getCfg().getId());
        if (settings == null) {
            settings = this.loadSettings(this.getCfg());
            if (settings == null) {
                return;
            }
            this.fConfigToPageSettings.put(this.getCfg().getId(), settings);
        }
        if (settings.syncProvider != null) {
            this.fSyncToggleButton.setSelection(true);
            this.setEnabledForAllWidgets(true);
        } else {
            this.fSyncToggleButton.setSelection(false);
            this.setEnabledForAllWidgets(false);
        }
        this.fProviderCombo.select(this.fComboRemoteServicesProviderToIndexMap.get(settings.remoteProvider).intValue());
        this.handleServicesSelected();
        if (settings.connection != null && (index = this.fComboRemoteConnectionToIndexMap.get(settings.connection)) != null) {
            this.fConnectionCombo.select(index.intValue());
        }
        this.handleConnectionSelected();
        this.fRootLocationText.setText(settings.rootLocation);
    }

    private void setEnabledForAllWidgets(boolean shouldBeEnabled) {
        this.fProviderCombo.setEnabled(shouldBeEnabled);
        this.fConnectionCombo.setEnabled(shouldBeEnabled);
        this.fRootLocationText.setEnabled(shouldBeEnabled);
        this.fBrowseButton.setEnabled(shouldBeEnabled);
        if (shouldBeEnabled && this.isConnectionManagerAvailable()) {
            this.fNewConnectionButton.setEnabled(true);
        } else {
            this.fNewConnectionButton.setEnabled(false);
        }
    }

    protected void cfgChanged(ICConfigurationDescription cfg) {
        super.cfgChanged(cfg);
        if (!this.fWidgetsReady) {
            return;
        }
        this.storeSettings(this.fConfigBeforeSwitch);
        this.fConfigBeforeSwitch = this.getCfg();
        this.setValues(this.getCfg());
    }

    protected void performApply(ICResourceDescription src, ICResourceDescription dst) {
        this.performOk();
    }

    private PageSettings loadSettings(IConfiguration config) {
        BuildScenario buildScenario = BuildConfigurationManager.getInstance().getBuildScenarioForBuildConfiguration(config);
        if (buildScenario == null) {
            Status status = new Status(4, "org.eclipse.ptp.rdt.sync.ui", "Error loading configuration data");
            StatusManager.getManager().handle((IStatus)status, 2);
            return null;
        }
        PageSettings settings = new PageSettings();
        settings.syncProvider = buildScenario.getSyncProvider();
        settings.remoteProvider = buildScenario.getRemoteProvider();
        try {
            settings.connection = buildScenario.getRemoteConnection();
        }
        catch (MissingConnectionException missingConnectionException) {}
        IProject project = config.getOwner().getProject();
        settings.rootLocation = buildScenario.getLocation(project);
        return settings;
    }

    private void storeSettings(IConfiguration config) {
        if (config == null || config instanceof MultiConfiguration) {
            return;
        }
        IProject project = config.getOwner().getProject();
        PageSettings settings = new PageSettings();
        Integer remoteServicesIndex = this.fProviderCombo.getSelectionIndex();
        Integer connectionIndex = this.fConnectionCombo.getSelectionIndex();
        settings.syncProvider = this.fSyncToggleButton.getSelection() ? BuildConfigurationManager.getInstance().getProjectSyncProvider(project) : null;
        settings.remoteProvider = this.fComboIndexToRemoteServicesProviderMap.get(remoteServicesIndex);
        settings.connection = this.fComboIndexToRemoteConnectionMap.get(connectionIndex);
        settings.rootLocation = this.fRootLocationText.getText();
        this.fConfigToPageSettings.put(config.getId(), settings);
    }

    public void performDefaults() {
        if (!this.fWidgetsReady) {
            return;
        }
        PageSettings settings = this.loadSettings(this.getCfg());
        this.fConfigToPageSettings.put(this.getCfg().getId(), settings);
        this.setValues(this.getCfg());
    }

    private void update() {
        this.getContainer().updateMessage();
        this.getContainer().updateButtons();
        this.updateApplyButton();
        this.enableConfigSelection(this.isValid());
    }

    public String getErrorMessage() {
        if (super.getErrorMessage() != null) {
            return super.getErrorMessage();
        }
        if (this.fSelectedProvider == null) {
            return Messages.GitParticipant_0;
        }
        if (this.fSelectedConnection == null) {
            return Messages.GitParticipant_1;
        }
        if (this.fRootLocationText.getText().length() == 0) {
            return Messages.GitParticipant_2;
        }
        IRemoteFileManager fileManager = this.fSelectedProvider.getFileManager(this.fSelectedConnection);
        if (fileManager.toURI(this.fRootLocationText.getText()) == null) {
            return Messages.GitParticipant_3;
        }
        if (this.fSyncToggleButton.getSelection() && this.locationIsInWorkspace()) {
            return Messages.BuildRemotePropertiesPage_1;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean locationIsInWorkspace() {
        IRemoteServices localService = PTPRemoteCorePlugin.getDefault().getRemoteServices("org.eclipse.ptp.remote.LocalServices", null);
        if (localService == null) return false;
        IRemoteConnection localConnection = localService.getConnectionManager().getConnection("Local");
        if (localConnection == null) return false;
        if (this.fSelectedConnection != localConnection) {
            return false;
        }
        IProject project = this.getCfg().getOwner().getProject();
        Path locationPath = new Path(this.fRootLocationText.getText());
        return project.getLocation().isPrefixOf((IPath)locationPath);
    }

    public boolean isValid() {
        return super.isValid() && this.getErrorMessage() == null;
    }

    private static class PageSettings {
        String syncProvider;
        IRemoteConnection connection;
        IRemoteServices remoteProvider;
        String rootLocation;

        private PageSettings() {
        }

        public boolean equals(PageSettings otherSettings) {
            if (otherSettings == null) {
                return false;
            }
            if (this.syncProvider != otherSettings.syncProvider) {
                return false;
            }
            if (this.connection != otherSettings.connection) {
                return false;
            }
            if (this.remoteProvider != otherSettings.remoteProvider) {
                return false;
            }
            return this.rootLocation.equals(otherSettings.rootLocation);
        }
    }
}

