/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.jaxb.control.ui.dialogs;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.ptp.rm.jaxb.control.ui.messages.Messages;
import org.eclipse.ptp.rm.jaxb.ui.util.WidgetBuilderUtils;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ScrollingEditableMessageDialog
extends MessageDialog {
    public static final int DEFAULT_INDEX = 0;
    public static final String[] DEFAULT_LABELS = new String[]{Messages.DialogClose};
    protected Button okButton;
    protected boolean readOnly;
    protected Text scrollable;
    protected String title;
    protected String value;

    public ScrollingEditableMessageDialog(Shell parentShell, String name, String value) {
        this(parentShell, name, value, false);
    }

    public ScrollingEditableMessageDialog(Shell parentShell, String name, String value, boolean readOnly) {
        this(parentShell, name, value, name, null, 0, DEFAULT_LABELS, 0);
        this.readOnly = readOnly;
    }

    public ScrollingEditableMessageDialog(Shell parentShell, String name, String value, String dialogTitle, Image dialogTitleImage, int dialogImageType, String[] dialogButtonLabels, int defaultIndex) {
        super(parentShell, dialogTitle, dialogTitleImage, name, dialogImageType, dialogButtonLabels, defaultIndex);
        this.value = value;
        this.readOnly = false;
    }

    public String getValue() {
        return this.value;
    }

    public int open() {
        this.createDialogArea((Composite)this.getParentShell());
        return super.open();
    }

    protected void buttonPressed(int buttonId) {
        this.value = buttonId == 0 ? this.scrollable.getText() : null;
        super.buttonPressed(buttonId);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.title != null) {
            shell.setText(this.title);
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        if (!this.readOnly) {
            this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        }
        this.scrollable.setFocus();
        if (this.value != null) {
            this.scrollable.setText(this.value);
            this.scrollable.selectAll();
        }
    }

    protected Control createDialogArea(Composite parent) {
        Control c = super.createDialogArea(parent);
        GridData data = WidgetBuilderUtils.createGridDataFill((Integer)this.convertWidthInCharsToPixels(160), (Integer)550, (Integer)1);
        this.scrollable = WidgetBuilderUtils.createText((Composite)parent, (Integer)2882, (Object)data, (Boolean)this.readOnly, null);
        WidgetBuilderUtils.applyMonospace((Text)this.scrollable);
        return c;
    }
}

