/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.jaxb.control.ui.launch;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.ptp.ems.core.IEnvManager;
import org.eclipse.ptp.ems.ui.LazyEnvManagerDetector;
import org.eclipse.ptp.launch.ui.extensions.RMLaunchValidation;
import org.eclipse.ptp.remote.core.IRemoteConnection;
import org.eclipse.ptp.remote.core.IRemoteConnectionManager;
import org.eclipse.ptp.remote.core.IRemoteServices;
import org.eclipse.ptp.remote.core.PTPRemoteCorePlugin;
import org.eclipse.ptp.remote.core.RemoteServicesDelegate;
import org.eclipse.ptp.rm.jaxb.control.IJobController;
import org.eclipse.ptp.rm.jaxb.control.ui.IUpdateModelEnabled;
import org.eclipse.ptp.rm.jaxb.control.ui.handlers.ValueUpdateHandler;
import org.eclipse.ptp.rm.jaxb.control.ui.launch.AbstractJAXBLaunchConfigurationTab;
import org.eclipse.ptp.rm.jaxb.control.ui.launch.ExtensibleJAXBControllerTab;
import org.eclipse.ptp.rm.jaxb.control.ui.launch.IJAXBParentLaunchConfigurationTab;
import org.eclipse.ptp.rm.jaxb.control.ui.launch.JAXBDynamicLaunchConfigurationTab;
import org.eclipse.ptp.rm.jaxb.control.ui.launch.JAXBImportedScriptLaunchConfigurationTab;
import org.eclipse.ptp.rm.jaxb.control.ui.messages.Messages;
import org.eclipse.ptp.rm.jaxb.control.ui.utils.WidgetActionUtils;
import org.eclipse.ptp.rm.jaxb.control.ui.variables.LCVariableMap;
import org.eclipse.ptp.rm.jaxb.core.data.LaunchTabType;
import org.eclipse.ptp.rm.jaxb.core.data.ResourceManagerData;
import org.eclipse.ptp.rm.jaxb.core.data.ScriptType;
import org.eclipse.ptp.rm.jaxb.core.data.TabControllerType;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class JAXBControllerLaunchConfigurationTab
extends ExtensibleJAXBControllerTab
implements IJAXBParentLaunchConfigurationTab,
IUpdateModelEnabled,
SelectionListener {
    private RemoteServicesDelegate delegate;
    private final IJobController fControl;
    private final LaunchTabType launchTabData;
    private final ValueUpdateHandler updateHandler;
    private final LCVariableMap lcMap;
    private ScriptType script;

    public JAXBControllerLaunchConfigurationTab(IJobController control, IProgressMonitor monitor) throws Throwable {
        this.setProgressMonitor(monitor);
        this.fControl = control;
        LCVariableMap varMap = null;
        try {
            ResourceManagerData data = control.getConfiguration();
            if (data == null) {
                throw new Throwable(Messages.JAXBControllerLaunchConfigurationTab_unableToObtainConfigurationInfo);
            }
            this.script = data.getControlData().getScript();
            IRemoteConnection conn = this.getConnection(this.fControl);
            if (conn == null) {
                throw new Throwable(Messages.JAXBControllerLaunchConfigurationTab_unableToObtainConnectionInfo);
            }
            varMap = new LCVariableMap();
            varMap.setEnvManager(this.getEnvManager(control, monitor));
            this.voidRMConfig = false;
        }
        catch (Throwable t) {
            this.script = null;
            this.voidRMConfig = true;
            WidgetActionUtils.errorMessage(Display.getDefault().getActiveShell(), t, Messages.VoidLaunchTabMessage, Messages.VoidLaunchTabTitle, false);
        }
        if (!this.voidRMConfig) {
            this.launchTabData = control.getConfiguration().getControlData().getLaunchTab();
            this.updateHandler = new ValueUpdateHandler(this);
            if (this.launchTabData != null) {
                List dynamic = this.launchTabData.getDynamic();
                for (TabControllerType controller : dynamic) {
                    this.addDynamicTab(new JAXBDynamicLaunchConfigurationTab(control, controller, this, monitor));
                }
                LaunchTabType.Import importTab = this.launchTabData.getImport();
                if (importTab != null) {
                    this.addDynamicTab(new JAXBImportedScriptLaunchConfigurationTab(control, importTab, (IJAXBParentLaunchConfigurationTab)this, monitor));
                }
            }
            varMap = new LCVariableMap();
            varMap.setEnvManager(this.getEnvManager(control, monitor));
        } else {
            this.getControllers().clear();
            this.launchTabData = null;
            this.updateHandler = null;
        }
        this.lcMap = varMap;
    }

    private IEnvManager getEnvManager(IJobController control, IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
        LazyEnvManagerDetector envMgr = new LazyEnvManagerDetector(this.getConnection(control));
        envMgr.setProgressMonitor((IProgressMonitor)progress.newChild(10));
        return envMgr;
    }

    private IRemoteConnection getConnection(IJobController control) {
        IRemoteConnectionManager connMgr;
        IRemoteServices remoteServices = PTPRemoteCorePlugin.getDefault().getRemoteServices(control.getRemoteServicesId(), this.getProgressMonitor());
        if (remoteServices != null && (connMgr = remoteServices.getConnectionManager()) != null) {
            return connMgr.getConnection(control.getConnectionName());
        }
        return null;
    }

    public void createControl(Composite parent, String id) throws CoreException {
        if (!this.voidRMConfig) {
            this.updateHandler.clear();
        }
        super.createControl(parent, id);
        if (this.tabFolder != null) {
            this.tabFolder.addSelectionListener((SelectionListener)this);
        }
    }

    public void fireContentsChanged() {
        super.fireContentsChanged();
    }

    public RemoteServicesDelegate getRemoteServicesDelegate() {
        return this.delegate;
    }

    public LaunchTabType getLaunchTabData() {
        return this.launchTabData;
    }

    public LCVariableMap getVariableMap() {
        return this.lcMap;
    }

    public IJobController getJobControl() {
        return this.fControl;
    }

    public ScriptType getScript() {
        return this.script;
    }

    public ValueUpdateHandler getUpdateHandler() {
        return this.updateHandler;
    }

    public boolean hasScript() {
        return this.script != null;
    }

    public RMLaunchValidation initializeFrom(ILaunchConfiguration configuration) {
        if (!this.voidRMConfig) {
            try {
                this.lcMap.initialize(this.fControl.getEnvironment(), this.fControl.getControlId());
                this.updateHandler.clear();
                this.lcMap.updateFromConfiguration(configuration);
                this.delegate = RemoteServicesDelegate.getDelegate((String)this.fControl.getRemoteServicesId(), (String)this.fControl.getConnectionName(), (IProgressMonitor)this.getProgressMonitor());
            }
            catch (CoreException e) {
                return new RMLaunchValidation(false, e.getLocalizedMessage());
            }
            catch (Throwable e) {
                return new RMLaunchValidation(false, e.getLocalizedMessage());
            }
            if (this.delegate.getRemoteConnection() == null) {
                return new RMLaunchValidation(false, Messages.UninitializedRemoteServices);
            }
        }
        RMLaunchValidation validation = super.initializeFrom(configuration);
        if (!this.getControllers().isEmpty()) {
            this.tabFolder.setSelection(this.lastIndex);
            this.setVisibleOnSelected();
        }
        return validation;
    }

    public void relink() {
        AbstractJAXBLaunchConfigurationTab t = this.getControllers().get(this.tabFolder.getSelectionIndex());
        this.lcMap.relinkHidden(t.getControllerTag());
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.setVisibleOnSelected();
    }

    public void widgetSelected(SelectionEvent e) {
        this.setVisibleOnSelected();
    }

    private void setVisibleOnSelected() {
        this.lastIndex = this.tabFolder.getSelectionIndex();
        AbstractJAXBLaunchConfigurationTab t = this.getControllers().get(this.lastIndex);
        t.getControl().setVisible(true);
        t.setVisible();
    }
}

