/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.lml.monitor.core;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.ptp.remote.core.IRemoteConnection;
import org.eclipse.ptp.rm.lml.core.LMLManager;
import org.eclipse.ptp.rm.lml.monitor.LMLMonitorCorePlugin;
import org.eclipse.ptp.rm.lml.monitor.core.IMonitorControl;
import org.eclipse.ptp.rm.lml.monitor.core.MonitorControl;
import org.eclipse.ptp.rm.lml.monitor.core.listeners.IMonitorChangedListener;
import org.eclipse.ptp.rm.lml.monitor.core.listeners.IMonitorRefreshListener;
import org.eclipse.ptp.rm.lml.monitor.core.messages.Messages;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.progress.UIJob;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MonitorControlManager {
    private static final MonitorControlManager fInstance = new MonitorControlManager();
    private static final ListenerList fMonitorChangedListeners = new ListenerList();
    private static final ListenerList fSelectionChangedListeners = new ListenerList();
    private static final ListenerList fMonitorRefreshListeners = new ListenerList();
    private static final String MONITORS_SAVED_STATE = "monitors.xml";
    private static final String MONITORS_ATTR = "monitors";
    private static final String MONITOR_ID_ATTR = "monitor";
    private final Map<String, IMonitorControl> fMonitorControls = Collections.synchronizedMap(new HashMap());
    private final Set<IMonitorControl> fMonitorControlsToStart = new HashSet<IMonitorControl>();

    public static String generateMonitorId(String remoteServicesId, String connectionName, String monitorType) {
        String bytes = String.valueOf(remoteServicesId) + "/" + connectionName + "/" + monitorType;
        return UUID.nameUUIDFromBytes(bytes.getBytes()).toString();
    }

    public static MonitorControlManager getInstance() {
        return fInstance;
    }

    private MonitorControlManager() {
    }

    public void addMonitorChangedListener(IMonitorChangedListener listener) {
        fMonitorChangedListeners.add((Object)listener);
    }

    public void addMonitorRefreshListener(IMonitorChangedListener listener) {
        fMonitorRefreshListeners.add((Object)listener);
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        fSelectionChangedListeners.add((Object)listener);
    }

    public IMonitorControl createMonitorControl(String type, String remoteServicesId, String connectionName) {
        MonitorControl monitor = new MonitorControl(MonitorControlManager.generateMonitorId(remoteServicesId, connectionName, type));
        monitor.setRemoteServicesId(remoteServicesId);
        monitor.setConnectionName(connectionName);
        monitor.setSystemType(type);
        monitor.save();
        this.addMonitorControl(monitor);
        this.saveMonitors();
        return monitor;
    }

    public void fireMonitorAdded(final IMonitorControl[] monitors) {
        UIJob job = new UIJob(Messages.MonitorControlManager_monitorAddedJobName){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                Object[] objectArray = fMonitorChangedListeners.getListeners();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object listener = objectArray[n2];
                    ((IMonitorChangedListener)listener).monitorAdded(monitors);
                    ++n2;
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    public void fireMonitorRefresh(final IMonitorControl[] monitors) {
        UIJob job = new UIJob(Messages.MonitorControlManager_monitoRefreshJobName){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                Object[] objectArray = fMonitorRefreshListeners.getListeners();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object listener = objectArray[n2];
                    ((IMonitorRefreshListener)listener).refresh(monitors);
                    ++n2;
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    public void fireMonitorRemoved(final IMonitorControl[] monitors) {
        UIJob job = new UIJob(Messages.MonitorControlManager_monitorRemovedJobName){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                Object[] objectArray = fMonitorChangedListeners.getListeners();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object listener = objectArray[n2];
                    ((IMonitorChangedListener)listener).monitorRemoved(monitors);
                    ++n2;
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    public void fireMonitorUpdated(final IMonitorControl[] monitors) {
        UIJob job = new UIJob(Messages.MonitorControlManager_monitorUpdatedJobName){

            public IStatus runInUIThread(IProgressMonitor progress) {
                Object[] objectArray = fMonitorChangedListeners.getListeners();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object listener = objectArray[n2];
                    ((IMonitorChangedListener)listener).monitorUpdated(monitors);
                    ++n2;
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    public void fireSelectionChanged(final SelectionChangedEvent event) {
        UIJob job = new UIJob(Messages.MonitorControlManager_monitorSelectionChangedJobName){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                IStructuredSelection sel;
                Object[] objectArray = fSelectionChangedListeners.getListeners();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object listener = objectArray[n2];
                    ((ISelectionChangedListener)listener).selectionChanged(event);
                    ++n2;
                }
                String monitorId = null;
                if (event.getSelection() instanceof IStructuredSelection && !(sel = (IStructuredSelection)event.getSelection()).isEmpty()) {
                    monitorId = ((IMonitorControl)sel.getFirstElement()).getMonitorId();
                }
                LMLManager.getInstance().selectLgui(monitorId);
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    public IMonitorControl getMonitorControl(IRemoteConnection connection, String monitorType) {
        return this.fMonitorControls.get(MonitorControlManager.generateMonitorId(connection.getRemoteServices().getId(), connection.getName(), monitorType));
    }

    public IMonitorControl getMonitorControl(String remoteServicesId, String connectionName, String monitorType) {
        return this.fMonitorControls.get(MonitorControlManager.generateMonitorId(remoteServicesId, connectionName, monitorType));
    }

    public Collection<IMonitorControl> getMonitorControls() {
        return Collections.unmodifiableCollection(this.fMonitorControls.values());
    }

    public void removeMonitorChangedListener(IMonitorChangedListener listener) {
        fMonitorChangedListeners.remove((Object)listener);
    }

    public void removeMonitorControls(IMonitorControl[] monitors) {
        IMonitorControl[] iMonitorControlArray = monitors;
        int n = monitors.length;
        int n2 = 0;
        while (n2 < n) {
            IMonitorControl monitor = iMonitorControlArray[n2];
            this.fMonitorControls.remove(monitor.getMonitorId());
            monitor.dispose();
            ++n2;
        }
        this.saveMonitors();
        this.fireMonitorRemoved(monitors);
    }

    public void removeMonitorRefreshListener(IMonitorChangedListener listener) {
        fMonitorRefreshListeners.remove((Object)listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        fSelectionChangedListeners.remove((Object)listener);
    }

    public void start() {
        this.fMonitorControls.clear();
        this.fMonitorControlsToStart.clear();
        this.loadMonitors();
        this.startMonitors();
    }

    public void stop() throws CoreException {
        this.stopMonitors();
    }

    private void addMonitorControl(IMonitorControl monitor) {
        this.fMonitorControls.put(monitor.getMonitorId(), monitor);
        this.fireMonitorAdded(new IMonitorControl[]{monitor});
    }

    private File getSaveLocation() {
        return LMLMonitorCorePlugin.getDefault().getStateLocation().append(MONITORS_SAVED_STATE).toFile();
    }

    private void loadMonitor(IMemento memento) {
        try {
            MonitorControl monitor = new MonitorControl(memento.getID());
            if (monitor.load()) {
                this.fMonitorControlsToStart.add(monitor);
            }
            this.addMonitorControl(monitor);
        }
        catch (CoreException e) {
            LMLMonitorCorePlugin.log(e.getLocalizedMessage());
        }
    }

    private void loadMonitors() {
        try {
            IMemento[] monitorsMemento;
            FileReader reader = new FileReader(this.getSaveLocation());
            XMLMemento memento = XMLMemento.createReadRoot((Reader)reader);
            IMemento[] iMementoArray = monitorsMemento = memento.getChildren(MONITOR_ID_ATTR);
            int n = monitorsMemento.length;
            int n2 = 0;
            while (n2 < n) {
                IMemento monitorMemento = iMementoArray[n2];
                this.loadMonitor(monitorMemento);
                ++n2;
            }
        }
        catch (FileNotFoundException e) {
            LMLMonitorCorePlugin.log(e.getLocalizedMessage());
        }
        catch (WorkbenchException e) {
            LMLMonitorCorePlugin.log(e.getLocalizedMessage());
        }
    }

    private void saveMonitors() {
        XMLMemento memento = XMLMemento.createWriteRoot((String)MONITORS_ATTR);
        for (IMonitorControl monitor : this.fMonitorControls.values()) {
            memento.createChild(MONITOR_ID_ATTR, monitor.getMonitorId());
        }
        try {
            FileWriter writer = new FileWriter(this.getSaveLocation());
            memento.save((Writer)writer);
        }
        catch (IOException e) {
            LMLMonitorCorePlugin.log(e.getLocalizedMessage());
        }
    }

    private void startMonitors() {
    }

    private void stopMonitors() {
        for (IMonitorControl monitor : this.fMonitorControls.values()) {
            try {
                monitor.stop();
            }
            catch (CoreException e) {
                LMLMonitorCorePlugin.log(e.getLocalizedMessage());
            }
        }
    }
}

